/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.javacrumbs.jsonunit.core.ConfigurationWhen;
import net.javacrumbs.jsonunit.core.Matchers;
import net.javacrumbs.jsonunit.core.NumberComparator;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.Options;
import net.javacrumbs.jsonunit.core.internal.DefaultNumberComparator;
import net.javacrumbs.jsonunit.core.internal.PathOption;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import org.hamcrest.Matcher;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class Configuration {
    private static final DifferenceListener DUMMY_LISTENER = (difference, context) -> {};
    private static final String DEFAULT_IGNORE_PLACEHOLDER = "${json-unit.ignore}";
    private static final String ALTERNATIVE_IGNORE_PLACEHOLDER = "#{json-unit.ignore}";
    private static final DefaultNumberComparator DEFAULT_NUMBER_COMPARATOR = new DefaultNumberComparator();
    private static final Configuration EMPTY_CONFIGURATION = new Configuration(null, Options.empty(), "${json-unit.ignore}", Matchers.empty(), Collections.emptySet(), DUMMY_LISTENER, Collections.emptyList(), DEFAULT_NUMBER_COMPARATOR);
    private final BigDecimal tolerance;
    private final Options options;
    private final String ignorePlaceholder;
    private final Matchers matchers;
    private final List<PathOption> pathOptions;
    private final Set<String> pathsToBeIgnored;
    private final DifferenceListener differenceListener;
    private final NumberComparator numberComparator;

    private Configuration(@Nullable BigDecimal tolerance, Options options, String ignorePlaceholder, Matchers matchers, Set<String> pathsToBeIgnored, DifferenceListener differenceListener, List<PathOption> pathOptions, NumberComparator numberComparator) {
        this.tolerance = tolerance;
        this.options = options;
        this.ignorePlaceholder = ignorePlaceholder;
        this.matchers = matchers;
        this.pathsToBeIgnored = pathsToBeIgnored;
        this.pathOptions = pathOptions;
        this.differenceListener = differenceListener;
        this.numberComparator = numberComparator;
    }

    public static @NonNull Configuration empty() {
        return EMPTY_CONFIGURATION;
    }

    public @NonNull Configuration withTolerance(@Nullable BigDecimal tolerance) {
        return new Configuration(tolerance, this.options, this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener, this.pathOptions, this.numberComparator);
    }

    public @NonNull Configuration withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public @NonNull Configuration when(@NonNull Option first, Option ... next) {
        return this.withOptions(first, next);
    }

    public @NonNull Configuration withOptions(@NonNull Option first, Option ... next) {
        return new Configuration(this.tolerance, this.options.with(first, next), this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener, this.pathOptions, this.numberComparator);
    }

    public @NonNull Configuration withOptions(@NonNull Collection<Option> optionsToAdd) {
        return new Configuration(this.tolerance, this.options.with(optionsToAdd), this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener, this.pathOptions, this.numberComparator);
    }

    public @NonNull Configuration resetOptions() {
        return new Configuration(this.tolerance, Options.empty(), this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener, this.pathOptions, this.numberComparator);
    }

    public final @NonNull Configuration when( @NonNull ConfigurationWhen.PathsParam object, ConfigurationWhen.ApplicableForPath ... actions) {
        Configuration configuration = this;
        for (ConfigurationWhen.ApplicableForPath action : actions) {
            configuration = object.apply(configuration, action);
        }
        return configuration;
    }

    @NonNull Configuration addPathOption(@NonNull PathOption pathOption) {
        ArrayList<PathOption> newOptions = new ArrayList<PathOption>(this.pathOptions);
        newOptions.add(pathOption);
        return this.withPathOptions(newOptions);
    }

    public @NonNull Configuration withPathOptions(@NonNull List<PathOption> pathOptions) {
        return new Configuration(this.tolerance, this.options, this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener, List.copyOf(pathOptions), this.numberComparator);
    }

    public @NonNull Configuration whenIgnoringPaths(@NonNull Collection<String> pathsToBeIgnored) {
        return new Configuration(this.tolerance, this.options, this.ignorePlaceholder, this.matchers, Set.copyOf(pathsToBeIgnored), this.differenceListener, this.pathOptions, this.numberComparator);
    }

    public @NonNull Configuration whenIgnoringPaths(String ... pathsToBeIgnored) {
        return this.whenIgnoringPaths(Arrays.asList(pathsToBeIgnored));
    }

    public @NonNull Configuration withIgnorePlaceholder(@NonNull String ignorePlaceholder) {
        return new Configuration(this.tolerance, this.options, ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener, this.pathOptions, this.numberComparator);
    }

    public @NonNull Configuration withMatcher(@NonNull String matcherName, @NonNull Matcher<?> matcher) {
        return new Configuration(this.tolerance, this.options, this.ignorePlaceholder, this.matchers.with(matcherName, matcher), this.pathsToBeIgnored, this.differenceListener, this.pathOptions, this.numberComparator);
    }

    public @NonNull Configuration withDifferenceListener(@NonNull DifferenceListener differenceListener) {
        return new Configuration(this.tolerance, this.options, this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, differenceListener, this.pathOptions, this.numberComparator);
    }

    public @NonNull Configuration withNumberComparator(@NonNull NumberComparator numberComparator) {
        return new Configuration(this.tolerance, this.options, this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener, this.pathOptions, numberComparator);
    }

    public static @NonNull DifferenceListener dummyDifferenceListener() {
        return DUMMY_LISTENER;
    }

    public @Nullable Matcher<?> getMatcher(String matcherName) {
        return this.matchers.getMatcher(matcherName);
    }

    public @Nullable BigDecimal getTolerance() {
        return this.tolerance;
    }

    public @NonNull Set<Option> getOptions() {
        return this.options.values();
    }

    public @NonNull String getIgnorePlaceholder() {
        return this.ignorePlaceholder;
    }

    public @NonNull List<PathOption> getPathOptions() {
        return this.pathOptions;
    }

    public @NonNull Set<String> getPathsToBeIgnored() {
        return this.pathsToBeIgnored;
    }

    public @NonNull DifferenceListener getDifferenceListener() {
        return this.differenceListener;
    }

    public @NonNull NumberComparator getNumberComparator() {
        return this.numberComparator;
    }

    public boolean shouldIgnore(String expectedValue) {
        if (DEFAULT_IGNORE_PLACEHOLDER.equals(this.ignorePlaceholder)) {
            return DEFAULT_IGNORE_PLACEHOLDER.equals(expectedValue) || ALTERNATIVE_IGNORE_PLACEHOLDER.equals(expectedValue);
        }
        return this.ignorePlaceholder.equals(expectedValue);
    }
}

