/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.NodeWrapper;
import org.jetbrains.annotations.NotNull;

public interface Node {
    public static final Node MISSING_NODE = new Node(){

        @Override
        public Node element(int index) {
            return MISSING_NODE;
        }

        @Override
        public Iterator<KeyValue> fields() {
            return Collections.emptyIterator();
        }

        @Override
        public Node get(String key) {
            return this;
        }

        @Override
        public boolean isMissingNode() {
            return true;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public Iterator<Node> arrayElements() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public String asText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NodeType getNodeType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal decimalValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean asBoolean() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public void ___do_not_implement_this_interface_seriously() {
        }

        public String toString() {
            return "<missing>";
        }
    };

    public Node element(int var1);

    public Iterator<KeyValue> fields();

    public Node get(String var1);

    public boolean isMissingNode();

    public boolean isNull();

    public Iterator<Node> arrayElements();

    public int size();

    public String asText();

    public NodeType getNodeType();

    public BigDecimal decimalValue();

    default public boolean isIntegralNumber() {
        BigDecimal decimalValue = this.decimalValue();
        String text = decimalValue.toString();
        return decimalValue.scale() == 0 && !text.contains("e") && !text.contains("E");
    }

    public Boolean asBoolean();

    public Object getValue();

    public void ___do_not_implement_this_interface_seriously();

    public static class JsonList
    extends LinkedList<Object>
    implements NodeWrapper {
        private final Node wrappedNode;

        JsonList(Node node) {
            Iterator<Node> nodeIterator = node.arrayElements();
            while (nodeIterator.hasNext()) {
                Node arrayNode = nodeIterator.next();
                this.add(arrayNode.getValue());
            }
            this.wrappedNode = node;
        }

        @Override
        public Node getWrappedNode() {
            return this.wrappedNode;
        }
    }

    public static class JsonMap
    extends AbstractMap<String, Object>
    implements NodeWrapper {
        private final Node wrappedNode;
        private Set<Map.Entry<String, Object>> entrySet;

        JsonMap(Node node) {
            this.wrappedNode = node;
        }

        @Override
        @NotNull
        public Set<Map.Entry<String, Object>> entrySet() {
            if (this.entrySet == null) {
                Iterator<KeyValue> fields = this.wrappedNode.fields();
                this.entrySet = StreamSupport.stream(Spliterators.spliteratorUnknownSize(fields, 0), false).map(keyValue -> new AbstractMap.SimpleEntry<String, Object>(keyValue.getKey(), keyValue.getValue().getValue())).collect(Collectors.toSet());
            }
            return this.entrySet;
        }

        @Override
        public String toString() {
            return JsonUtils.prettyPrint(this);
        }

        @Override
        public Node getWrappedNode() {
            return this.wrappedNode;
        }
    }

    public static interface ValueExtractor {
        public Object getValue(Node var1);
    }

    public static class KeyValue {
        private final String key;
        private final Node value;

        KeyValue(String key, Node value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Node getValue() {
            return this.value;
        }

        public String toString() {
            return "{\"" + this.key + "\": " + this.value + "}";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum NodeType implements ValueExtractor
    {
        OBJECT("object"){

            @Override
            public Object getValue(Node node) {
                return new JsonMap(node);
            }
        }
        ,
        ARRAY("array"){

            @Override
            public Object getValue(Node node) {
                return new JsonList(node);
            }
        }
        ,
        STRING("string"){

            @Override
            public Object getValue(Node node) {
                return node.asText();
            }
        }
        ,
        NUMBER("number"){

            @Override
            public Object getValue(Node node) {
                return node.decimalValue();
            }
        }
        ,
        BOOLEAN("boolean"){

            @Override
            public Object getValue(Node node) {
                return node.asBoolean();
            }
        }
        ,
        NULL("null"){

            @Override
            public Object getValue(Node node) {
                return null;
            }
        };

        private final String description;

        private NodeType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

