/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.util.List;
import java.util.stream.Collectors;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.ComparisonMatrix;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Path;

class ArrayComparison {
    private final ComparisonMatrix comparisonMatrix;
    private final List<Node> actualElements;
    private final List<Node> expectedElements;

    ArrayComparison(List<Node> expectedElements, List<Node> actualElements, Path path, Configuration configuration) {
        this.comparisonMatrix = new ComparisonMatrix(expectedElements, actualElements, path, configuration);
        this.actualElements = actualElements;
        this.expectedElements = expectedElements;
    }

    ComparisonResult compareArraysIgnoringOrder() {
        return new ComparisonResult(this.comparisonMatrix.compare(), this.expectedElements, this.actualElements);
    }

    static class ComparisonResult {
        private final List<NodeWithIndex> extraValues;
        private final List<NodeWithIndex> missingValues;

        private ComparisonResult(ComparisonMatrix result, List<Node> expectedElements, List<Node> actualElements) {
            this.extraValues = result.getExtra().stream().map(i -> new NodeWithIndex((Node)actualElements.get((int)i), (int)i)).collect(Collectors.toList());
            this.missingValues = result.getMissing().stream().map(i -> new NodeWithIndex((Node)expectedElements.get((int)i), (int)i)).collect(Collectors.toList());
        }

        public List<NodeWithIndex> getExtraValues() {
            return this.extraValues;
        }

        public List<NodeWithIndex> getMissingValues() {
            return this.missingValues;
        }
    }

    record NodeWithIndex(Node node, int index) {
        @Override
        public String toString() {
            return this.node.toString();
        }
    }
}

