/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.util.ArrayList;
import java.util.List;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUnitLogger;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Path;

class ArrayComparison {
    private final int compareFrom;
    private final List<Node> actualElements;
    private final List<NodeWithIndex> extraValues;
    private final List<NodeWithIndex> missingValues;
    private final Path path;
    private final Configuration configuration;

    private ArrayComparison(int compareFrom, List<Node> actualElements, List<NodeWithIndex> extraValues, List<NodeWithIndex> missingValues, Path path, Configuration configuration) {
        this.compareFrom = compareFrom;
        this.actualElements = actualElements;
        this.extraValues = extraValues;
        this.missingValues = missingValues;
        this.path = path;
        this.configuration = configuration;
    }

    ArrayComparison(List<Node> expectedElements, List<Node> actualElements, Path path, Configuration configuration) {
        this(0, actualElements, new ArrayList<NodeWithIndex>(), new ArrayList<NodeWithIndex>(ArrayComparison.addIndex(expectedElements)), path, configuration);
    }

    private static List<NodeWithIndex> addIndex(List<Node> expectedElements) {
        ArrayList<NodeWithIndex> result = new ArrayList<NodeWithIndex>(expectedElements.size());
        for (int i = 0; i < expectedElements.size(); ++i) {
            result.add(new NodeWithIndex(expectedElements.get(i), i));
        }
        return result;
    }

    private ArrayComparison copy(int compareFrom) {
        return new ArrayComparison(compareFrom, this.actualElements, new ArrayList<NodeWithIndex>(this.extraValues), new ArrayList<NodeWithIndex>(this.missingValues), this.path, this.configuration);
    }

    ArrayComparison compareArraysIgnoringOrder() {
        for (int i = this.compareFrom; i < this.actualElements.size(); ++i) {
            Node actual = this.actualElements.get(i);
            List<Integer> matches = this.indexOf(this.missingValues, actual);
            if (matches.size() == 1) {
                this.removeMissing(matches.get(0));
                continue;
            }
            if (matches.size() > 0) {
                for (int match : matches) {
                    ArrayComparison copy = this.copy(i + 1);
                    copy.removeMissing(match);
                    if (!(copy = copy.compareArraysIgnoringOrder()).isMatching()) continue;
                    return copy;
                }
                this.removeMissing(matches.get(0));
                continue;
            }
            this.addExtra(new NodeWithIndex(actual, i));
        }
        return this;
    }

    private void removeMissing(int index) {
        this.missingValues.remove(index);
    }

    private void addExtra(NodeWithIndex actual) {
        this.extraValues.add(actual);
    }

    private List<Integer> indexOf(List<NodeWithIndex> expectedElements, Node actual) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        for (NodeWithIndex expected : expectedElements) {
            Diff diff = new Diff(expected.getNode(), actual, Path.create("", this.path.toElement(i).getFullPath()), this.configuration.withDifferenceListener(Configuration.dummyDifferenceListener()), JsonUnitLogger.NULL_LOGGER, JsonUnitLogger.NULL_LOGGER, "expected: <%s> but was: <%s>");
            if (diff.similar()) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    private boolean isMatching() {
        return this.missingValues.isEmpty() && (this.extraValues.isEmpty() || !this.configuration.getOptions().contains(Option.IGNORING_EXTRA_ARRAY_ITEMS));
    }

    List<NodeWithIndex> getMissingValues() {
        return this.missingValues;
    }

    List<NodeWithIndex> getExtraValues() {
        return this.extraValues;
    }

    static class NodeWithIndex {
        private final Node node;
        private final int index;

        NodeWithIndex(Node node, int index) {
            this.node = node;
            this.index = index;
        }

        public Node getNode() {
            return this.node;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.node.toString();
        }
    }
}

