/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.util.List;
import net.javacrumbs.jsonunit.core.internal.Differences;
import net.javacrumbs.jsonunit.core.internal.JsonAssertError;
import net.javacrumbs.jsonunit.core.internal.JsonDifference;

class ExceptionUtils {
    private static final String ROOT_MESSAGE = "JSON documents are different:\n";

    ExceptionUtils() {
    }

    static String formatDifferences(String message, Differences differences) {
        return ExceptionUtils.formatDifferences(message, differences.getDifferences());
    }

    static String formatDifferences(String message, List<JsonDifference> differences) {
        StringBuilder builder = new StringBuilder();
        if (!differences.isEmpty()) {
            ExceptionUtils.addHeading(message, builder);
            builder.append(ROOT_MESSAGE);
            for (JsonDifference difference : differences) {
                builder.append(difference.getMessage()).append("\n");
            }
        }
        String result = builder.toString();
        return result;
    }

    static AssertionError createException(String message, Differences diffs) {
        List<JsonDifference> differences = diffs.getDifferences();
        if (differences.size() == 1) {
            JsonDifference difference = differences.get(0);
            return new JsonDifference(message, difference);
        }
        return new JsonAssertError(message, diffs);
    }

    private static void addHeading(String message, StringBuilder builder) {
        if (message != null && !message.isEmpty()) {
            if (message.startsWith("[") && message.endsWith("] ")) {
                builder.append(message);
            } else {
                builder.append('[').append(message).append("] ");
            }
        }
    }
}

