/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.util.ArrayList;
import java.util.List;
import net.javacrumbs.jsonunit.core.internal.GsonNodeFactory;
import net.javacrumbs.jsonunit.core.internal.Jackson1NodeFactory;
import net.javacrumbs.jsonunit.core.internal.Jackson2NodeFactory;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.NodeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Converter {
    private final List<NodeFactory> factories;
    private static final boolean jackson1Present = Converter.isClassPresent("org.codehaus.jackson.map.ObjectMapper") && Converter.isClassPresent("org.codehaus.jackson.JsonGenerator");
    private static final boolean jackson2Present = Converter.isClassPresent("com.fasterxml.jackson.databind.ObjectMapper") && Converter.isClassPresent("com.fasterxml.jackson.core.JsonGenerator");
    private static final boolean gsonPresent = Converter.isClassPresent("com.google.gson.Gson");

    Converter(List<NodeFactory> factories) {
        if (factories.isEmpty()) {
            throw new IllegalStateException("List of factories can not be empty");
        }
        this.factories = factories;
    }

    public static Converter createDefaultConverter() {
        ArrayList<NodeFactory> factories = new ArrayList<NodeFactory>();
        if (jackson1Present) {
            factories.add(new Jackson1NodeFactory());
        }
        if (gsonPresent) {
            factories.add(new GsonNodeFactory());
        }
        if (jackson2Present) {
            factories.add(new Jackson2NodeFactory());
        }
        if (factories.isEmpty()) {
            throw new IllegalStateException("Please add either Jackson 1.x, Jackson 2.x or Gson to the classpath");
        }
        return new Converter(factories);
    }

    public Node convertToNode(Object source, String label) {
        for (int i = 0; i < this.factories.size(); ++i) {
            NodeFactory factory = this.factories.get(i);
            if (!this.isLastFactory(i) && !factory.isPreferredFor(source)) continue;
            return factory.convertToNode(source, label);
        }
        throw new IllegalStateException("Should not happen");
    }

    private boolean isLastFactory(int i) {
        return this.factories.size() - 1 == i;
    }

    static boolean isClassPresent(String className) {
        try {
            Converter.class.getClassLoader().loadClass(className);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

