/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.javacrumbs.jsonunit.core.Matchers;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Options;
import net.javacrumbs.jsonunit.core.listener.Difference;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import org.hamcrest.Matcher;

public class Configuration {
    private static final DifferenceListener DUMMY_LISTENER = new DifferenceListener(){

        @Override
        public void diff(Difference difference) {
        }
    };
    private static final Configuration EMPTY_CONFIGURATION = new Configuration(null, Options.empty(), "${json-unit.ignore}", Matchers.empty(), Collections.<String>emptySet(), DUMMY_LISTENER);
    private final BigDecimal tolerance;
    private final Options options;
    private final String ignorePlaceholder;
    private final Matchers matchers;
    private final Set<String> pathsToBeIgnored;
    private final DifferenceListener differenceListener;

    @Deprecated
    public Configuration(BigDecimal tolerance, Options options, String ignorePlaceholder) {
        this(tolerance, options, ignorePlaceholder, Matchers.empty(), Collections.emptySet(), DUMMY_LISTENER);
    }

    private Configuration(BigDecimal tolerance, Options options, String ignorePlaceholder, Matchers matchers, Collection<String> pathsToBeIgnored, DifferenceListener differenceListener) {
        this.tolerance = tolerance;
        this.options = options;
        this.ignorePlaceholder = ignorePlaceholder;
        this.matchers = matchers;
        this.pathsToBeIgnored = Collections.unmodifiableSet(new HashSet<String>(pathsToBeIgnored));
        this.differenceListener = differenceListener;
    }

    public static Configuration empty() {
        return EMPTY_CONFIGURATION;
    }

    public Configuration withTolerance(BigDecimal tolerance) {
        return new Configuration(tolerance, this.options, this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener);
    }

    public Configuration withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public Configuration when(Option first, Option ... next) {
        return this.withOptions(first, next);
    }

    public Configuration withOptions(Option first, Option ... next) {
        return new Configuration(this.tolerance, this.options.with(first, next), this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener);
    }

    public Configuration withOptions(Options options) {
        return new Configuration(this.tolerance, options, this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener);
    }

    public Configuration whenIgnoringPaths(String ... pathsToBeIgnored) {
        return new Configuration(this.tolerance, this.options, this.ignorePlaceholder, this.matchers, Arrays.asList(pathsToBeIgnored), this.differenceListener);
    }

    public Configuration withIgnorePlaceholder(String ignorePlaceholder) {
        return new Configuration(this.tolerance, this.options, ignorePlaceholder, this.matchers, this.pathsToBeIgnored, this.differenceListener);
    }

    public Configuration withMatcher(String matcherName, Matcher<?> matcher) {
        return new Configuration(this.tolerance, this.options, this.ignorePlaceholder, this.matchers.with(matcherName, matcher), this.pathsToBeIgnored, this.differenceListener);
    }

    public Configuration withDifferenceListener(DifferenceListener differenceListener) {
        return new Configuration(this.tolerance, this.options, this.ignorePlaceholder, this.matchers, this.pathsToBeIgnored, differenceListener);
    }

    public static DifferenceListener dummyDifferenceListener() {
        return DUMMY_LISTENER;
    }

    public Matcher<?> getMatcher(String matcherName) {
        return this.matchers.getMatcher(matcherName);
    }

    public BigDecimal getTolerance() {
        return this.tolerance;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getIgnorePlaceholder() {
        return this.ignorePlaceholder;
    }

    public Set<String> getPathsToBeIgnored() {
        return this.pathsToBeIgnored;
    }

    public DifferenceListener getDifferenceListener() {
        return this.differenceListener;
    }
}

