/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.javacrumbs.jsonunit.core.internal.AbstractNode;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.NodeBuilder;

class GenericNodeBuilder
implements NodeBuilder {
    GenericNodeBuilder() {
    }

    @Override
    public Node newNode(Object object) {
        if (object == null) {
            return new NullNode();
        }
        if (object instanceof Map) {
            return new ObjectNode((Map)object, this);
        }
        if (object instanceof Number) {
            return new NumberNode((Number)object);
        }
        if (object instanceof String) {
            return new StringNode((String)object);
        }
        if (object instanceof Boolean) {
            return new BooleanNode((Boolean)object);
        }
        if (object instanceof Object[]) {
            return new ArrayNode(Arrays.asList((Object[])object), this);
        }
        if (object instanceof int[]) {
            int[] array = (int[])object;
            ArrayList<Integer> list = new ArrayList<Integer>(array.length);
            for (int i : array) {
                list.add(i);
            }
            return new ArrayNode(list, this);
        }
        if (object instanceof double[]) {
            double[] array = (double[])object;
            ArrayList<Double> list = new ArrayList<Double>(array.length);
            for (double i : array) {
                list.add(i);
            }
            return new ArrayNode(list, this);
        }
        if (object instanceof List) {
            return new ArrayNode((List)object, this);
        }
        throw new IllegalArgumentException("Unsupported type " + object.getClass());
    }

    static final class ObjectNode
    extends NodeSkeleton
    implements Iterable<Node.KeyValue> {
        private final Map<String, Object> jsonObject;
        private final NodeBuilder nodeBuilder;

        ObjectNode(Map<String, Object> jsonObject, NodeBuilder nodeBuilder) {
            this.jsonObject = jsonObject;
            this.nodeBuilder = nodeBuilder;
        }

        @Override
        public Node element(int index) {
            return this.nodeBuilder.newNode(null);
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            final Iterator<String> iterator = this.jsonObject.keySet().iterator();
            return new Iterator<Node.KeyValue>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }

                @Override
                public Node.KeyValue next() {
                    String fieldName = (String)iterator.next();
                    return new Node.KeyValue(fieldName, ObjectNode.this.newNode(fieldName));
                }
            };
        }

        @Override
        public Iterator<Node.KeyValue> iterator() {
            return this.fields();
        }

        @Override
        public Node get(String key) {
            if (this.jsonObject.containsKey(key)) {
                return this.newNode(key);
            }
            return MISSING_NODE;
        }

        private Node newNode(String fieldName) {
            return this.nodeBuilder.newNode(this.jsonObject.get(fieldName));
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.OBJECT;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            for (Node.KeyValue kv : this) {
                builder.append('\"').append(kv.getKey()).append("\":").append(kv.getValue());
            }
            builder.append('}');
            return builder.toString();
        }
    }

    static final class ArrayNode
    extends NodeSkeleton {
        private final List<?> value;
        private final NodeBuilder nodeBuilder;

        ArrayNode(List<?> value, NodeBuilder nodeBuilder) {
            this.value = value;
            this.nodeBuilder = nodeBuilder;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.ARRAY;
        }

        @Override
        public Node element(int index) {
            try {
                return this.newNode(this.value.get(index));
            }
            catch (IndexOutOfBoundsException e) {
                return MISSING_NODE;
            }
        }

        @Override
        public Iterator<Node> arrayElements() {
            final Iterator<?> iterator = this.value.iterator();
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Node next() {
                    return ArrayNode.this.newNode(iterator.next());
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        private Node newNode(Object object) {
            return this.nodeBuilder.newNode(object);
        }

        @Override
        public int size() {
            return this.value.size();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            Iterator<Node> iterator = this.arrayElements();
            while (iterator.hasNext()) {
                Node value = iterator.next();
                builder.append(value.toString());
                if (!iterator.hasNext()) continue;
                builder.append(',');
            }
            builder.append(']');
            return builder.toString();
        }
    }

    static final class BooleanNode
    extends NodeSkeleton {
        private final Boolean value;

        BooleanNode(Boolean value) {
            this.value = value;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.BOOLEAN;
        }

        @Override
        public Boolean asBoolean() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    static final class StringNode
    extends NodeSkeleton {
        private final String value;

        StringNode(String value) {
            this.value = value;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.STRING;
        }

        @Override
        public String asText() {
            return this.value;
        }

        public String toString() {
            return '\"' + this.value + '\"';
        }
    }

    static class NumberNode
    extends NodeSkeleton {
        private final Number value;

        NumberNode(Number value) {
            this.value = value;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.NUMBER;
        }

        @Override
        public BigDecimal decimalValue() {
            return new BigDecimal(this.value.toString());
        }

        public String toString() {
            return this.decimalValue().toString();
        }
    }

    static class NullNode
    extends NodeSkeleton {
        NullNode() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.NULL;
        }

        public String toString() {
            return "null";
        }
    }

    static abstract class NodeSkeleton
    extends AbstractNode {
        NodeSkeleton() {
        }

        @Override
        public Node element(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node get(String key) {
            return MISSING_NODE;
        }

        @Override
        public boolean isMissingNode() {
            return false;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public Iterator<Node> arrayElements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String asText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal decimalValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean asBoolean() {
            throw new UnsupportedOperationException();
        }
    }
}

