/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Converter;
import net.javacrumbs.jsonunit.core.internal.Node;

public class JsonUtils {
    private static final Pattern arrayPattern = Pattern.compile("(.*)\\[(-?\\d+)\\]");
    public static final Pattern dotWithPreviousChar = Pattern.compile("[^\\\\]\\.");
    private static final Converter converter = Converter.createDefaultConverter();

    public static Node convertToJson(Object source, String label) {
        return JsonUtils.convertToJson(source, label, false);
    }

    public static Node convertToJson(Object source, String label, boolean lenient) {
        return converter.convertToNode(source, label, lenient);
    }

    static Node getNode(Node root, String path) {
        if (path.length() == 0) {
            return root;
        }
        Node startNode = root;
        Matcher pathMatcher = dotWithPreviousChar.matcher(path);
        int pos = 0;
        while (pathMatcher.find()) {
            String step = path.substring(pos, pathMatcher.end() - 1);
            pos = pathMatcher.end();
            startNode = JsonUtils.doStep(step, startNode);
        }
        startNode = JsonUtils.doStep(path.substring(pos), startNode);
        return startNode;
    }

    private static Node doStep(String step, Node startNode) {
        Matcher matcher = arrayPattern.matcher(step = step.replaceAll("\\\\.", "."));
        if (!matcher.matches()) {
            startNode = startNode.get(step);
        } else {
            int index;
            if (matcher.group(1).length() != 0) {
                startNode = startNode.get(matcher.group(1));
            }
            startNode = (index = Integer.valueOf(matcher.group(2)).intValue()) < 0 ? startNode.element(startNode.size() + index) : startNode.element(index);
        }
        return startNode;
    }

    public static Node getNode(Object root, String path) {
        return JsonUtils.getNode(JsonUtils.convertToJson(root, "actual"), path);
    }

    @Deprecated
    public static boolean nodeExists(Object json, String path) {
        return !JsonUtils.getNode(json, path).isMissingNode();
    }

    public static boolean nodeAbsent(Object json, String path, Configuration configuration) {
        return JsonUtils.nodeAbsent(json, path, configuration.getOptions().contains(Option.TREATING_NULL_AS_ABSENT));
    }

    static boolean nodeAbsent(Object json, String path, boolean treatNullAsAbsent) {
        Node node = JsonUtils.getNode(json, path);
        if (node.isNull()) {
            return treatNullAsAbsent;
        }
        return node.isMissingNode();
    }

    static String quoteIfNeeded(String source) {
        String trimmed = source.trim();
        if (JsonUtils.isObject(trimmed) || JsonUtils.isArray(trimmed) || JsonUtils.isString(trimmed) || JsonUtils.isBoolean(trimmed) || JsonUtils.isNull(trimmed) || JsonUtils.isNumber(trimmed)) {
            return source;
        }
        return "\"" + source + "\"";
    }

    static Object quoteIfNeeded(Object source) {
        if (source instanceof String) {
            return JsonUtils.quoteIfNeeded((String)source);
        }
        return source;
    }

    private static boolean isNull(String trimmed) {
        return trimmed.equals("null");
    }

    private static boolean isBoolean(String trimmed) {
        return trimmed.equals("true") || trimmed.equals("false");
    }

    private static boolean isString(String trimmed) {
        return trimmed.startsWith("\"");
    }

    private static boolean isArray(String trimmed) {
        return trimmed.startsWith("[");
    }

    private static boolean isObject(String trimmed) {
        return trimmed.startsWith("{");
    }

    private static boolean isNumber(String source) {
        try {
            Double.parseDouble(source);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

