/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.ParametrizedMatcher;
import net.javacrumbs.jsonunit.core.internal.ClassUtils;
import net.javacrumbs.jsonunit.core.internal.Differences;
import net.javacrumbs.jsonunit.core.internal.JsonUnitLogger;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.PathMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class Diff {
    private static final String REGEX_PLACEHOLDER = "${json-unit.regex}";
    private static final Pattern MATCHER_PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{json-unit.matches:(.+)\\}(.*)");
    private static final JsonUnitLogger DEFAULT_DIFF_LOGGER = Diff.createLogger("net.javacrumbs.jsonunit.difference.diff");
    private static final JsonUnitLogger DEFAULT_VALUE_LOGGER = Diff.createLogger("net.javacrumbs.jsonunit.difference.values");
    private final Node expectedRoot;
    private final Node actualRoot;
    private final Differences differences = new Differences();
    private final String startPath;
    private boolean compared = false;
    private final Configuration configuration;
    private final PathMatcher pathsToBeIgnored;
    private final JsonUnitLogger diffLogger;
    private final JsonUnitLogger valuesLogger;

    private Diff(Node expected, Node actual, String startPath, Configuration configuration, JsonUnitLogger diffLogger, JsonUnitLogger valuesLogger) {
        this.expectedRoot = expected;
        this.actualRoot = actual;
        this.startPath = startPath;
        this.configuration = configuration;
        this.diffLogger = diffLogger;
        this.valuesLogger = valuesLogger;
        this.pathsToBeIgnored = PathMatcher.create(configuration.getPathsToBeIgnored());
    }

    public static Diff create(Object expected, Object actual, String actualName, String startPath, Configuration configuration) {
        return new Diff(JsonUtils.convertToJson(JsonUtils.quoteIfNeeded(expected), "expected", true), JsonUtils.convertToJson(actual, actualName, false), startPath, configuration, DEFAULT_DIFF_LOGGER, DEFAULT_VALUE_LOGGER);
    }

    private void compare() {
        if (!this.compared) {
            Node part = JsonUtils.getNode(this.actualRoot, this.startPath);
            if (part.isMissingNode()) {
                this.structureDifferenceFound("Missing node in path \"%s\".", this.startPath);
            } else {
                this.compareNodes(this.expectedRoot, part, this.startPath);
            }
            this.compared = true;
        }
    }

    private void compareObjectNodes(Node expected, Node actual, String path) {
        Set<String> actualKeys;
        Map<String, Node> expectedFields = Diff.getFields(expected);
        Map<String, Node> actualFields = Diff.getFields(actual);
        Set<String> expectedKeys = expectedFields.keySet();
        if (!expectedKeys.equals(actualKeys = actualFields.keySet())) {
            Set<String> missingKeys = Diff.getMissingKeys(expectedKeys, actualKeys);
            Set<String> extraKeys = this.getExtraKeys(expectedKeys, actualKeys);
            if (this.hasOption(Option.TREATING_NULL_AS_ABSENT)) {
                extraKeys = this.getNotNullExtraKeys(actual, extraKeys);
            }
            this.removePathsToBeIgnored(path, extraKeys);
            if (!missingKeys.isEmpty() || !extraKeys.isEmpty()) {
                String missingKeysMessage = Diff.getMissingKeysMessage(missingKeys, path);
                String extraKeysMessage = Diff.getExtraKeysMessage(extraKeys, path);
                this.structureDifferenceFound("Different keys found in node \"%s\", expected: <%s> but was: <%s>. %s %s", path, this.sort(expectedFields.keySet()), this.sort(actualFields.keySet()), missingKeysMessage, extraKeysMessage);
            }
        }
        for (String fieldName : this.commonFields(expectedFields, actualFields)) {
            Node expectedNode = expectedFields.get(fieldName);
            Node actualNode = actualFields.get(fieldName);
            String fieldPath = Diff.getPath(path, fieldName);
            this.compareNodes(expectedNode, actualNode, fieldPath);
        }
    }

    private void removePathsToBeIgnored(String path, Set<String> extraKeys) {
        if (!this.configuration.getPathsToBeIgnored().isEmpty()) {
            Iterator<String> iterator = extraKeys.iterator();
            while (iterator.hasNext()) {
                String keyWithPath = Diff.getPath(path, iterator.next());
                if (!this.shouldIgnorePath(keyWithPath)) continue;
                iterator.remove();
            }
        }
    }

    private Set<String> getNotNullExtraKeys(Node actual, Set<String> extraKeys) {
        TreeSet<String> notNullExtraKeys = new TreeSet<String>();
        for (String extraKey : extraKeys) {
            if (actual.get(extraKey).isNull()) continue;
            notNullExtraKeys.add(extraKey);
        }
        return notNullExtraKeys;
    }

    private static String getMissingKeysMessage(Set<String> missingKeys, String path) {
        if (!missingKeys.isEmpty()) {
            return "Missing: " + Diff.appendKeysToPrefix(missingKeys, path);
        }
        return "";
    }

    private static Set<String> getMissingKeys(Set<String> expectedKeys, Collection<String> actualKeys) {
        TreeSet<String> missingKeys = new TreeSet<String>(expectedKeys);
        missingKeys.removeAll(actualKeys);
        return missingKeys;
    }

    private static String getExtraKeysMessage(Set<String> extraKeys, String path) {
        if (!extraKeys.isEmpty()) {
            return "Extra: " + Diff.appendKeysToPrefix(extraKeys, path);
        }
        return "";
    }

    private Set<String> getExtraKeys(Set<String> expectedKeys, Collection<String> actualKeys) {
        if (!this.hasOption(Option.IGNORING_EXTRA_FIELDS)) {
            TreeSet<String> extraKeys = new TreeSet<String>(actualKeys);
            extraKeys.removeAll(expectedKeys);
            return extraKeys;
        }
        return Collections.emptySet();
    }

    private boolean hasOption(Option option) {
        return this.configuration.getOptions().contains(option);
    }

    private static String appendKeysToPrefix(Iterable<String> keys, String prefix) {
        Iterator<String> iterator = keys.iterator();
        StringBuilder buffer = new StringBuilder();
        while (iterator.hasNext()) {
            String key = iterator.next();
            buffer.append("\"").append(Diff.getPath(prefix, key)).append("\"");
            if (!iterator.hasNext()) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    private void compareNodes(Node expectedNode, Node actualNode, String fieldPath) {
        if (this.shouldIgnorePath(fieldPath)) {
            return;
        }
        Node.NodeType expectedNodeType = expectedNode.getNodeType();
        Node.NodeType actualNodeType = actualNode.getNodeType();
        if (expectedNodeType == Node.NodeType.STRING && this.configuration.getIgnorePlaceholder().equals(expectedNode.asText())) {
            return;
        }
        if (this.checkAny(Node.NodeType.NUMBER, "${json-unit.any-number}", "a number", expectedNode, actualNode, fieldPath)) {
            return;
        }
        if (this.checkAny(Node.NodeType.BOOLEAN, "${json-unit.any-boolean}", "a boolean", expectedNode, actualNode, fieldPath)) {
            return;
        }
        if (this.checkAny(Node.NodeType.STRING, "${json-unit.any-string}", "a string", expectedNode, actualNode, fieldPath)) {
            return;
        }
        if (this.checkMatcher(expectedNode, actualNode, fieldPath)) {
            return;
        }
        if (!expectedNodeType.equals(actualNodeType)) {
            this.valueDifferenceFound("Different value found in node \"%s\", expected: <%s> but was: <%s>.", fieldPath, Diff.quoteTextValue(expectedNode), Diff.quoteTextValue(actualNode));
        } else {
            switch (expectedNodeType) {
                case OBJECT: {
                    this.compareObjectNodes(expectedNode, actualNode, fieldPath);
                    break;
                }
                case ARRAY: {
                    this.compareArrayNodes(expectedNode, actualNode, fieldPath);
                    break;
                }
                case STRING: {
                    this.compareStringValues(expectedNode.asText(), actualNode.asText(), fieldPath);
                    break;
                }
                case NUMBER: {
                    BigDecimal actualValue = actualNode.decimalValue();
                    BigDecimal expectedValue = expectedNode.decimalValue();
                    if (this.configuration.getTolerance() != null && !this.hasOption(Option.IGNORING_VALUES)) {
                        BigDecimal diff = expectedValue.subtract(actualValue).abs();
                        if (diff.compareTo(this.configuration.getTolerance()) <= 0) break;
                        this.valueDifferenceFound("Different value found in node \"%s\", expected: <%s> but was: <%s>, difference is %s, tolerance is %s", fieldPath, Diff.quoteTextValue(expectedValue), Diff.quoteTextValue(actualValue), diff.toString(), this.configuration.getTolerance());
                        break;
                    }
                    this.compareValues(expectedValue, actualValue, fieldPath);
                    break;
                }
                case BOOLEAN: {
                    this.compareValues(expectedNode.asBoolean(), actualNode.asBoolean(), fieldPath);
                    break;
                }
                case NULL: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected node type " + expectedNodeType);
                }
            }
        }
    }

    private boolean shouldIgnorePath(String fieldPath) {
        return this.pathsToBeIgnored.matches(fieldPath);
    }

    private boolean checkMatcher(Node expectedNode, Node actualNode, Object fieldPath) {
        java.util.regex.Matcher patternMatcher;
        if (expectedNode.getNodeType() == Node.NodeType.STRING && (patternMatcher = MATCHER_PLACEHOLDER_PATTERN.matcher(expectedNode.asText())).matches()) {
            String matcherName = patternMatcher.group(1);
            Matcher<?> matcher = this.configuration.getMatcher(matcherName);
            if (matcher != null) {
                Object value;
                if (matcher instanceof ParametrizedMatcher) {
                    ((ParametrizedMatcher)matcher).setParameter(patternMatcher.group(2));
                }
                if (!matcher.matches(value = actualNode.getValue())) {
                    StringDescription description = new StringDescription();
                    matcher.describeMismatch(value, (Description)description);
                    this.valueDifferenceFound("Matcher \"%s\" does not match value %s in node \"%s\". %s", matcherName, Diff.quoteTextValue(actualNode), fieldPath, description);
                }
            } else {
                this.structureDifferenceFound("Matcher \"%s\" not found.", matcherName);
            }
            return true;
        }
        return false;
    }

    private boolean checkAny(Node.NodeType type, String placeholder, String name, Node expectedNode, Node actualNode, String fieldPath) {
        if (expectedNode.getNodeType() == Node.NodeType.STRING && placeholder.equals(expectedNode.asText())) {
            if (actualNode.getNodeType() == type) {
                return true;
            }
            this.valueDifferenceFound("Different value found in node \"%s\", expected: <%s> but was: <%s>.", fieldPath, name, Diff.quoteTextValue(actualNode));
            return true;
        }
        return false;
    }

    private void compareStringValues(String expectedValue, String actualValue, String path) {
        if (this.hasOption(Option.IGNORING_VALUES)) {
            return;
        }
        if (this.isRegexExpected(expectedValue)) {
            String pattern = this.getRegexPattern(expectedValue);
            if (!actualValue.matches(pattern)) {
                this.valueDifferenceFound("Different value found in node \"%s\". Pattern %s did not match %s.", path, Diff.quoteTextValue(pattern), Diff.quoteTextValue(actualValue));
            }
        } else {
            this.compareValues(expectedValue, actualValue, path);
        }
    }

    private String getRegexPattern(String expectedValue) {
        return expectedValue.substring(REGEX_PLACEHOLDER.length());
    }

    private boolean isRegexExpected(String expectedValue) {
        return expectedValue.startsWith(REGEX_PLACEHOLDER);
    }

    private void compareValues(Object expectedValue, Object actualValue, String path) {
        if (!this.hasOption(Option.IGNORING_VALUES) && !expectedValue.equals(actualValue)) {
            this.valueDifferenceFound("Different value found in node \"%s\", expected: <%s> but was: <%s>.", path, Diff.quoteTextValue(expectedValue), Diff.quoteTextValue(actualValue));
        }
    }

    public static Object quoteTextValue(Object value) {
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        return value;
    }

    private void compareArrayNodes(Node expectedNode, Node actualNode, String path) {
        block7: {
            List<Node> actualElements;
            List<Node> expectedElements;
            block5: {
                List missingValues;
                block8: {
                    List extraValues;
                    block6: {
                        expectedElements = this.asList(expectedNode.arrayElements());
                        actualElements = this.asList(actualNode.arrayElements());
                        if (this.failOnExtraArrayItems()) {
                            if (expectedElements.size() != actualElements.size()) {
                                this.structureDifferenceFound("Array \"%s\" has different length, expected: <%d> but was: <%d>.", path, expectedElements.size(), actualElements.size());
                            }
                        } else if (expectedElements.size() > actualElements.size()) {
                            this.structureDifferenceFound("Array \"%s\" has invalid length, expected: <at least %d> but was: <%d>.", path, expectedElements.size(), actualElements.size());
                        }
                        if (!this.hasOption(Option.IGNORING_ARRAY_ORDER)) break block5;
                        ArrayComparison arrayComparison = this.compareArraysIgnoringOrder(expectedElements, actualElements);
                        missingValues = arrayComparison.missingValues;
                        extraValues = arrayComparison.extraValues;
                        if (expectedElements.size() != actualElements.size() || missingValues.size() != 1 || extraValues.size() != 1) break block6;
                        Node missing = (Node)missingValues.get(0);
                        Node extra = (Node)extraValues.get(0);
                        List<Integer> missingIndex = this.indexOf(expectedElements, missing);
                        List<Integer> extraIndex = this.indexOf(actualElements, extra);
                        this.valueDifferenceFound("Different value found when comparing expected array element %s to actual element %s.", this.getArrayPath(path, missingIndex.get(0)), this.getArrayPath(path, extraIndex.get(0)));
                        this.compareNodes(missing, extra, this.getArrayPath(path, extraIndex.get(0)));
                        break block7;
                    }
                    if (!this.failOnExtraArrayItems() || missingValues.isEmpty() && extraValues.isEmpty()) break block8;
                    this.valueDifferenceFound("Array \"%s\" has different content, expected: <%s> but was: <%s>. Missing values %s, extra values %s", path, expectedNode, actualNode, missingValues, extraValues);
                    break block7;
                }
                if (missingValues.isEmpty()) break block7;
                this.valueDifferenceFound("Array \"%s\" has different content, expected: <%s> but was: <%s>. Missing values %s", path, expectedNode, actualNode, missingValues);
                break block7;
            }
            for (int i = 0; i < Math.min(expectedElements.size(), actualElements.size()); ++i) {
                this.compareNodes(expectedElements.get(i), actualElements.get(i), this.getArrayPath(path, i));
            }
        }
    }

    private ArrayComparison compareArraysIgnoringOrder(List<Node> expectedElements, List<Node> actualElements) {
        return new ArrayComparison(expectedElements, actualElements).compareArraysIgnoringOrder();
    }

    private boolean failOnExtraArrayItems() {
        return !this.hasOption(Option.IGNORING_EXTRA_ARRAY_ITEMS);
    }

    private List<Integer> indexOf(List<Node> expectedElements, Node actual) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        for (Node expected : expectedElements) {
            Diff diff = new Diff(expected, actual, "", this.configuration, JsonUnitLogger.NULL_LOGGER, JsonUnitLogger.NULL_LOGGER);
            if (diff.similar()) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    private List<Node> asList(Iterator<Node> elements) {
        ArrayList<Node> result = new ArrayList<Node>();
        while (elements.hasNext()) {
            Node Node2 = elements.next();
            result.add(Node2);
        }
        return Collections.unmodifiableList(result);
    }

    private static String getPath(String parent, String name) {
        if (parent.length() == 0) {
            return name;
        }
        return parent + "." + name;
    }

    private String getArrayPath(String parent, int i) {
        if (parent.length() == 0) {
            return "[" + i + "]";
        }
        return parent + "[" + i + "]";
    }

    private void structureDifferenceFound(String message, Object ... arguments) {
        this.differences.add(message, arguments);
    }

    private void valueDifferenceFound(String message, Object ... arguments) {
        if (!this.hasOption(Option.COMPARING_ONLY_STRUCTURE)) {
            this.differences.add(message, arguments);
        }
    }

    private Set<String> commonFields(Map<String, Node> expectedFields, Map<String, Node> actualFields) {
        TreeSet<String> result = new TreeSet<String>(expectedFields.keySet());
        result.retainAll(actualFields.keySet());
        return Collections.unmodifiableSet(result);
    }

    private SortedSet<String> sort(Set<String> set) {
        return new TreeSet<String>(set);
    }

    public boolean similar() {
        this.compare();
        boolean isSimilar = this.differences.isEmpty();
        this.logDifferences(isSimilar);
        return isSimilar;
    }

    private void logDifferences(boolean isSimilar) {
        if (!isSimilar) {
            if (this.diffLogger.isEnabled()) {
                this.diffLogger.log(this.getDifferences().trim(), new Object[0]);
            }
            if (this.valuesLogger.isEnabled()) {
                this.valuesLogger.log("Comparing expected:\n{}\n------------\nwith actual:\n{}\n", this.expectedRoot, JsonUtils.getNode(this.actualRoot, this.startPath));
            }
        }
    }

    private static Map<String, Node> getFields(Node node) {
        HashMap<String, Node> result = new HashMap<String, Node>();
        Iterator<Node.KeyValue> fields = node.fields();
        while (fields.hasNext()) {
            Node.KeyValue field = fields.next();
            result.put(field.getKey(), field.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public String toString() {
        return this.differences();
    }

    public String differences() {
        if (this.similar()) {
            return "JSON documents have the same value.";
        }
        return this.getDifferences();
    }

    private String getDifferences() {
        StringBuilder message = new StringBuilder();
        this.differences.appendDifferences(message);
        return message.toString();
    }

    private static JsonUnitLogger createLogger(String name) {
        if (ClassUtils.isClassPresent("org.slf4j.Logger")) {
            return new JsonUnitLogger.SLF4JLogger(name);
        }
        return JsonUnitLogger.NULL_LOGGER;
    }

    private class ArrayComparison {
        private final int compareFrom;
        private final List<Node> actualElements;
        private final List<Node> extraValues;
        private final List<Node> missingValues;

        private ArrayComparison(int compareFrom, List<Node> actualElements, List<Node> extraValues, List<Node> missingValues) {
            this.compareFrom = compareFrom;
            this.actualElements = actualElements;
            this.extraValues = extraValues;
            this.missingValues = missingValues;
        }

        ArrayComparison(List<Node> expectedElements, List<Node> actualElements) {
            this(0, actualElements, new ArrayList<Node>(), new ArrayList<Node>(expectedElements));
        }

        ArrayComparison copy(int compareFrom) {
            return new ArrayComparison(compareFrom, this.actualElements, new ArrayList<Node>(this.extraValues), new ArrayList<Node>(this.missingValues));
        }

        private ArrayComparison compareArraysIgnoringOrder() {
            for (int i = this.compareFrom; i < this.actualElements.size(); ++i) {
                Node actual = this.actualElements.get(i);
                List matches = Diff.this.indexOf(this.missingValues, actual);
                if (matches.size() == 1) {
                    this.removeMissing((Integer)matches.get(0));
                    continue;
                }
                if (matches.size() > 0) {
                    Iterator iterator = matches.iterator();
                    while (iterator.hasNext()) {
                        int match = (Integer)iterator.next();
                        ArrayComparison copy = this.copy(i + 1);
                        copy.removeMissing(match);
                        copy.compareArraysIgnoringOrder();
                        if (!copy.isMatching()) continue;
                        return copy;
                    }
                    this.removeMissing((Integer)matches.get(0));
                    continue;
                }
                this.extraValues.add(actual);
            }
            return this;
        }

        private boolean isMatching() {
            return this.missingValues.isEmpty() && (this.extraValues.isEmpty() || !Diff.this.failOnExtraArrayItems());
        }

        private void removeMissing(int index) {
            this.missingValues.remove(index);
        }
    }
}

