/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.javacrumbs.jsonunit.core.internal.AbstractNode;
import net.javacrumbs.jsonunit.core.internal.AbstractNodeFactory;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Utils;

class MoshiNodeFactory
extends AbstractNodeFactory {
    private static final Moshi moshi = new Moshi.Builder().build();

    MoshiNodeFactory() {
    }

    @Override
    protected Node convertValue(Object source) {
        return MoshiNodeFactory.newNode(source);
    }

    @Override
    protected Node nullNode() {
        return MoshiNodeFactory.newNode(null);
    }

    @Override
    protected Node readValue(String source, String label, boolean lenient) {
        try {
            JsonAdapter adapter = moshi.adapter(Object.class);
            if (lenient) {
                adapter = adapter.lenient();
            }
            return MoshiNodeFactory.newNode(adapter.fromJson(source));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not parse " + label + " value.", e);
        }
    }

    @Override
    protected Node readValue(Reader value, String label, boolean lenient) {
        try {
            Node node = this.readValue(Utils.readAsString(value), label, lenient);
            return node;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not parse " + label + " value.", e);
        }
        finally {
            Utils.closeQuietly(value);
        }
    }

    private static Node newNode(Object object) {
        if (object == null) {
            return new NullNode();
        }
        if (object instanceof Map) {
            return new ObjectNode((Map)object);
        }
        if (object instanceof Number) {
            return new NumberNode((Number)object);
        }
        if (object instanceof String) {
            return new StringNode((String)object);
        }
        if (object instanceof Boolean) {
            return new BooleanNode((Boolean)object);
        }
        if (object instanceof Object[]) {
            return new ArrayNode(Arrays.asList((Object[])object));
        }
        if (object instanceof int[]) {
            int[] array = (int[])object;
            ArrayList<Integer> list = new ArrayList<Integer>(array.length);
            for (int i : array) {
                list.add(i);
            }
            return new ArrayNode(list);
        }
        if (object instanceof double[]) {
            double[] array = (double[])object;
            ArrayList<Double> list = new ArrayList<Double>(array.length);
            for (double i : array) {
                list.add(i);
            }
            return new ArrayNode(list);
        }
        if (object instanceof List) {
            return new ArrayNode((List)object);
        }
        throw new IllegalArgumentException("Unsupported type " + object.getClass());
    }

    @Override
    public boolean isPreferredFor(Object source) {
        return false;
    }

    private static abstract class NodeSkeleton
    extends AbstractNode {
        private NodeSkeleton() {
        }

        @Override
        public Node element(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node get(String key) {
            return MISSING_NODE;
        }

        @Override
        public boolean isMissingNode() {
            return false;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public Iterator<Node> arrayElements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String asText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal decimalValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean asBoolean() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ObjectNode
    extends NodeSkeleton
    implements Iterable<Node.KeyValue> {
        private final Map<String, Object> jsonObject;

        private ObjectNode(Map<String, Object> jsonObject) {
            this.jsonObject = jsonObject;
        }

        @Override
        public Node element(int index) {
            return MoshiNodeFactory.newNode(null);
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            final Iterator<String> iterator = this.jsonObject.keySet().iterator();
            return new Iterator<Node.KeyValue>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }

                @Override
                public Node.KeyValue next() {
                    String fieldName = (String)iterator.next();
                    return new Node.KeyValue(fieldName, MoshiNodeFactory.newNode(ObjectNode.this.jsonObject.get(fieldName)));
                }
            };
        }

        @Override
        public Iterator<Node.KeyValue> iterator() {
            return this.fields();
        }

        @Override
        public Node get(String key) {
            if (this.jsonObject.containsKey(key)) {
                return MoshiNodeFactory.newNode(this.jsonObject.get(key));
            }
            return MISSING_NODE;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.OBJECT;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            for (Node.KeyValue kv : this) {
                builder.append('\"').append(kv.getKey()).append("\":").append(kv.getValue());
            }
            builder.append('}');
            return builder.toString();
        }
    }

    private static final class ArrayNode
    extends NodeSkeleton {
        private final List<?> value;

        private ArrayNode(List<?> value) {
            this.value = value;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.ARRAY;
        }

        @Override
        public Node element(int index) {
            try {
                return MoshiNodeFactory.newNode(this.value.get(index));
            }
            catch (IndexOutOfBoundsException e) {
                return MISSING_NODE;
            }
        }

        @Override
        public Iterator<Node> arrayElements() {
            final Iterator<?> iterator = this.value.iterator();
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Node next() {
                    return MoshiNodeFactory.newNode(iterator.next());
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        @Override
        public int size() {
            return this.value.size();
        }

        public String toString() {
            return moshi.adapter(Object.class).toJson(this.value);
        }
    }

    private static final class BooleanNode
    extends NodeSkeleton {
        private final Boolean value;

        private BooleanNode(Boolean value) {
            this.value = value;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.BOOLEAN;
        }

        @Override
        public Boolean asBoolean() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static final class StringNode
    extends NodeSkeleton {
        private final String value;

        private StringNode(String value) {
            this.value = value;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.STRING;
        }

        @Override
        public String asText() {
            return this.value;
        }

        public String toString() {
            return '\"' + this.value + '\"';
        }
    }

    private static final class NumberNode
    extends NodeSkeleton {
        private final Number value;

        private NumberNode(Number value) {
            this.value = value;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.NUMBER;
        }

        @Override
        public BigDecimal decimalValue() {
            return new BigDecimal(this.value.toString()).stripTrailingZeros();
        }

        public String toString() {
            return this.decimalValue().toString();
        }
    }

    private static final class NullNode
    extends NodeSkeleton {
        private NullNode() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.NULL;
        }

        public String toString() {
            return "null";
        }
    }
}

