/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.io.Reader;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.javacrumbs.jsonunit.core.internal.AbstractNode;
import net.javacrumbs.jsonunit.core.internal.AbstractNodeFactory;
import net.javacrumbs.jsonunit.core.internal.Node;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

class JsonOrgNodeFactory
extends AbstractNodeFactory {
    JsonOrgNodeFactory() {
    }

    protected Node convertValue(Object source) {
        return JsonOrgNodeFactory.newNode(source);
    }

    protected Node nullNode() {
        return JsonOrgNodeFactory.newNode(null);
    }

    protected Node readValue(Reader value, String label, boolean lenient) {
        try {
            return JsonOrgNodeFactory.newNode(new JSONTokener(value).nextValue());
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can not parse " + label + " value.", e);
        }
    }

    private static Node newNode(Object object) {
        if (object instanceof JSONObject) {
            return new JSONObjectNode((JSONObject)object);
        }
        if (object instanceof Number) {
            return new NumberNode((Number)object);
        }
        if (object instanceof String) {
            return new StringNode((String)object);
        }
        if (object instanceof Boolean) {
            return new BooleanNode((Boolean)object);
        }
        if (object instanceof JSONArray) {
            return new JSONArrayNode((JSONArray)object);
        }
        if (JSONObject.NULL.equals(object)) {
            return new NullNode();
        }
        if (object instanceof Map) {
            return new JSONObjectNode(new JSONObject((Map)object));
        }
        if (object instanceof Collection || object.getClass().isArray()) {
            return new JSONArrayNode((JSONArray)JSONObject.wrap((Object)object));
        }
        throw new IllegalArgumentException("Unsupported type " + object.getClass());
    }

    public boolean isPreferredFor(Object source) {
        return source instanceof JSONObject || source instanceof JSONArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class NodeSkeleton
    extends AbstractNode {
        private NodeSkeleton() {
        }

        @Override
        public Node element(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node get(String key) {
            return MISSING_NODE;
        }

        @Override
        public boolean isMissingNode() {
            return false;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public Iterator<Node> arrayElements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String asText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal decimalValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean asBoolean() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JSONObjectNode
    extends NodeSkeleton {
        private final JSONObject jsonObject;

        private JSONObjectNode(JSONObject jsonObject) {
            this.jsonObject = jsonObject;
        }

        @Override
        public Node element(int index) {
            return JsonOrgNodeFactory.newNode(null);
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            final Iterator iterator = this.jsonObject.keys();
            return new Iterator<Node.KeyValue>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }

                @Override
                public Node.KeyValue next() {
                    String fieldName = (String)iterator.next();
                    return new Node.KeyValue(fieldName, JsonOrgNodeFactory.newNode(JSONObjectNode.this.jsonObject.get(fieldName)));
                }
            };
        }

        @Override
        public Node get(String key) {
            Object value = this.jsonObject.opt(key);
            if (value != null) {
                return JsonOrgNodeFactory.newNode(value);
            }
            return MISSING_NODE;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.OBJECT;
        }

        public String toString() {
            return this.jsonObject.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JSONArrayNode
    extends NodeSkeleton {
        private final JSONArray value;

        private JSONArrayNode(JSONArray value) {
            this.value = value;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.ARRAY;
        }

        @Override
        public Node element(int index) {
            try {
                return JsonOrgNodeFactory.newNode(this.value.get(index));
            }
            catch (JSONException e) {
                return MISSING_NODE;
            }
        }

        @Override
        public Iterator<Node> arrayElements() {
            final Iterator iterator = this.value.iterator();
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Node next() {
                    return JsonOrgNodeFactory.newNode(iterator.next());
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }
    }

    private static final class BooleanNode
    extends NodeSkeleton {
        private final Boolean value;

        private BooleanNode(Boolean value) {
            this.value = value;
        }

        public Node.NodeType getNodeType() {
            return Node.NodeType.BOOLEAN;
        }

        public Boolean asBoolean() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static final class StringNode
    extends NodeSkeleton {
        private final String value;

        private StringNode(String value) {
            this.value = value;
        }

        public Node.NodeType getNodeType() {
            return Node.NodeType.STRING;
        }

        public String asText() {
            return this.value;
        }

        public String toString() {
            return '\"' + this.value + '\"';
        }
    }

    private static final class NumberNode
    extends NodeSkeleton {
        private final Number value;

        private NumberNode(Number value) {
            this.value = value;
        }

        public Node.NodeType getNodeType() {
            return Node.NodeType.NUMBER;
        }

        public BigDecimal decimalValue() {
            return new BigDecimal(this.value.toString());
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static final class NullNode
    extends NodeSkeleton {
        private NullNode() {
        }

        public boolean isNull() {
            return true;
        }

        public Node.NodeType getNodeType() {
            return Node.NodeType.NULL;
        }

        public String toString() {
            return "null";
        }
    }
}

