/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import net.javacrumbs.jsonunit.core.internal.AbstractNode;
import net.javacrumbs.jsonunit.core.internal.AbstractNodeFactory;
import net.javacrumbs.jsonunit.core.internal.Node;

class Jackson2NodeFactory
extends AbstractNodeFactory {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectMapper lenientMapper = new ObjectMapper();

    Jackson2NodeFactory() {
    }

    protected Node convertValue(Object source) {
        return Jackson2NodeFactory.newNode((JsonNode)mapper.convertValue(source, JsonNode.class));
    }

    protected Node nullNode() {
        return Jackson2NodeFactory.newNode((JsonNode)NullNode.getInstance());
    }

    protected Node readValue(Reader value, String label, boolean lenient) {
        try {
            return Jackson2NodeFactory.newNode(this.getMapper(lenient).readTree(value));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not parse " + label + " value.", e);
        }
    }

    private ObjectMapper getMapper(boolean lenient) {
        return lenient ? lenientMapper : mapper;
    }

    private static Node newNode(JsonNode jsonNode) {
        if (jsonNode != null) {
            return new Jackson2Node(jsonNode);
        }
        return Node.MISSING_NODE;
    }

    public boolean isPreferredFor(Object source) {
        return source instanceof JsonNode;
    }

    static {
        lenientMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        lenientMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        lenientMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Jackson2Node
    extends AbstractNode {
        private final JsonNode jsonNode;

        public Jackson2Node(JsonNode jsonNode) {
            this.jsonNode = jsonNode;
        }

        @Override
        public Node element(int index) {
            return Jackson2NodeFactory.newNode(this.jsonNode.path(index));
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            final Iterator iterator = this.jsonNode.fields();
            return new Iterator<Node.KeyValue>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }

                @Override
                public Node.KeyValue next() {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    return new Node.KeyValue((String)entry.getKey(), Jackson2NodeFactory.newNode((JsonNode)entry.getValue()));
                }
            };
        }

        @Override
        public Node get(String key) {
            return Jackson2NodeFactory.newNode(this.jsonNode.get(key));
        }

        @Override
        public boolean isMissingNode() {
            return false;
        }

        @Override
        public boolean isNull() {
            return this.jsonNode.isNull();
        }

        @Override
        public Iterator<Node> arrayElements() {
            final Iterator elements = this.jsonNode.elements();
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return elements.hasNext();
                }

                @Override
                public Node next() {
                    return Jackson2NodeFactory.newNode((JsonNode)elements.next());
                }

                @Override
                public void remove() {
                    elements.remove();
                }
            };
        }

        @Override
        public String asText() {
            return this.jsonNode.asText();
        }

        @Override
        public Node.NodeType getNodeType() {
            if (this.jsonNode.isObject()) {
                return Node.NodeType.OBJECT;
            }
            if (this.jsonNode.isArray()) {
                return Node.NodeType.ARRAY;
            }
            if (this.jsonNode.isTextual()) {
                return Node.NodeType.STRING;
            }
            if (this.jsonNode.isNumber()) {
                return Node.NodeType.NUMBER;
            }
            if (this.jsonNode.isBoolean()) {
                return Node.NodeType.BOOLEAN;
            }
            if (this.jsonNode.isNull()) {
                return Node.NodeType.NULL;
            }
            throw new IllegalStateException("Unexpected node type " + this.jsonNode);
        }

        @Override
        public BigDecimal decimalValue() {
            return this.jsonNode.decimalValue();
        }

        @Override
        public Boolean asBoolean() {
            return this.jsonNode.asBoolean();
        }

        public String toString() {
            return this.jsonNode.toString();
        }
    }
}

