/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.Iterator;
import net.javacrumbs.jsonunit.core.internal.AbstractNode;
import net.javacrumbs.jsonunit.core.internal.AbstractNodeFactory;
import net.javacrumbs.jsonunit.core.internal.Node;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ClassIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.map.introspect.MethodFilter;
import org.codehaus.jackson.node.NullNode;

class Jackson1NodeFactory
extends AbstractNodeFactory {
    private static final JacksonAnnotationIntrospector ANNOTATION_INTROSPECTOR = new JacksonAnnotationIntrospector();
    private static final MinimalMethodFilter MINIMAL_METHOD_FILTER = new MinimalMethodFilter();
    private static final ObjectMapper mapper = new ObjectMapper();

    Jackson1NodeFactory() {
    }

    protected Node convertValue(Object source) {
        return Jackson1NodeFactory.newNode((JsonNode)mapper.convertValue(source, JsonNode.class));
    }

    protected Node nullNode() {
        return Jackson1NodeFactory.newNode((JsonNode)NullNode.getInstance());
    }

    protected Node readValue(Reader value, String label) {
        try {
            return Jackson1NodeFactory.newNode(mapper.readTree(value));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not parse " + label + " value.", e);
        }
    }

    private static Node newNode(JsonNode jsonNode) {
        if (jsonNode != null) {
            return new Jackson1Node(jsonNode);
        }
        return Node.MISSING_NODE;
    }

    public boolean isPreferredFor(Object source) {
        return source instanceof JsonNode || this.hasJackson1Annotations(source);
    }

    private boolean hasJackson1Annotations(Object source) {
        if (source == null) {
            return false;
        }
        AnnotatedClass annotatedClass = AnnotatedClass.construct(source.getClass(), (AnnotationIntrospector)ANNOTATION_INTROSPECTOR, (ClassIntrospector.MixInResolver)mapper.getSerializationConfig());
        return annotatedClass.hasAnnotations() || this.hasAnnotationOnMethod(annotatedClass);
    }

    private boolean hasAnnotationOnMethod(AnnotatedClass annotatedClass) {
        annotatedClass.resolveMemberMethods((MethodFilter)MINIMAL_METHOD_FILTER, false);
        Iterable annotatedMethods = annotatedClass.memberMethods();
        for (AnnotatedMethod method : annotatedMethods) {
            if (method.getAnnotationCount() <= 0) continue;
            return true;
        }
        return false;
    }

    private static class MinimalMethodFilter
    implements MethodFilter {
        private MinimalMethodFilter() {
        }

        public boolean includeMethod(Method m) {
            if (Modifier.isStatic(m.getModifiers())) {
                return false;
            }
            int pcount = m.getParameterTypes().length;
            return pcount <= 2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Jackson1Node
    extends AbstractNode {
        private final JsonNode jsonNode;

        public Jackson1Node(JsonNode jsonNode) {
            this.jsonNode = jsonNode;
        }

        @Override
        public Node element(int index) {
            return Jackson1NodeFactory.newNode(this.jsonNode.path(index));
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            final Iterator iterator = this.jsonNode.getFieldNames();
            return new Iterator<Node.KeyValue>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }

                @Override
                public Node.KeyValue next() {
                    String fieldName = (String)iterator.next();
                    return new Node.KeyValue(fieldName, Jackson1NodeFactory.newNode(Jackson1Node.this.jsonNode.get(fieldName)));
                }
            };
        }

        @Override
        public Node get(String key) {
            return Jackson1NodeFactory.newNode(this.jsonNode.get(key));
        }

        @Override
        public boolean isMissingNode() {
            return false;
        }

        @Override
        public boolean isNull() {
            return this.jsonNode.isNull();
        }

        @Override
        public Iterator<Node> arrayElements() {
            final Iterator elements = this.jsonNode.getElements();
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return elements.hasNext();
                }

                @Override
                public Node next() {
                    return Jackson1NodeFactory.newNode((JsonNode)elements.next());
                }

                @Override
                public void remove() {
                    elements.remove();
                }
            };
        }

        @Override
        public String asText() {
            return this.jsonNode.getValueAsText();
        }

        @Override
        public Node.NodeType getNodeType() {
            if (this.jsonNode.isObject()) {
                return Node.NodeType.OBJECT;
            }
            if (this.jsonNode.isArray()) {
                return Node.NodeType.ARRAY;
            }
            if (this.jsonNode.isTextual()) {
                return Node.NodeType.STRING;
            }
            if (this.jsonNode.isNumber()) {
                return Node.NodeType.NUMBER;
            }
            if (this.jsonNode.isBoolean()) {
                return Node.NodeType.BOOLEAN;
            }
            if (this.jsonNode.isNull()) {
                return Node.NodeType.NULL;
            }
            throw new IllegalStateException("Unexpected node type " + this.jsonNode);
        }

        @Override
        public BigDecimal decimalValue() {
            return this.jsonNode.getDecimalValue();
        }

        @Override
        public Boolean asBoolean() {
            return this.jsonNode.getBooleanValue();
        }

        public String toString() {
            return this.jsonNode.toString();
        }
    }
}

