/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.javacrumbs.jsonunit.core.internal.Differences;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diff {
    private final JsonNode expectedRoot;
    private final JsonNode actualRoot;
    private final Differences structureDifferences = new Differences("structures");
    private final Differences valueDifferences = new Differences("values");
    private final String startPath;
    private final BigDecimal numericComparisonTolerance;
    private boolean compared = false;
    private final String ignorePlaceholder;
    private static final Logger diffLogger = LoggerFactory.getLogger((String)"net.javacrumbs.jsonunit.difference.diff");
    private static final Logger valuesLogger = LoggerFactory.getLogger((String)"net.javacrumbs.jsonunit.difference.values");

    public Diff(JsonNode expected, JsonNode actual, String startPath, String ignorePlaceholder, BigDecimal numericComparisonTolerance) {
        this.expectedRoot = expected;
        this.actualRoot = actual;
        this.startPath = startPath;
        this.ignorePlaceholder = ignorePlaceholder;
        this.numericComparisonTolerance = numericComparisonTolerance;
    }

    @Deprecated
    public Diff(JsonNode expected, JsonNode actual, String startPath, String ignorePlaceholder) {
        this.expectedRoot = expected;
        this.actualRoot = actual;
        this.startPath = startPath;
        this.ignorePlaceholder = ignorePlaceholder;
        this.numericComparisonTolerance = null;
    }

    public static Diff create(Object expected, Object actual, String actualName, String startPath, String ignorePlaceholder, BigDecimal numericComparisonTolerance) {
        return new Diff(JsonUtils.convertToJson(JsonUtils.quoteIfNeeded(expected), "expected"), JsonUtils.convertToJson(actual, actualName), startPath, ignorePlaceholder, numericComparisonTolerance);
    }

    @Deprecated
    public static Diff create(Object expected, Object actual, String actualName, String startPath, String ignorePlaceholder) {
        return Diff.create(expected, actual, actualName, startPath, ignorePlaceholder, null);
    }

    private void compare() {
        if (!this.compared) {
            JsonNode part = JsonUtils.getNode(this.actualRoot, this.startPath);
            if (part.isMissingNode()) {
                this.structureDifferenceFound("Missing node in path \"%s\".", this.startPath);
            } else {
                this.compareNodes(this.expectedRoot, part, this.startPath);
            }
            this.compared = true;
        }
    }

    private void compareObjectNodes(ObjectNode expected, ObjectNode actual, String path) {
        Set<String> actualKeys;
        Map<String, JsonNode> expectedFields = Diff.getFields(expected);
        Map<String, JsonNode> actualFields = Diff.getFields(actual);
        Set<String> expectedKeys = expectedFields.keySet();
        if (!expectedKeys.equals(actualKeys = actualFields.keySet())) {
            String missingKeys = Diff.getMissingKeys(expectedKeys, actualKeys, path);
            String extraKeys = Diff.getExtraKeys(expectedKeys, actualKeys, path);
            this.structureDifferenceFound("Different keys found in node \"%s\". Expected %s, got %s. %s %s", path, this.sort(expectedFields.keySet()), this.sort(actualFields.keySet()), missingKeys, extraKeys);
        }
        for (String fieldName : this.commonFields(expectedFields, actualFields)) {
            JsonNode expectedNode = expectedFields.get(fieldName);
            JsonNode actualNode = actualFields.get(fieldName);
            String fieldPath = Diff.getPath(path, fieldName);
            this.compareNodes(expectedNode, actualNode, fieldPath);
        }
    }

    static String getMissingKeys(Set<String> expectedKeys, Collection<String> actualKeys, String path) {
        TreeSet<String> missingKeys = new TreeSet<String>(expectedKeys);
        missingKeys.removeAll(actualKeys);
        if (!missingKeys.isEmpty()) {
            return "Missing: " + Diff.appendKeysToPrefix(missingKeys, path);
        }
        return "";
    }

    static String getExtraKeys(Set<String> expectedKeys, Collection<String> actualKeys, String path) {
        TreeSet<String> extraKeys = new TreeSet<String>(actualKeys);
        extraKeys.removeAll(expectedKeys);
        if (!extraKeys.isEmpty()) {
            return "Extra: " + Diff.appendKeysToPrefix(extraKeys, path);
        }
        return "";
    }

    static String appendKeysToPrefix(Iterable<String> keys, String prefix) {
        Iterator<String> iterator = keys.iterator();
        StringBuilder buffer = new StringBuilder();
        while (iterator.hasNext()) {
            String key = iterator.next();
            buffer.append("\"").append(Diff.getPath(prefix, key)).append("\"");
            if (!iterator.hasNext()) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    private void compareNodes(JsonNode expectedNode, JsonNode actualNode, String fieldPath) {
        NodeType expectedNodeType = this.getNodeType(expectedNode);
        NodeType actualNodeType = this.getNodeType(actualNode);
        if (expectedNodeType == NodeType.STRING && this.ignorePlaceholder.equals(expectedNode.asText())) {
            return;
        }
        if (!expectedNodeType.equals((Object)actualNodeType)) {
            this.valueDifferenceFound("Different value found in node \"%s\". Expected '%s', got '%s'.", fieldPath, expectedNode, actualNode);
        } else {
            switch (expectedNodeType) {
                case OBJECT: {
                    this.compareObjectNodes((ObjectNode)expectedNode, (ObjectNode)actualNode, fieldPath);
                    break;
                }
                case ARRAY: {
                    this.compareArrayNodes((ArrayNode)expectedNode, (ArrayNode)actualNode, fieldPath);
                    break;
                }
                case STRING: {
                    this.compareValues(expectedNode.asText(), actualNode.asText(), fieldPath);
                    break;
                }
                case NUMBER: {
                    if (this.numericComparisonTolerance != null) {
                        BigDecimal diff = expectedNode.decimalValue().subtract(actualNode.decimalValue()).abs();
                        if (diff.compareTo(this.numericComparisonTolerance) <= 0) break;
                        this.valueDifferenceFound("Different value found in node \"%s\". Expected %s, got %s, difference is %s, tolerance is %s", fieldPath, this.quoteTextValue(expectedNode.numberValue()), this.quoteTextValue(actualNode.numberValue()), diff.toString(), this.numericComparisonTolerance);
                        break;
                    }
                    this.compareValues(expectedNode.numberValue(), actualNode.numberValue(), fieldPath);
                    break;
                }
                case BOOLEAN: {
                    this.compareValues(expectedNode.asBoolean(), actualNode.asBoolean(), fieldPath);
                    break;
                }
                case NULL: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected node type " + (Object)((Object)expectedNodeType));
                }
            }
        }
    }

    private void compareValues(Object expectedValue, Object actualValue, String path) {
        if (!expectedValue.equals(actualValue)) {
            this.valueDifferenceFound("Different value found in node \"%s\". Expected %s, got %s.", path, this.quoteTextValue(expectedValue), this.quoteTextValue(actualValue));
        }
    }

    private Object quoteTextValue(Object value) {
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        return value;
    }

    private void compareArrayNodes(ArrayNode expectedNode, ArrayNode actualNode, String path) {
        List<JsonNode> expectedElements = this.asList(expectedNode.elements());
        List<JsonNode> actualElements = this.asList(actualNode.elements());
        if (expectedElements.size() != actualElements.size()) {
            this.structureDifferenceFound("Array \"%s\" has different length. Expected %d, got %d.", path, expectedElements.size(), actualElements.size());
        }
        for (int i = 0; i < Math.min(expectedElements.size(), actualElements.size()); ++i) {
            this.compareNodes(expectedElements.get(i), actualElements.get(i), this.getArrayPath(path, i));
        }
    }

    private List<JsonNode> asList(Iterator<JsonNode> elements) {
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        while (elements.hasNext()) {
            JsonNode jsonNode = elements.next();
            result.add(jsonNode);
        }
        return Collections.unmodifiableList(result);
    }

    private NodeType getNodeType(JsonNode node) {
        if (node.isObject()) {
            return NodeType.OBJECT;
        }
        if (node.isArray()) {
            return NodeType.ARRAY;
        }
        if (node.isTextual()) {
            return NodeType.STRING;
        }
        if (node.isNumber()) {
            return NodeType.NUMBER;
        }
        if (node.isBoolean()) {
            return NodeType.BOOLEAN;
        }
        if (node.isNull()) {
            return NodeType.NULL;
        }
        throw new IllegalStateException("Unexpected node type " + node);
    }

    private static String getPath(String parent, String name) {
        if (parent.length() == 0) {
            return name;
        }
        return parent + "." + name;
    }

    private String getArrayPath(String parent, int i) {
        if (parent.length() == 0) {
            return "[" + i + "]";
        }
        return parent + "[" + i + "]";
    }

    private void structureDifferenceFound(String message, Object ... arguments) {
        this.structureDifferences.add(message, arguments);
    }

    private void valueDifferenceFound(String message, Object ... arguments) {
        this.valueDifferences.add(message, arguments);
    }

    private Set<String> commonFields(Map<String, JsonNode> expectedFields, Map<String, JsonNode> actualFields) {
        TreeSet<String> result = new TreeSet<String>(expectedFields.keySet());
        result.retainAll(actualFields.keySet());
        return Collections.unmodifiableSet(result);
    }

    private SortedSet<String> sort(Set<String> set) {
        return new TreeSet<String>(set);
    }

    private boolean hasSimilarStructure() {
        this.compare();
        return this.structureDifferences.isEmpty();
    }

    public boolean similarStructure() {
        boolean result = this.hasSimilarStructure();
        this.logDifferences(result);
        return result;
    }

    public boolean similar() {
        boolean result = this.hasSimilarStructure() && this.valueDifferences.isEmpty();
        this.logDifferences(result);
        return result;
    }

    private void logDifferences(boolean result) {
        if (!result) {
            if (diffLogger.isDebugEnabled()) {
                diffLogger.debug(this.getDifferences().trim());
            }
            if (valuesLogger.isDebugEnabled()) {
                valuesLogger.debug("Comparing expected:\n{}\n------------\nwith actual:\n{}\n", (Object)this.expectedRoot, (Object)JsonUtils.getNode(this.actualRoot, this.startPath));
            }
        }
    }

    private static Map<String, JsonNode> getFields(ObjectNode node) {
        HashMap result = new HashMap();
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            result.put(field.getKey(), field.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public String toString() {
        return this.differences();
    }

    public String differences() {
        if (this.similar()) {
            return "JSON documents have the same value.";
        }
        return this.getDifferences();
    }

    private String getDifferences() {
        StringBuilder message = new StringBuilder();
        this.structureDifferences.appendDifferences(message);
        this.valueDifferences.appendDifferences(message);
        return message.toString();
    }

    public String structureDifferences() {
        if (this.similarStructure()) {
            return "JSON documents have the same structure.";
        }
        StringBuilder message = new StringBuilder();
        this.structureDifferences.appendDifferences(message);
        return message.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NodeType {
        OBJECT,
        ARRAY,
        STRING,
        NUMBER,
        BOOLEAN,
        NULL;

    }
}

