/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core;

import java.math.BigDecimal;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Options;

public class Configuration {
    private static final Configuration EMPTY_CONFIGURATION = new Configuration(null, Options.empty(), "${json-unit.ignore}");
    private final BigDecimal tolerance;
    private final Options options;
    private final String ignorePlaceholder;

    public Configuration(BigDecimal tolerance, Options options, String ignorePlaceholder) {
        this.tolerance = tolerance;
        this.options = options;
        this.ignorePlaceholder = ignorePlaceholder;
    }

    public static Configuration empty() {
        return EMPTY_CONFIGURATION;
    }

    public Configuration withTolerance(BigDecimal tolerance) {
        return new Configuration(tolerance, this.options, this.ignorePlaceholder);
    }

    public Configuration withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public Configuration withOptions(Option first, Option ... next) {
        return new Configuration(this.tolerance, this.options.with(first, next), this.ignorePlaceholder);
    }

    public Configuration withOptions(Options options) {
        return new Configuration(this.tolerance, options, this.ignorePlaceholder);
    }

    public Configuration withIgnorePlaceholder(String ignorePlaceholder) {
        return new Configuration(this.tolerance, this.options, ignorePlaceholder);
    }

    public BigDecimal getTolerance() {
        return this.tolerance;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getIgnorePlaceholder() {
        return this.ignorePlaceholder;
    }
}

