/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.futureconverter.springrx;

import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import rx.Observable;
import rx.Subscriber;

class ListenableFutureObservable<T>
extends Observable<T> {
    private final ListenableFuture<T> listenableFuture;

    ListenableFutureObservable(ListenableFuture<T> listenableFuture) {
        super(ListenableFutureObservable.onSubscribe(listenableFuture));
        this.listenableFuture = listenableFuture;
    }

    private static <T> Observable.OnSubscribe<T> onSubscribe(final ListenableFuture<T> listenableFuture) {
        return new Observable.OnSubscribe<T>(){

            public void call(final Subscriber<? super T> subscriber) {
                listenableFuture.addCallback(new ListenableFutureCallback<T>(){

                    public void onSuccess(T t) {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext(t);
                            subscriber.onCompleted();
                        }
                    }

                    public void onFailure(Throwable throwable) {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onError(throwable);
                        }
                    }
                });
            }
        };
    }

    public ListenableFuture<T> getListenableFuture() {
        return this.listenableFuture;
    }
}

