/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.futureconverter.springguava;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import net.javacrumbs.futureconverter.common.FutureWrapper;
import net.javacrumbs.futureconverter.common.spring.AbstractSpringListenableFutureWrapper;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public class FutureConverter {
    public static <T> ListenableFuture<T> toSpringListenableFuture(com.google.common.util.concurrent.ListenableFuture<T> guavaListenableFuture) {
        if (guavaListenableFuture instanceof GuavaListenableWrappingSpringListenableFuture) {
            return ((GuavaListenableWrappingSpringListenableFuture)guavaListenableFuture).getWrappedFuture();
        }
        return new SpringListenableWrappingGuavaListenableFuture<T>(guavaListenableFuture);
    }

    public static <T> com.google.common.util.concurrent.ListenableFuture<T> toGuavaListenableFuture(ListenableFuture<T> springListenableFuture) {
        if (springListenableFuture instanceof SpringListenableWrappingGuavaListenableFuture) {
            return ((SpringListenableWrappingGuavaListenableFuture)springListenableFuture).getWrappedFuture();
        }
        return new GuavaListenableWrappingSpringListenableFuture<T>(springListenableFuture);
    }

    private static class GuavaListenableWrappingSpringListenableFuture<T>
    extends FutureWrapper<T>
    implements com.google.common.util.concurrent.ListenableFuture<T> {
        public GuavaListenableWrappingSpringListenableFuture(ListenableFuture<T> springListenableFuture) {
            super(springListenableFuture);
        }

        public void addListener(final Runnable command, final Executor executor) {
            this.getWrappedFuture().addCallback(new ListenableFutureCallback<T>(){

                public void onSuccess(T result) {
                    executor.execute(command);
                }

                public void onFailure(Throwable t) {
                    executor.execute(command);
                }
            });
        }

        public ListenableFuture<T> getWrappedFuture() {
            return (ListenableFuture)super.getWrappedFuture();
        }
    }

    private static class SpringListenableWrappingGuavaListenableFuture<T>
    extends AbstractSpringListenableFutureWrapper<T>
    implements ListenableFuture<T> {
        public SpringListenableWrappingGuavaListenableFuture(com.google.common.util.concurrent.ListenableFuture<T> guavaListenableFuture) {
            super(guavaListenableFuture);
            Futures.addCallback(this.getWrappedFuture(), (FutureCallback)new FutureCallback<T>(){

                public void onSuccess(T result) {
                    SpringListenableWrappingGuavaListenableFuture.this.success(result);
                }

                public void onFailure(Throwable t) {
                    SpringListenableWrappingGuavaListenableFuture.this.failure(t);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public com.google.common.util.concurrent.ListenableFuture<T> getWrappedFuture() {
            return (com.google.common.util.concurrent.ListenableFuture)super.getWrappedFuture();
        }
    }
}

