/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.futureconverter.springcommon;

import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.javacrumbs.futureconverter.common.internal.FutureWrapper;
import net.javacrumbs.futureconverter.common.internal.ValueSource;
import net.javacrumbs.futureconverter.common.internal.ValueSourceFuture;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SettableListenableFuture;
import org.springframework.util.concurrent.SuccessCallback;

public class SpringFutureUtils {
    public static <T> ListenableFuture<T> createListenableFuture(ValueSourceFuture<T> valueSource) {
        if (valueSource instanceof ListenableFutureBackedValueSourceFuture) {
            return ((ListenableFutureBackedValueSourceFuture)valueSource).getWrappedFuture();
        }
        return new ValueSourceFutureBackedListenableFuture(valueSource);
    }

    public static <T> ListenableFuture<T> createListenableFuture(ValueSource<T> valueSource) {
        if (valueSource instanceof ListenableFutureBackedValueSourceFuture) {
            return ((ListenableFutureBackedValueSourceFuture)valueSource).getWrappedFuture();
        }
        return new ValueSourceBackedListenableFuture(valueSource);
    }

    public static <T> ValueSourceFuture<T> createValueSourceFuture(ListenableFuture<T> listenableFuture) {
        if (listenableFuture instanceof ValueSourceFutureBackedListenableFuture) {
            return ((ValueSourceFutureBackedListenableFuture)listenableFuture).getWrappedFuture();
        }
        return new ListenableFutureBackedValueSourceFuture(listenableFuture);
    }

    public static <T> ValueSource<T> createValueSource(ListenableFuture<T> listenableFuture) {
        if (listenableFuture instanceof ValueSourceBackedListenableFuture) {
            return ((ValueSourceBackedListenableFuture)listenableFuture).getValueSource();
        }
        return new ListenableFutureBackedValueSourceFuture(listenableFuture);
    }

    private static class ListenableFutureBackedValueSourceFuture<T>
    extends ValueSourceFuture<T> {
        private ListenableFutureBackedValueSourceFuture(ListenableFuture<T> wrappedFuture) {
            super(wrappedFuture);
        }

        public void addCallbacks(Consumer<T> successCallback, Consumer<Throwable> failureCallback) {
            this.getWrappedFuture().addCallback(successCallback::accept, failureCallback::accept);
        }

        protected ListenableFuture<T> getWrappedFuture() {
            return (ListenableFuture)super.getWrappedFuture();
        }
    }

    private static class ValueSourceBackedListenableFuture<T>
    extends FutureWrapper<T>
    implements ListenableFuture<T> {
        private final ValueSource<T> valueSource;

        private ValueSourceBackedListenableFuture(ValueSource<T> valueSource) {
            super((Future)new SettableListenableFuture());
            this.valueSource = valueSource;
            valueSource.addCallbacks(value -> this.getWrappedFuture().set(value), ex -> this.getWrappedFuture().setException(ex));
        }

        protected SettableListenableFuture<T> getWrappedFuture() {
            return (SettableListenableFuture)super.getWrappedFuture();
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            this.valueSource.cancel(mayInterruptIfRunning);
            return super.cancel(mayInterruptIfRunning);
        }

        private ValueSource<T> getValueSource() {
            return this.valueSource;
        }

        public void addCallback(ListenableFutureCallback<? super T> callback) {
            this.getWrappedFuture().addCallback(callback);
        }

        public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
            this.getWrappedFuture().addCallback(successCallback, failureCallback);
        }
    }

    private static class ValueSourceFutureBackedListenableFuture<T>
    extends FutureWrapper<T>
    implements ListenableFuture<T> {
        private ValueSourceFutureBackedListenableFuture(ValueSourceFuture<T> valueSourceFuture) {
            super(valueSourceFuture);
        }

        public void addCallback(ListenableFutureCallback<? super T> callback) {
            this.getWrappedFuture().addCallbacks(arg_0 -> callback.onSuccess(arg_0), arg_0 -> callback.onFailure(arg_0));
        }

        public void addCallback(SuccessCallback<? super T> successCallback, FailureCallback failureCallback) {
            this.getWrappedFuture().addCallbacks(arg_0 -> successCallback.onSuccess(arg_0), arg_0 -> ((FailureCallback)failureCallback).onFailure(arg_0));
        }

        protected ValueSourceFuture<T> getWrappedFuture() {
            return (ValueSourceFuture)super.getWrappedFuture();
        }
    }
}

