/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.futureconverter.rxjava2common;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import java.util.function.Consumer;
import net.javacrumbs.futureconverter.common.internal.ValueSource;

public class RxJava2FutureUtils {
    public static <T> Single<T> createSingle(ValueSource<T> valueSource) {
        if (valueSource instanceof SingleBackedValueSource) {
            return ((SingleBackedValueSource)valueSource).getSingle();
        }
        return new ValueSourceBackedSingle<T>(valueSource);
    }

    public static <T> ValueSource<T> createValueSource(Single<T> single) {
        if (single instanceof ValueSourceBackedSingle) {
            return ((ValueSourceBackedSingle)single).getValueSource();
        }
        return new SingleBackedValueSource(single);
    }

    private static class ValueSourceBackedSingle<T>
    extends Single<T> {
        private final ValueSource<T> valueSource;

        ValueSourceBackedSingle(ValueSource<T> valueSource) {
            this.valueSource = valueSource;
        }

        protected void subscribeActual(SingleObserver<? super T> observer) {
            ValueSourceDisposable disposable = new ValueSourceDisposable();
            this.valueSource.addCallbacks(result -> {
                try {
                    observer.onSuccess(result);
                }
                catch (Throwable e) {
                    observer.onError(e);
                }
            }, ex -> {
                if (!disposable.isDisposed()) {
                    observer.onError(ex);
                }
            });
            observer.onSubscribe((Disposable)disposable);
        }

        private ValueSource<T> getValueSource() {
            return this.valueSource;
        }

        private class ValueSourceDisposable
        implements Disposable {
            private volatile boolean disposed = false;

            private ValueSourceDisposable() {
            }

            public void dispose() {
                this.disposed = true;
                ValueSourceBackedSingle.this.valueSource.cancel(true);
            }

            public boolean isDisposed() {
                return this.disposed;
            }
        }
    }

    private static class SingleBackedValueSource<T>
    implements ValueSource<T> {
        private final Single<T> single;
        private Disposable disposable;

        private SingleBackedValueSource(Single<T> single) {
            this.single = single;
        }

        public void addCallbacks(Consumer<T> successCallback, Consumer<Throwable> failureCallback) {
            if (this.disposable != null) {
                throw new IllegalStateException("add callbacks can be called only once");
            }
            this.disposable = this.single.subscribe(successCallback::accept, failureCallback::accept);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            this.disposable.dispose();
            return true;
        }

        private Single<T> getSingle() {
            return this.single;
        }
    }
}

