/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.NoSuchFileException;
import java.util.Date;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.driver.http.HttpController;
import net.java.truevfs.driver.http.HttpInputSocket;
import net.java.truevfs.driver.http.HttpOutputSocket;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsAccessOptions;
import net.java.truevfs.kernel.spec.FsNode;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsReadOnlyFileSystemException;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputSocket;
import net.java.truevfs.kernel.spec.cio.IoBufferPool;
import net.java.truevfs.kernel.spec.cio.IoEntry;
import net.java.truevfs.kernel.spec.cio.OutputSocket;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;

@Immutable
public class HttpNode
extends FsNode
implements IoEntry<HttpNode> {
    private final HttpController controller;
    private final String name;
    protected final URI uri;

    HttpNode(HttpController controller2, FsNodeName name) {
        assert (null != controller2);
        this.controller = controller2;
        this.name = name.toString();
        this.uri = controller2.resolve(name).getUri();
    }

    final IoBufferPool getPool() {
        return this.controller.getPool();
    }

    private HttpResponse executeHead() throws IOException {
        return this.controller.executeHead(this);
    }

    private HttpResponse executeGet() throws IOException {
        return this.controller.executeGet(this);
    }

    protected HttpUriRequest newHead() {
        return new HttpHead(this.uri);
    }

    protected HttpUriRequest newGet() {
        return new HttpGet(this.uri);
    }

    @CheckForNull
    private String getHeaderField(String name) throws IOException {
        Header header = this.executeHead().getLastHeader(name);
        return null == header ? null : header.getValue();
    }

    protected InputStream newInputStream() throws IOException {
        HttpResponse response = this.executeGet();
        HttpEntity entity = response.getEntity();
        if (null == entity) {
            throw new NoSuchFileException(this.name, null, response.getStatusLine().toString());
        }
        return entity.getContent();
    }

    protected OutputStream newOutputStream() throws IOException {
        throw new FsReadOnlyFileSystemException(this.controller.getMountPoint());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BitField<Entry.Type> getTypes() {
        try {
            this.executeHead();
            return FILE_TYPE;
        }
        catch (IOException ex) {
            return NO_TYPES;
        }
    }

    @Override
    public boolean isType(Entry.Type type) {
        return type == Entry.Type.FILE && this.getTypes().is(Entry.Type.FILE);
    }

    @Override
    public long getSize(Entry.Size type) {
        if (Entry.Size.DATA != type) {
            return -1L;
        }
        try {
            String field2 = this.getHeaderField("content-length");
            if (null != field2) {
                return Long.parseLong(field2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    public long getTime(Entry.Access type) {
        if (Entry.Access.WRITE != type) {
            return -1L;
        }
        try {
            String field2 = this.getHeaderField("last-modified");
            if (null != field2) {
                return Date.parse(field2);
            }
        }
        catch (IOException | IllegalArgumentException exception) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
        if (Entry.Access.READ != type) {
            return null;
        }
        try {
            this.executeHead();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    @Nullable
    public Set<String> getMembers() {
        return null;
    }

    @Override
    public final InputSocket<HttpNode> input() {
        return this.input(FsAccessOptions.NONE);
    }

    protected InputSocket<HttpNode> input(BitField<FsAccessOption> options) {
        return new HttpInputSocket(options, this);
    }

    @Override
    public final OutputSocket<HttpNode> output() {
        return this.output(FsAccessOptions.NONE, null);
    }

    protected OutputSocket<HttpNode> output(BitField<FsAccessOption> options, @CheckForNull Entry template) {
        return new HttpOutputSocket(options, this, template);
    }
}

