/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.driver.file.FileNode;
import net.java.truevfs.kernel.spec.FsAbstractController;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsSyncOption;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputSocket;
import net.java.truevfs.kernel.spec.cio.OutputSocket;

@Immutable
final class FileController
extends FsAbstractController {
    private static final String TWO_SEPARATORS = "//";
    private final Path target;

    FileController(FsModel model) {
        super(model);
        if (null != model.getParent()) {
            throw new IllegalArgumentException();
        }
        URI uri = model.getMountPoint().getUri();
        if ('\\' == File.separatorChar && null != uri.getRawAuthority()) {
            try {
                uri = new URI(uri.getScheme(), "", TWO_SEPARATORS + uri.getAuthority() + uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        this.target = Paths.get(uri);
    }

    private BasicFileAttributeView getBasicFileAttributeView(Path file) {
        BasicFileAttributeView view = Files.getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]);
        assert (null != view);
        return view;
    }

    @Override
    public FsController getParent() {
        return null;
    }

    @Override
    public FileNode node(BitField<FsAccessOption> options, FsNodeName name) throws IOException {
        FileNode entry2 = new FileNode(this.target, name);
        return Files.exists(entry2.getPath(), new LinkOption[0]) ? entry2 : null;
    }

    @Override
    public void checkAccess(BitField<FsAccessOption> options, FsNodeName name, BitField<Entry.Access> types) throws IOException {
        Path file = this.target.resolve(name.getPath());
        AccessMode[] modes = FileController.modes(types);
        file.getFileSystem().provider().checkAccess(file, modes);
    }

    private static AccessMode[] modes(BitField<Entry.Access> types) {
        EnumSet<AccessMode> modes = EnumSet.noneOf(AccessMode.class);
        for (Entry.Access type : types) {
            switch (type) {
                case READ: {
                    modes.add(AccessMode.READ);
                    break;
                }
                case WRITE: {
                    modes.add(AccessMode.WRITE);
                    break;
                }
                case EXECUTE: {
                    modes.add(AccessMode.EXECUTE);
                }
            }
        }
        return modes.toArray(new AccessMode[modes.size()]);
    }

    @Override
    public void setReadOnly(FsNodeName name) throws IOException {
        Path file = this.target.resolve(name.getPath());
        if (!file.toFile().setReadOnly()) {
            if (Files.exists(file, new LinkOption[0])) {
                throw new AccessDeniedException(file.toString());
            }
            throw new NoSuchFileException(file.toString());
        }
    }

    @Override
    public boolean setTime(BitField<FsAccessOption> options, FsNodeName name, Map<Entry.Access, Long> times2) throws IOException {
        Path file = this.target.resolve(name.getPath());
        EnumMap<Entry.Access, Long> t = new EnumMap<Entry.Access, Long>(times2);
        this.getBasicFileAttributeView(file).setTimes(FileController.toFileTime((Long)t.remove((Object)Entry.Access.WRITE)), FileController.toFileTime((Long)t.remove((Object)Entry.Access.READ)), FileController.toFileTime((Long)t.remove((Object)Entry.Access.CREATE)));
        return t.isEmpty();
    }

    @Override
    public boolean setTime(BitField<FsAccessOption> options, FsNodeName name, BitField<Entry.Access> types, long value2) throws IOException {
        Path file = this.target.resolve(name.getPath());
        FileTime time = FileTime.fromMillis(value2);
        this.getBasicFileAttributeView(file).setTimes(types.get(Entry.Access.WRITE) ? time : null, types.get(Entry.Access.READ) ? time : null, types.get(Entry.Access.CREATE) ? time : null);
        return types.clear(Entry.Access.WRITE).clear(Entry.Access.READ).clear(Entry.Access.CREATE).isEmpty();
    }

    public InputSocket<?> input(BitField<FsAccessOption> options, FsNodeName name) {
        return new FileNode(this.target, name).input(options);
    }

    public OutputSocket<?> output(BitField<FsAccessOption> options, FsNodeName name, @CheckForNull Entry template) {
        return new FileNode(this.target, name).output(options, template);
    }

    @Override
    public void make(BitField<FsAccessOption> options, FsNodeName name, Entry.Type type, @CheckForNull Entry template) throws IOException {
        Path file = this.target.resolve(name.getPath());
        switch (type) {
            case FILE: {
                if (options.get(FsAccessOption.EXCLUSIVE)) {
                    Files.createFile(file, new FileAttribute[0]);
                    break;
                }
                Files.newOutputStream(file, new OpenOption[0]).close();
                break;
            }
            case DIRECTORY: {
                Files.createDirectory(file, new FileAttribute[0]);
                break;
            }
            default: {
                throw new IOException(file + " (entry type not supported: " + (Object)((Object)type) + ")");
            }
        }
        if (null != template) {
            this.getBasicFileAttributeView(file).setTimes(FileController.toFileTime(template.getTime(Entry.Access.WRITE)), FileController.toFileTime(template.getTime(Entry.Access.READ)), FileController.toFileTime(template.getTime(Entry.Access.CREATE)));
        }
    }

    @Nullable
    private static FileTime toFileTime(Long time) {
        return null == time ? null : FileController.toFileTime((long)time);
    }

    @Nullable
    private static FileTime toFileTime(long time) {
        return -1L == time ? null : FileTime.fromMillis(time);
    }

    @Override
    public void unlink(BitField<FsAccessOption> options, FsNodeName name) throws IOException {
        Path file = this.target.resolve(name.getPath());
        Files.delete(file);
    }

    @Override
    public void sync(BitField<FsSyncOption> options) {
    }
}

