/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zipdriver;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingOutputStream;
import net.java.truecommons.io.DisconnectingOutputStream;
import net.java.truecommons.io.InputException;
import net.java.truecommons.io.Streams;
import net.java.truecommons.shed.CompoundIterator;
import net.java.truecommons.shed.SuppressedExceptionBuilder;
import net.java.truevfs.comp.zip.AbstractZipOutputStream;
import net.java.truevfs.comp.zip.ZipCryptoParameters;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zipdriver.AbstractZipDriver;
import net.java.truevfs.comp.zipdriver.AbstractZipDriverEntry;
import net.java.truevfs.comp.zipdriver.ZipInputService;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsOutputSocketSink;
import net.java.truevfs.kernel.spec.cio.AbstractOutputSocket;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputSocket;
import net.java.truevfs.kernel.spec.cio.IoBuffer;
import net.java.truevfs.kernel.spec.cio.IoBufferPool;
import net.java.truevfs.kernel.spec.cio.OutputBusyException;
import net.java.truevfs.kernel.spec.cio.OutputService;
import net.java.truevfs.kernel.spec.cio.OutputSocket;

@NotThreadSafe
public final class ZipOutputService<E extends AbstractZipDriverEntry>
extends AbstractZipOutputStream<E>
implements OutputService<E> {
    private final FsModel model;
    private final AbstractZipDriver<E> driver;
    @CheckForNull
    private IoBuffer postamble;
    @CheckForNull
    private E bufferedEntry;
    private ZipCryptoParameters param;

    @CreatesObligation
    public ZipOutputService(FsModel model, FsOutputSocketSink sink, @CheckForNull @WillNotClose ZipInputService<E> source, AbstractZipDriver<E> driver) throws IOException {
        block19: {
            super(sink, null != source && sink.getOptions().get(FsAccessOption.GROW) ? source : null, driver);
            this.driver = driver;
            try {
                this.model = Objects.requireNonNull(model);
                if (null == source) break block19;
                if (!sink.getOptions().get(FsAccessOption.GROW)) {
                    super.setComment(source.getComment());
                    if (0L < source.getPreambleLength()) {
                        try (InputStream in = source.getPreambleInputStream();){
                            Streams.cat(in, source.offsetsConsiderPreamble() ? this : this.out);
                        }
                    }
                }
                if (0L < source.getPostambleLength()) {
                    this.postamble = (IoBuffer)this.getPool().allocate();
                    Streams.copy(source.getPostambleInputStream(), this.postamble.output().stream(null));
                }
            }
            catch (Throwable ex) {
                try {
                    super.close();
                }
                catch (Throwable ex2) {
                    ex.addSuppressed(ex2);
                }
                throw ex;
            }
        }
    }

    public FsModel getModel() {
        return this.model;
    }

    private IoBufferPool getPool() {
        return this.driver.getPool();
    }

    @Override
    protected ZipCryptoParameters getCryptoParameters() {
        ZipCryptoParameters param2 = this.param;
        if (null == param2) {
            this.param = param2 = this.driver.zipCryptoParameters(this);
        }
        return param2;
    }

    @Override
    public int size() {
        return super.size() + (null != this.bufferedEntry ? 1 : 0);
    }

    @Override
    public Iterator<E> iterator() {
        E bufferedEntry = this.bufferedEntry;
        if (null == bufferedEntry) {
            return super.iterator();
        }
        return new CompoundIterator(super.iterator(), Collections.singletonList(bufferedEntry).iterator());
    }

    @Override
    @CheckForNull
    public E entry(String name) {
        AbstractZipDriverEntry entry2 = (AbstractZipDriverEntry)super.entry(name);
        if (null != entry2) {
            return (E)entry2;
        }
        entry2 = this.bufferedEntry;
        return (E)(null != entry2 && name.equals(entry2.getName()) ? entry2 : null);
    }

    @Override
    public OutputSocket<E> output(E local) {
        Objects.requireNonNull(local);
        final class Output
        extends AbstractOutputSocket<E> {
            final /* synthetic */ AbstractZipDriverEntry val$local;

            Output() {
                this.val$local = abstractZipDriverEntry;
            }

            @Override
            public E target() {
                return this.val$local;
            }

            @Override
            public OutputStream stream(InputSocket<? extends Entry> peer) throws IOException {
                if (ZipOutputService.this.isBusy()) {
                    throw new OutputBusyException(this.val$local.getName());
                }
                if (this.val$local.isDirectory()) {
                    ZipOutputService.this.updateProperties(this.val$local, DirectoryTemplate.INSTANCE);
                    return new EntryOutputStream(ZipOutputService.this, this.val$local, false);
                }
                boolean rdc = ZipOutputService.this.updateProperties(this.val$local, this.target(peer));
                if (0 == this.val$local.getMethod() && (-1L == this.val$local.getCrc() || -1L == this.val$local.getSize() || -1L == this.val$local.getCompressedSize())) {
                    assert (!rdc) : "The CRC-32, size and compressed size properties must be set when using RDC!";
                    return new BufferedEntryOutputStream(ZipOutputService.this, this.val$local);
                }
                return new EntryOutputStream(ZipOutputService.this, this.val$local, rdc);
            }
        }
        return new Output();
    }

    boolean updateProperties(E local, @CheckForNull Entry peer) {
        boolean rdc = false;
        if (-1L == ((ZipEntry)local).getTime()) {
            ((ZipEntry)local).setTime(System.currentTimeMillis());
        }
        if (null != peer) {
            AbstractZipDriverEntry zpeer;
            if (-1L == ((ZipEntry)local).getSize()) {
                ((ZipEntry)local).setSize(peer.getSize(Entry.Size.DATA));
            }
            if (peer instanceof AbstractZipDriverEntry && (rdc = this.driver.rdc(this, local, zpeer = (AbstractZipDriverEntry)peer))) {
                ((ZipEntry)local).setPlatform(zpeer.getPlatform());
                ((ZipEntry)local).setEncrypted(zpeer.isEncrypted());
                ((ZipEntry)local).setMethod(zpeer.getMethod());
                ((ZipEntry)local).setCrc(zpeer.getCrc());
                ((ZipEntry)local).setSize(zpeer.getSize());
                ((ZipEntry)local).setCompressedSize(zpeer.getCompressedSize());
                ((ZipEntry)local).setExtra(zpeer.getExtra());
            }
        }
        if (0L == ((ZipEntry)local).getSize()) {
            rdc = false;
            ((ZipEntry)local).clearEncryption();
            ((ZipEntry)local).setMethod(0);
            ((ZipEntry)local).setCrc(0L);
            ((ZipEntry)local).setCompressedSize(0L);
        }
        return rdc;
    }

    @Override
    public boolean isBusy() {
        return super.isBusy() || null != this.bufferedEntry;
    }

    @Override
    public void close() throws IOException {
        super.finish();
        IoBuffer postamble = this.postamble;
        if (null != postamble) {
            this.postamble = null;
            InputSocket input2 = postamble.input();
            Throwable ex = null;
            try (InputStream in = input2.stream(null);){
                long ol = this.length();
                long ipl = input2.target().getSize(Entry.Size.DATA);
                if ((ol + ipl) % 4L != 0L) {
                    this.write(new byte[4 - (int)(ol % 4L)]);
                }
                Streams.cat(in, this);
            }
            catch (Throwable ex2) {
                ex = ex2;
                throw ex2;
            }
            finally {
                try {
                    postamble.release();
                }
                catch (Throwable ex2) {
                    if (null == ex) {
                        throw ex2;
                    }
                    ex.addSuppressed(ex2);
                }
            }
        }
        super.close();
    }

    @CleanupObligation
    private static final class BufferedEntryOutputStream
    extends DecoratingOutputStream {
        final IoBuffer buffer;
        final E local;
        boolean closed;
        final /* synthetic */ ZipOutputService this$0;

        @CreatesObligation
        BufferedEntryOutputStream(E local) throws IOException {
            this.this$0 = var1_1;
            assert (0 == ((ZipEntry)local).getMethod());
            this.local = local;
            IoBuffer buffer = this.buffer = (IoBuffer)((ZipOutputService)var1_1).getPool().allocate();
            try {
                this.out = new CheckedOutputStream(buffer.output().stream(null), new CRC32());
            }
            catch (Throwable ex) {
                try {
                    buffer.release();
                }
                catch (Throwable ex2) {
                    ex.addSuppressed(ex2);
                }
                throw ex;
            }
            ((ZipOutputService)var1_1).bufferedEntry = local;
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.this$0.bufferedEntry = null;
            this.out.close();
            this.updateProperties();
            this.storeBuffer();
        }

        void updateProperties() {
            Object local = this.local;
            IoBuffer buffer = this.buffer;
            ((ZipEntry)local).setCrc(((CheckedOutputStream)this.out).getChecksum().getValue());
            long length = buffer.getSize(Entry.Size.DATA);
            ((ZipEntry)local).setSize(length);
            ((ZipEntry)local).setCompressedSize(length);
            this.this$0.updateProperties(local, buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void storeBuffer() throws IOException {
            IoBuffer buffer = this.buffer;
            SuppressedExceptionBuilder builder = new SuppressedExceptionBuilder();
            try (InputStream in = buffer.input().stream(null);){
                ZipOutputService zos = this.this$0;
                zos.putNextEntry(this.local, true);
                try {
                    Streams.cat(in, zos);
                }
                catch (InputException ex) {
                    builder.warn(ex);
                }
                try {
                    zos.closeEntry();
                }
                catch (IOException ex) {
                    builder.warn(ex);
                }
            }
            catch (IOException ex) {
                builder.warn(ex);
            }
            finally {
                try {
                    buffer.release();
                }
                catch (IOException ex) {
                    builder.warn(ex);
                }
            }
            builder.check();
        }
    }

    @CleanupObligation
    private final class EntryOutputStream
    extends DisconnectingOutputStream {
        boolean closed;
        final /* synthetic */ ZipOutputService this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        @CreatesObligation
        EntryOutputStream(E local, boolean rdc) throws IOException {
            this.this$0 = (ZipOutputService)n;
            super((OutputStream)n);
            n.putNextEntry(local, !rdc);
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.this$0.closeEntry();
        }
    }

    private static final class DirectoryTemplate
    implements Entry {
        static final DirectoryTemplate INSTANCE = new DirectoryTemplate();

        private DirectoryTemplate() {
        }

        @Override
        public String getName() {
            return "/";
        }

        @Override
        public long getSize(Entry.Size type) {
            return 0L;
        }

        @Override
        public long getTime(Entry.Access type) {
            return -1L;
        }

        @Override
        public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
            return null;
        }
    }
}

