/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zipdriver;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.logging.LocalizedLogger;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.comp.zip.ZipCryptoParameters;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zip.ZipFileParameters;
import net.java.truevfs.comp.zip.ZipOutputStreamParameters;
import net.java.truevfs.comp.zipdriver.AbstractZipDriverEntry;
import net.java.truevfs.comp.zipdriver.KeyManagerZipCryptoParameters;
import net.java.truevfs.comp.zipdriver.ZipInputService;
import net.java.truevfs.comp.zipdriver.ZipKeyController;
import net.java.truevfs.comp.zipdriver.ZipOutputService;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsArchiveDriver;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsInputSocketSource;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsOutputSocketSink;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputService;
import net.java.truevfs.kernel.spec.cio.IoBufferPool;
import net.java.truevfs.kernel.spec.cio.MultiplexingOutputService;
import net.java.truevfs.kernel.spec.cio.OutputService;
import net.java.truevfs.kernel.spec.sl.IoBufferPoolLocator;
import net.java.truevfs.key.spec.KeyManagerContainer;
import net.java.truevfs.key.spec.sl.KeyManagerMapLocator;
import org.slf4j.Logger;

@Immutable
public abstract class AbstractZipDriver<E extends AbstractZipDriverEntry>
extends FsArchiveDriver<E>
implements ZipOutputStreamParameters,
ZipFileParameters<E> {
    private static final Logger logger = new LocalizedLogger(AbstractZipDriver.class);

    @Override
    public IoBufferPool getPool() {
        return IoBufferPoolLocator.SINGLETON.get();
    }

    public KeyManagerContainer getKeyManagerContainer() {
        return KeyManagerMapLocator.SINGLETON;
    }

    @CheckForNull
    public final ZipCryptoParameters zipCryptoParameters(ZipInputService<E> input2) {
        return this.zipCryptoParameters(input2.getModel(), input2.getRawCharset());
    }

    @CheckForNull
    public final ZipCryptoParameters zipCryptoParameters(ZipOutputService<E> output2) {
        return this.zipCryptoParameters(output2.getModel(), output2.getRawCharset());
    }

    @CheckForNull
    protected ZipCryptoParameters zipCryptoParameters(FsModel model, Charset charset) {
        return new KeyManagerZipCryptoParameters(this, model, charset);
    }

    public URI mountPointUri(FsModel model) {
        return model.getMountPoint().getHierarchicalUri();
    }

    public URI fileSystemUri(FsModel model, String name) {
        return this.mountPointUri(model);
    }

    @Override
    public boolean getRedundantContentSupport() {
        return true;
    }

    @Override
    public boolean getRedundantMetaDataSupport() {
        return true;
    }

    public boolean check(E local, @WillNotClose ZipInputService<E> input2) {
        return ((ZipEntry)local).isEncrypted();
    }

    public final boolean rdc(@WillNotClose ZipInputService<E> input2, E local, AbstractZipDriverEntry peer) {
        return this.rdc((AbstractZipDriverEntry)local, peer);
    }

    public final boolean rdc(@WillNotClose ZipOutputService<E> output2, E local, AbstractZipDriverEntry peer) {
        return this.rdc(peer, (AbstractZipDriverEntry)local);
    }

    protected boolean rdc(AbstractZipDriverEntry input2, AbstractZipDriverEntry output2) {
        return !input2.isEncrypted() && !output2.isEncrypted();
    }

    @Override
    public boolean getPreambled() {
        return false;
    }

    @Override
    public boolean getPostambled() {
        return false;
    }

    @Override
    public int getOverheadSize() {
        return 47;
    }

    @Override
    public int getMethod() {
        return 8;
    }

    @Override
    public int getLevel() {
        return 9;
    }

    @Override
    public FsController decorate(FsController controller2) {
        return new ZipKeyController(controller2, this);
    }

    @Override
    protected final ZipInputService<E> newInput(FsModel model, FsInputSocketSource source) throws IOException {
        ZipInputService<E> zis = this.newZipInput(Objects.requireNonNull(model), source);
        try {
            zis.recoverLostEntries();
        }
        catch (IOException ex) {
            logger.warn("junkInTheTrunk.warning", this.mountPointUri(model), (Object)zis.getPostambleLength());
            logger.debug("junkInTheTrunk.debug", ex);
        }
        return zis;
    }

    @CreatesObligation
    protected ZipInputService<E> newZipInput(FsModel model, FsInputSocketSource source) throws IOException {
        assert (null != model);
        return new ZipInputService(model, source, this);
    }

    @Override
    @CreatesObligation
    protected OutputService<E> newOutput(FsModel model, FsOutputSocketSink sink, @CheckForNull @WillNotClose InputService<E> input2) throws IOException {
        ZipInputService zis = (ZipInputService)input2;
        return new MultiplexingOutputService(this.getPool(), new ZipOutputService(model, sink, zis, this));
    }

    @Override
    protected FsOutputSocketSink sink(BitField<FsAccessOption> options, FsController controller2, FsNodeName name) {
        if ((options = options.set(FsAccessOption.STORE)).get(FsAccessOption.GROW)) {
            options = options.set(FsAccessOption.APPEND).clear(FsAccessOption.CACHE);
        }
        return new FsOutputSocketSink(options, controller2.output(options, name, null));
    }

    @Override
    public E newEntry(BitField<FsAccessOption> options, String name, Entry.Type type, @CheckForNull Entry template) {
        ZipEntry entry2;
        name = AbstractZipDriver.normalize(name, type);
        if (template instanceof ZipEntry) {
            entry2 = this.newEntry(name, (ZipEntry)((Object)template));
        } else {
            entry2 = this.newEntry(name);
            if (null != template) {
                entry2.setTime(template.getTime(Entry.Access.WRITE));
                entry2.setSize(template.getSize(Entry.Size.DATA));
            }
        }
        if (options.get(FsAccessOption.COMPRESS)) {
            entry2.setMethod(8);
        } else if (options.get(FsAccessOption.STORE)) {
            entry2.setMethod(0);
        }
        if (Entry.Type.DIRECTORY != type) {
            if (-1 == entry2.getMethod()) {
                int method = this.getMethod();
                entry2.setMethod(method);
                if (0 != method) {
                    entry2.setCompressedSize(-1L);
                }
            }
            if (options.get(FsAccessOption.ENCRYPT)) {
                entry2.setEncrypted(true);
            }
        }
        return (E)entry2;
    }

    @Override
    public abstract E newEntry(String var1);

    public abstract E newEntry(String var1, ZipEntry var2);
}

