/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import java.util.Map;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truevfs.comp.zip.Constants;
import net.java.truevfs.comp.zip.ExtraField;
import net.java.truevfs.comp.zip.LittleEndian;
import net.java.truevfs.comp.zip.UShort;

@NotThreadSafe
final class ExtraFields
implements Cloneable {
    private Map<Integer, ExtraField> extra = new TreeMap<Integer, ExtraField>();

    ExtraFields() {
    }

    public ExtraFields clone() {
        try {
            ExtraFields clone2 = (ExtraFields)super.clone();
            clone2.extra = new TreeMap<Integer, ExtraField>(this.extra);
            return clone2;
        }
        catch (CloneNotSupportedException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    int size() {
        return this.extra.size();
    }

    @CheckForNull
    ExtraField get(int headerId) {
        assert (UShort.check(headerId));
        ExtraField ef = this.extra.get(headerId);
        assert (null == ef || ef.getHeaderId() == headerId);
        return ef;
    }

    ExtraField add(ExtraField ef) {
        int headerId = ef.getHeaderId();
        assert (UShort.check(headerId));
        return this.extra.put(headerId, ef);
    }

    @Nullable
    ExtraField remove(int headerId) {
        assert (UShort.check(headerId));
        ExtraField ef = this.extra.remove(headerId);
        assert (null == ef || ef.getHeaderId() == headerId);
        return ef;
    }

    int getExtraLength() {
        Map<Integer, ExtraField> extra = this.extra;
        if (extra.isEmpty()) {
            return 0;
        }
        int l = 0;
        for (ExtraField ef : extra.values()) {
            l += 4 + ef.getDataSize();
        }
        return l;
    }

    byte[] getExtra() {
        int size2 = this.getExtraLength();
        assert (UShort.check(size2));
        if (0 == size2) {
            return Constants.EMPTY;
        }
        byte[] data2 = new byte[size2];
        this.writeTo(data2, 0);
        return data2;
    }

    void readFrom(byte[] data2, int off, int size2) {
        assert (UShort.check(size2));
        TreeMap<Integer, ExtraField> map2 = new TreeMap<Integer, ExtraField>();
        if (null != data2 && 0 < size2) {
            int end = off + size2;
            while (off < end) {
                int headerId = LittleEndian.readUShort(data2, off);
                int dataSize = LittleEndian.readUShort(data2, off += 2);
                ExtraField ef = ExtraField.create(headerId);
                ef.readFrom(data2, off += 2, dataSize);
                off += dataSize;
                map2.put(headerId, ef);
            }
            assert (off == end);
        }
        this.extra = map2;
    }

    void writeTo(byte[] data2, int off) {
        for (ExtraField ef : this.extra.values()) {
            LittleEndian.writeShort(ef.getHeaderId(), data2, off);
            LittleEndian.writeShort(ef.getDataSize(), data2, off += 2);
            ef.writeTo(data2, off += 2);
            off += ef.getDataSize();
        }
    }
}

