/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.jmx;

import javax.annotation.concurrent.ThreadSafe;
import javax.management.ObjectName;
import net.java.truevfs.comp.inst.InstrumentingModel;
import net.java.truevfs.comp.jmx.JmxColleague;
import net.java.truevfs.comp.jmx.JmxMediator;
import net.java.truevfs.comp.jmx.JmxModelView;
import net.java.truevfs.comp.jmx.JmxUtils;
import net.java.truevfs.kernel.spec.FsModel;

@ThreadSafe
public class JmxModel<M extends JmxMediator<M>>
extends InstrumentingModel<M>
implements JmxColleague {
    private final ObjectName name = this.getObjectName();

    public JmxModel(M mediator, FsModel model) {
        super(mediator, model);
    }

    private ObjectName getObjectName() {
        return ((JmxMediator)this.mediator).nameBuilder(FsModel.class).put("mountPoint", ObjectName.quote(this.model.getMountPoint().getHierarchicalUri().toString())).get();
    }

    protected Object newView() {
        return new JmxModelView<FsModel>(this.model);
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMounted(boolean mounted) {
        try {
            this.model.setMounted(mounted);
        }
        finally {
            if (mounted) {
                JmxUtils.register(this.name, this.newView());
            } else {
                JmxUtils.deregister(this.name);
            }
        }
    }
}

