/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import java.net.URI;
import java.net.URISyntaxException;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.access.TConfig;
import net.java.truevfs.access.TFile;
import net.java.truevfs.kernel.spec.FsFilteringManager;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsSyncException;
import net.java.truevfs.kernel.spec.FsSyncOption;
import net.java.truevfs.kernel.spec.FsSyncOptions;
import net.java.truevfs.kernel.spec.FsSyncWarningException;
import net.java.truevfs.kernel.spec.FsUriModifier;

public final class TVFS {
    private TVFS() {
    }

    public static void umount() throws FsSyncWarningException, FsSyncException {
        TVFS.sync(FsSyncOptions.UMOUNT);
    }

    public static void umount(TFile tree) throws FsSyncWarningException, FsSyncException {
        TVFS.sync(tree, FsSyncOptions.UMOUNT);
    }

    public static void umount(FsMountPoint tree) throws FsSyncWarningException, FsSyncException {
        TVFS.sync(tree, FsSyncOptions.UMOUNT);
    }

    static FsMountPoint mountPoint(TFile tree) {
        if (tree.isArchive()) {
            return tree.getController().getModel().getMountPoint();
        }
        try {
            return new FsMountPoint(new URI(tree.getFile().toURI() + "/"), FsUriModifier.CANONICALIZE);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static void sync(FsSyncOption ... options) throws FsSyncWarningException, FsSyncException {
        TVFS.sync(FsSyncOptions.of(options));
    }

    public static void sync(BitField<FsSyncOption> options) throws FsSyncWarningException, FsSyncException {
        TConfig.current().getManager().sync(options);
    }

    public static void sync(TFile tree, FsSyncOption ... options) throws FsSyncWarningException, FsSyncException {
        TVFS.sync(tree, FsSyncOptions.of(options));
    }

    public static void sync(TFile tree, BitField<FsSyncOption> options) throws FsSyncWarningException, FsSyncException {
        TVFS.sync(TVFS.mountPoint(tree), options);
    }

    public static void sync(FsMountPoint tree, FsSyncOption ... options) throws FsSyncWarningException, FsSyncException {
        TVFS.sync(tree, FsSyncOptions.of(options));
    }

    public static void sync(FsMountPoint tree, BitField<FsSyncOption> options) throws FsSyncWarningException, FsSyncException {
        new FsFilteringManager(tree, TConfig.current().getManager()).sync(options);
    }
}

