/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.shed.Paths;
import net.java.truecommons.shed.QuotedUriSyntaxException;
import net.java.truecommons.shed.UriBuilder;

@ThreadSafe
final class TUriHelper {
    static final URI SEPARATOR_URI = URI.create("/");
    static final URI DOT_URI = URI.create(".");
    static final URI DOT_DOT_URI = URI.create("..");

    static int pathPrefixLength(URI uri) {
        String ssp = uri.getSchemeSpecificPart();
        String a = uri.getAuthority();
        int al = null == a ? 0 : 2 + a.length();
        int pl = Paths.prefixLength(ssp, '/', true) - al;
        return pl >= 0 ? pl : Paths.prefixLength(uri.getPath(), '/', false);
    }

    static URI check(URI uri) throws URISyntaxException {
        if (null != uri.getFragment()) {
            throw new QuotedUriSyntaxException(uri, "Fragment component defined");
        }
        return uri;
    }

    static URI fix(URI uri) {
        String ssp = uri.getSchemeSpecificPart();
        String a = uri.getAuthority();
        if (null == ssp || null == a && ssp.startsWith("//")) {
            return new UriBuilder(uri).toUri();
        }
        return uri;
    }

    static boolean hasAbsolutePath(URI uri) {
        return !uri.isOpaque() && Paths.isAbsolute(uri.getSchemeSpecificPart(), '/');
    }

    private TUriHelper() {
    }
}

