/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.zip.raes;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.comp.zipdriver.JarDriver;
import net.java.truevfs.comp.zipdriver.JarDriverEntry;
import net.java.truevfs.comp.zipdriver.ZipInputService;
import net.java.truevfs.comp.zipdriver.ZipOutputService;
import net.java.truevfs.driver.zip.raes.KeyManagerRaesParameters;
import net.java.truevfs.driver.zip.raes.ZipRaesKeyController;
import net.java.truevfs.driver.zip.raes.crypto.RaesOutputStream;
import net.java.truevfs.driver.zip.raes.crypto.RaesParameters;
import net.java.truevfs.driver.zip.raes.crypto.RaesReadOnlyChannel;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsInputSocketSource;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsOutputSocketSink;
import net.java.truevfs.kernel.spec.cio.Entry;
import net.java.truevfs.kernel.spec.cio.InputService;
import net.java.truevfs.kernel.spec.cio.MultiplexingOutputService;
import net.java.truevfs.kernel.spec.cio.OutputService;

@Immutable
public abstract class ZipRaesDriver
extends JarDriver {
    @Override
    public final boolean getPreambled() {
        return true;
    }

    protected RaesParameters raesParameters(FsModel model) {
        return new KeyManagerRaesParameters(this.getKeyManagerContainer(), this.mountPointUri(model));
    }

    protected abstract long getAuthenticationTrigger();

    @Override
    public final boolean check(JarDriverEntry local, ZipInputService<JarDriverEntry> input2) {
        return input2.length() > this.getAuthenticationTrigger();
    }

    @Override
    public FsController decorate(FsController controller2) {
        return new ZipRaesKeyController(controller2, this);
    }

    @Override
    protected ZipInputService<JarDriverEntry> newZipInput(final FsModel model, final FsInputSocketSource source) throws IOException {
        final class Source
        extends FsInputSocketSource {
            Source() {
                super(fsInputSocketSource);
            }

            @Override
            public SeekableByteChannel channel() throws IOException {
                RaesReadOnlyChannel channel2 = RaesReadOnlyChannel.create(ZipRaesDriver.this.raesParameters(model), source);
                try {
                    if (channel2.size() <= ZipRaesDriver.this.getAuthenticationTrigger()) {
                        channel2.authenticate();
                    }
                    return channel2;
                }
                catch (Throwable ex) {
                    try {
                        channel2.close();
                    }
                    catch (IOException ex2) {
                        ex.addSuppressed(ex2);
                    }
                    throw ex;
                }
            }
        }
        return new ZipInputService<JarDriverEntry>(model, new Source(), this);
    }

    @Override
    protected OutputService<JarDriverEntry> newOutput(FsModel model, FsOutputSocketSink sink, @CheckForNull @WillNotClose InputService<JarDriverEntry> input2) throws IOException {
        ZipInputService zis = (ZipInputService)input2;
        return new MultiplexingOutputService<JarDriverEntry>(this.getPool(), new ZipOutputService<JarDriverEntry>(model, new RaesSocketSink(model, sink), zis, this));
    }

    @Override
    protected final FsOutputSocketSink sink(BitField<FsAccessOption> options, FsController controller2, FsNodeName name) {
        options = options.set(FsAccessOption.STORE);
        options = options.clear(FsAccessOption.GROW);
        return new FsOutputSocketSink(options, controller2.output(options, name, null));
    }

    @Override
    public JarDriverEntry newEntry(BitField<FsAccessOption> options, String name, Entry.Type type, @CheckForNull Entry template) {
        JarDriverEntry entry2 = (JarDriverEntry)super.newEntry((BitField)options.set(FsAccessOption.COMPRESS), name, type, template);
        entry2.clearEncryption();
        return entry2;
    }

    final class RaesSocketSink
    extends FsOutputSocketSink {
        private final FsModel model;
        private final FsOutputSocketSink sink;

        RaesSocketSink(FsModel model, FsOutputSocketSink sink) {
            super(sink);
            this.model = model;
            this.sink = sink;
        }

        @Override
        public OutputStream stream() throws IOException {
            return RaesOutputStream.create(ZipRaesDriver.this.raesParameters(this.model), this.sink);
        }

        @Override
        public SeekableByteChannel channel() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

