/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.shed.PathSplitter;
import net.java.truecommons.shed.Paths;
import net.java.truecommons.shed.QuotedUriSyntaxException;
import net.java.truecommons.shed.UriBuilder;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.FsScheme;
import net.java.truevfs.kernel.spec.FsUriModifier;

@NotThreadSafe
final class TPathScanner {
    static final URI SEPARATOR_URI = URI.create("/");
    static final URI DOT_URI = URI.create(".");
    static final URI DOT_DOT_URI = URI.create("..");
    static final String DOT_DOT_SEPARATOR = "../";
    private final TArchiveDetector detector;
    private final PathSplitter splitter = new PathSplitter('/', false);
    private FsNodePath root;
    private String memberQuery;
    private final UriBuilder uri = new UriBuilder();

    TPathScanner(TArchiveDetector detector) {
        assert (null != detector);
        this.detector = detector;
    }

    FsNodePath scan(FsNodePath parent, URI member) {
        try {
            String mp;
            member = TPathScanner.checkFix(member.normalize());
            while ((mp = member.getPath()).startsWith(DOT_DOT_SEPARATOR)) {
                parent = TPathScanner.parent(parent);
                member = new UriBuilder(member).path(mp.substring(3)).getUri();
            }
            if ("..".equals(mp)) {
                return TPathScanner.parent(parent);
            }
            int mpl = TPathScanner.pathPrefixLength(member);
            if (0 < mpl) {
                URI pu = parent.toHierarchicalUri().resolve(SEPARATOR_URI);
                String ma = member.getAuthority();
                String p = null != ma || mp.startsWith("/") ? mp.substring(0, mpl) : pu.getPath() + mp.substring(0, mpl);
                this.root = new FsNodePath(new UriBuilder().scheme(pu.getScheme()).authority(ma).path(p).getUri());
                mp = mp.substring(mpl);
            } else {
                this.root = parent;
            }
            this.memberQuery = member.getQuery();
            return this.scan(mp);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private FsNodePath scan(String path) throws URISyntaxException {
        FsNodePath mp;
        URI ppu;
        FsNodePath pp;
        FsNodeName men;
        this.splitter.split(path);
        String ps = this.splitter.getParentPath();
        if (null != ps) {
            men = new FsNodeName(this.uri.path(this.splitter.getMemberName()).getUri(), FsUriModifier.NULL);
            pp = this.scan(ps);
        } else {
            men = new FsNodeName(this.uri.path(path).query(this.memberQuery).getUri(), FsUriModifier.CANONICALIZE);
            pp = this.root;
        }
        if (men.isRoot() || (ppu = pp.toUri()).isOpaque() || !ppu.isAbsolute()) {
            mp = pp.resolve(men);
        } else {
            String pup = ppu.getPath();
            if (!pup.endsWith("/")) {
                ppu = new UriBuilder(ppu).path(pup + '/').getUri();
            }
            mp = new FsNodePath(new FsMountPoint(ppu), men);
        }
        FsScheme s = this.detector.scheme(men.toString());
        if (null != s) {
            mp = new FsNodePath(new FsMountPoint(s, mp), FsNodeName.ROOT);
        }
        return mp;
    }

    static int pathPrefixLength(URI uri) {
        String ssp = uri.getSchemeSpecificPart();
        String a = uri.getAuthority();
        int al = null == a ? 0 : 2 + a.length();
        int pl = Paths.prefixLength(ssp, '/', true) - al;
        return pl >= 0 ? pl : Paths.prefixLength(uri.getPath(), '/', false);
    }

    static URI checkFix(URI uri) throws URISyntaxException {
        if (uri.isOpaque()) {
            throw new QuotedUriSyntaxException(uri, "Opaque URI");
        }
        if (null != uri.getFragment()) {
            throw new QuotedUriSyntaxException(uri, "Fragment component defined");
        }
        return TPathScanner.fixChecked(uri);
    }

    static URI fixUnchecked(URI uri) {
        return uri.isOpaque() ? uri : TPathScanner.fixChecked(uri);
    }

    private static URI fixChecked(URI uri) {
        String ssp = uri.getSchemeSpecificPart();
        String a = uri.getAuthority();
        if (null == ssp || null == a && ssp.startsWith("//")) {
            return new UriBuilder(uri).toUri();
        }
        return uri;
    }

    static boolean isAbsolute(URI uri) {
        return uri.isAbsolute() || Paths.isAbsolute(uri.getSchemeSpecificPart(), '/');
    }

    @Nullable
    static FsNodePath parent(FsNodePath path) throws URISyntaxException {
        FsMountPoint mp = path.getMountPoint();
        FsNodeName en = path.getNodeName();
        if (en.isRoot()) {
            if (null == mp) {
                return null;
            }
            path = mp.getPath();
            if (null != path) {
                return TPathScanner.parent(path);
            }
            URI mpu = mp.toUri();
            URI pu = mpu.resolve(DOT_DOT_URI);
            if (mpu.getRawPath().length() <= pu.getRawPath().length()) {
                return null;
            }
            return new FsNodePath(pu);
        }
        URI pu = en.toUri().resolve(DOT_URI);
        en = new FsNodeName(pu, FsUriModifier.CANONICALIZE);
        return new FsNodePath(mp, en);
    }
}

