/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.ZipException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingOutputStream;
import net.java.truecommons.io.LittleEndianOutputStream;
import net.java.truecommons.io.Sink;
import net.java.truecommons.key.spec.common.AesKeyStrength;
import net.java.truecommons.shed.HashMaps;
import net.java.truevfs.comp.zip.AbstractZipFile;
import net.java.truevfs.comp.zip.Constants;
import net.java.truevfs.comp.zip.Crc32Exception;
import net.java.truevfs.comp.zip.Crc32OutputStream;
import net.java.truevfs.comp.zip.DecoratingOutputMethod;
import net.java.truevfs.comp.zip.OutputMethod;
import net.java.truevfs.comp.zip.UShort;
import net.java.truevfs.comp.zip.WinZipAesEntryParameters;
import net.java.truevfs.comp.zip.WinZipAesExtraField;
import net.java.truevfs.comp.zip.WinZipAesOutputStream;
import net.java.truevfs.comp.zip.WinZipAesParameters;
import net.java.truevfs.comp.zip.WinZipAesUtils;
import net.java.truevfs.comp.zip.ZipCryptoParameters;
import net.java.truevfs.comp.zip.ZipDeflaterOutputStream;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zip.ZipOutputStreamParameters;
import net.java.truevfs.comp.zip.ZipParameters;
import net.java.truevfs.comp.zip.ZipParametersException;
import net.java.truevfs.comp.zip.ZipParametersProvider;
import net.java.truevfs.comp.zip.ZipParametersUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

@NotThreadSafe
public abstract class AbstractZipOutputStream<E extends ZipEntry>
extends DecoratingOutputStream
implements Iterable<E> {
    private final LittleEndianOutputStream leos;
    private final Charset charset;
    private int method;
    private int level;
    @CheckForNull
    private byte[] comment;
    private final Map<String, E> entries;
    private long cdOffset;
    private boolean finished;
    @Nullable
    private ZipEntry entry;
    @Nullable
    private OutputMethod processor;

    @CreatesObligation
    protected AbstractZipOutputStream(Sink sink, @CheckForNull @WillNotClose AbstractZipFile<E> appendee, ZipOutputStreamParameters param2) throws IOException {
        OutputStream out = sink.stream();
        try {
            this.leos = null != appendee ? new AppendingLittleEndianOutputStream(out, appendee) : new LittleEndianOutputStream(out);
            this.out = this.leos;
            if (null != appendee) {
                this.charset = appendee.getRawCharset();
                this.comment = appendee.getRawComment();
                LinkedHashMap<String, E> entries = new LinkedHashMap<String, E>(HashMaps.initialCapacity(appendee.size() + param2.getOverheadSize()));
                entries.putAll(appendee.getRawEntries());
                this.entries = entries;
            } else {
                this.charset = param2.getCharset();
                this.entries = new LinkedHashMap<String, E>(HashMaps.initialCapacity(param2.getOverheadSize()));
            }
            this.setMethod0(param2.getMethod());
            this.setLevel0(param2.getLevel());
        }
        catch (Throwable ex) {
            try {
                out.close();
            }
            catch (Throwable ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    private byte[] encode(String string2) {
        return string2.getBytes(this.charset);
    }

    private String decode(byte[] bytes) {
        return new String(bytes, this.charset);
    }

    public Charset getRawCharset() {
        return this.charset;
    }

    public String getCharset() {
        return this.charset.name();
    }

    public int size() {
        return this.entries.size();
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    public E entry(String name) {
        return (E)((ZipEntry)this.entries.get(name));
    }

    @Nullable
    public String getComment() {
        byte[] comment = this.comment;
        return null == comment ? null : this.decode(comment);
    }

    public void setComment(@CheckForNull String comment) {
        if (null != comment && !comment.isEmpty()) {
            byte[] bytes = this.encode(comment);
            UShort.check(bytes.length);
            this.comment = bytes;
        } else {
            this.comment = null;
        }
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int method) {
        this.setMethod0(method);
    }

    private void setMethod0(int method) {
        ZipEntry test = new ZipEntry("");
        test.setMethod(method);
        this.method = test.getMethod();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.setLevel0(level);
    }

    private void setLevel0(int level) {
        if ((level < 1 || 9 < level) && -1 != level) {
            throw new IllegalArgumentException("Invalid compression level!");
        }
        this.level = level;
    }

    @CheckForNull
    protected abstract ZipCryptoParameters getCryptoParameters();

    public long length() {
        return this.leos.size();
    }

    public boolean isBusy() {
        return null != this.entry;
    }

    public final void putNextEntry(E entry2) throws IOException {
        this.putNextEntry(entry2, true);
    }

    public void putNextEntry(E entry2, boolean process) throws ZipException, IOException {
        this.closeEntry();
        OutputMethod method = this.newOutputMethod((ZipEntry)entry2, process);
        method.init(((ZipEntry)entry2).clone());
        method.init((ZipEntry)entry2);
        this.out = method.start();
        this.processor = method;
        this.entries.put(((ZipEntry)entry2).getName(), entry2);
        this.entry = entry2;
    }

    private OutputMethod newOutputMethod(ZipEntry entry2, boolean process) throws ZipException {
        OutputMethod processor = new RawOutputMethod(process);
        if (!process) {
            assert (-1L != entry2.getCrc());
            return processor;
        }
        int method = entry2.getMethod();
        if (-1 == method) {
            method = this.getMethod();
            entry2.setRawMethod(method);
        }
        boolean skipCrc = false;
        if (entry2.isEncrypted() || 99 == method) {
            ZipCryptoParameters param2 = this.getCryptoParameters();
            if (99 == method) {
                param2 = ZipParametersUtils.parameters(WinZipAesParameters.class, param2);
                WinZipAesExtraField field2 = (WinZipAesExtraField)entry2.getExtraField(39169);
                if (null != field2) {
                    method = field2.getMethod();
                    if (2 == field2.getVendorVersion()) {
                        skipCrc = true;
                    }
                }
            }
            processor = this.newEncryptedOutputMethod((RawOutputMethod)processor, param2);
        }
        switch (method) {
            case 0: {
                if (skipCrc) break;
                processor = new Crc32CheckingOutputMethod(processor);
                break;
            }
            case 8: {
                processor = new DeflaterOutputMethod(processor);
                if (skipCrc) break;
                processor = new Crc32UpdatingOutputMethod(processor);
                break;
            }
            case 12: {
                processor = new BZip2OutputMethod(processor);
                if (skipCrc) break;
                processor = new Crc32UpdatingOutputMethod(processor);
                break;
            }
            default: {
                throw new ZipException(entry2.getName() + " (unsupported compression method " + method + ")");
            }
        }
        return processor;
    }

    private EncryptedOutputMethod newEncryptedOutputMethod(RawOutputMethod processor, @CheckForNull ZipParameters param2) throws ZipParametersException {
        assert (null != processor);
        while (null != param2) {
            if (param2 instanceof WinZipAesParameters) {
                return new WinZipAesOutputMethod(processor, (WinZipAesParameters)param2);
            }
            if (!(param2 instanceof ZipParametersProvider)) break;
            param2 = ((ZipParametersProvider)param2).get(ZipCryptoParameters.class);
        }
        throw new ZipParametersException("No suitable crypto parameters available!");
    }

    public void closeEntry() throws IOException {
        ZipEntry entry2 = this.entry;
        if (null == entry2) {
            return;
        }
        this.processor.finish();
        this.out.flush();
        this.out = this.leos;
        this.processor = null;
        this.entry = null;
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.closeEntry();
        LittleEndianOutputStream leos = this.leos;
        this.cdOffset = leos.size();
        Iterator<E> i = this.entries.values().iterator();
        while (i.hasNext()) {
            if (this.writeCentralFileHeader((ZipEntry)i.next())) continue;
            i.remove();
        }
        this.writeEndOfCentralDirectory();
        this.finished = true;
    }

    private boolean writeCentralFileHeader(ZipEntry entry2) throws IOException {
        long size2;
        long csize = entry2.getCompressedSize();
        if (-1L == (csize | (size2 = entry2.getSize()))) {
            return false;
        }
        LittleEndianOutputStream leos = this.leos;
        leos.writeInt(33639248);
        leos.writeShort(entry2.getRawPlatform() << 8 | 0x3F);
        leos.writeShort(entry2.getRawVersionNeededToExtract());
        leos.writeShort(entry2.getGeneralPurposeBitFlags());
        leos.writeShort(entry2.getRawMethod());
        leos.writeInt((int)entry2.getRawTime());
        leos.writeInt((int)entry2.getRawCrc());
        leos.writeInt((int)entry2.getRawCompressedSize());
        leos.writeInt((int)entry2.getRawSize());
        byte[] name = this.encode(entry2.getName());
        leos.writeShort(name.length);
        byte[] extra = entry2.getRawExtraFields();
        leos.writeShort(extra.length);
        byte[] comment = this.getCommentEncoded(entry2);
        leos.writeShort(comment.length);
        leos.writeShort(0);
        leos.writeShort(0);
        leos.writeInt((int)entry2.getRawExternalAttributes());
        leos.writeInt((int)entry2.getRawOffset());
        leos.write(name);
        leos.write(extra);
        leos.write(comment);
        return true;
    }

    private byte[] getCommentEncoded(ZipEntry entry2) {
        return this.encode(entry2.getRawComment());
    }

    private void writeEndOfCentralDirectory() throws IOException {
        boolean zip64;
        LittleEndianOutputStream leos = this.leos;
        long cdEntries = this.entries.size();
        long cdOffset = this.cdOffset;
        long cdSize = leos.size() - cdOffset;
        boolean cdEntriesZip64 = cdEntries > 65535L || Constants.FORCE_ZIP64_EXT;
        boolean cdSizeZip64 = cdSize > 0xFFFFFFFFL || Constants.FORCE_ZIP64_EXT;
        boolean cdOffsetZip64 = cdOffset > 0xFFFFFFFFL || Constants.FORCE_ZIP64_EXT;
        int cdEntries16 = cdEntriesZip64 ? 65535 : (int)cdEntries;
        long cdSize32 = cdSizeZip64 ? 0xFFFFFFFFL : cdSize;
        long cdOffset32 = cdOffsetZip64 ? 0xFFFFFFFFL : cdOffset;
        boolean bl = zip64 = cdEntriesZip64 || cdSizeZip64 || cdOffsetZip64;
        if (zip64) {
            long zip64eocdOffset = leos.size();
            leos.writeInt(101075792);
            leos.writeLong(44L);
            leos.writeShort(63);
            leos.writeShort(46);
            leos.writeInt(0);
            leos.writeInt(0);
            leos.writeLong(cdEntries);
            leos.writeLong(cdEntries);
            leos.writeLong(cdSize);
            leos.writeLong(cdOffset);
            leos.writeInt(117853008);
            leos.writeInt(0);
            leos.writeLong(zip64eocdOffset);
            leos.writeInt(1);
        }
        leos.writeInt(101010256);
        leos.writeShort(0);
        leos.writeShort(0);
        leos.writeShort(cdEntries16);
        leos.writeShort(cdEntries16);
        leos.writeInt((int)cdSize32);
        leos.writeInt((int)cdOffset32);
        byte[] comment = this.getRawComment();
        leos.writeShort(comment.length);
        leos.write(comment);
    }

    private byte[] getRawComment() {
        byte[] comment = this.comment;
        return null != comment ? comment : Constants.EMPTY;
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    private final class Crc32UpdatingOutputMethod
    extends Crc32OutputMethod {
        Crc32UpdatingOutputMethod(OutputMethod processor) {
            super(processor);
        }

        @Override
        public void finish() throws IOException {
            ZipEntry entry2 = AbstractZipOutputStream.this.entry;
            long crc = this.out.getChecksum().getValue();
            entry2.setRawCrc(crc);
            this.method.finish();
        }
    }

    private final class Crc32CheckingOutputMethod
    extends Crc32OutputMethod {
        Crc32CheckingOutputMethod(OutputMethod processor) {
            super(processor);
        }

        @Override
        public void finish() throws IOException {
            long actualCrc;
            this.method.finish();
            ZipEntry entry2 = AbstractZipOutputStream.this.entry;
            long expectedCrc = entry2.getCrc();
            if (-1L != expectedCrc && expectedCrc != (actualCrc = this.out.getChecksum().getValue())) {
                throw new Crc32Exception(entry2.getName(), expectedCrc, actualCrc);
            }
        }
    }

    private abstract class Crc32OutputMethod
    extends DecoratingOutputMethod {
        @Nullable
        Crc32OutputStream out;

        Crc32OutputMethod(OutputMethod processor) {
            super(processor);
        }

        @Override
        public OutputStream start() throws IOException {
            assert (null == this.out);
            this.out = new Crc32OutputStream(this.method.start());
            return this.out;
        }

        @Override
        public abstract void finish() throws IOException;
    }

    private final class DeflaterOutputMethod
    extends DecoratingOutputMethod {
        @Nullable
        ZipDeflaterOutputStream out;
        @Nullable
        ZipEntry entry;

        DeflaterOutputMethod(OutputMethod processor) {
            super(processor);
        }

        @Override
        public void init(ZipEntry entry2) throws ZipException {
            entry2.setCompressedSize(-1L);
            this.method.init(entry2);
            this.entry = entry2;
        }

        @Override
        public OutputStream start() throws IOException {
            assert (null == this.out);
            this.out = new ZipDeflaterOutputStream(this.method.start(), AbstractZipOutputStream.this.getLevel(), 8192);
            return this.out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish() throws IOException {
            Deflater deflater = this.out.getDeflater();
            try {
                this.out.finish();
                ZipEntry entry2 = this.entry;
                entry2.setRawSize(deflater.getBytesRead());
            }
            finally {
                deflater.end();
            }
            this.method.finish();
        }
    }

    private final class BZip2OutputMethod
    extends DecoratingOutputMethod {
        @Nullable
        BZip2CompressorOutputStream cout;
        @Nullable
        LittleEndianOutputStream dout;
        @Nullable
        ZipEntry entry;

        BZip2OutputMethod(OutputMethod processor) {
            super(processor);
        }

        @Override
        public void init(ZipEntry entry2) throws ZipException {
            entry2.setCompressedSize(-1L);
            this.method.init(entry2);
            this.entry = entry2;
        }

        @Override
        public OutputStream start() throws IOException {
            assert (null == this.cout);
            assert (null == this.dout);
            OutputStream out = this.method.start();
            long size2 = this.entry.getSize();
            int blockSize = -1L != size2 ? BZip2CompressorOutputStream.chooseBlockSize(size2) : this.getBZip2BlockSize();
            this.cout = new BZip2CompressorOutputStream(out, blockSize);
            out = this.cout;
            this.dout = new LittleEndianOutputStream(out);
            return this.dout;
        }

        int getBZip2BlockSize() {
            int level = AbstractZipOutputStream.this.getLevel();
            if (1 <= level && level <= 9) {
                return level;
            }
            return 9;
        }

        @Override
        public void finish() throws IOException {
            this.dout.flush();
            this.cout.finish();
            this.entry.setRawSize(this.dout.size());
            this.method.finish();
        }
    }

    private final class WinZipAesOutputMethod
    extends EncryptedOutputMethod {
        final WinZipAesParameters generalParam;
        boolean suppressCrc;
        @Nullable
        WinZipAesEntryParameters entryParam;
        @Nullable
        WinZipAesOutputStream out;
        @Nullable
        ZipEntry entry;

        WinZipAesOutputMethod(RawOutputMethod processor, WinZipAesParameters param2) {
            super(processor);
            assert (null != param2);
            this.generalParam = param2;
        }

        @Override
        public void init(ZipEntry entry2) throws ZipException {
            WinZipAesEntryParameters entryParam = new WinZipAesEntryParameters(this.generalParam, entry2);
            AesKeyStrength keyStrength = entryParam.getKeyStrength();
            this.entryParam = entryParam;
            WinZipAesExtraField field2 = null;
            int method = entry2.getMethod();
            long csize = entry2.getCompressedSize();
            if (99 == method && null != (field2 = (WinZipAesExtraField)entry2.getExtraField(39169))) {
                method = field2.getMethod();
                if (-1L != csize) {
                    csize -= (long)WinZipAesUtils.overhead(field2.getKeyStrength());
                }
                entry2.setRawMethod(method);
            }
            if (null == field2) {
                field2 = new WinZipAesExtraField();
            }
            field2.setKeyStrength(keyStrength);
            field2.setMethod(method);
            long size2 = entry2.getSize();
            if (20L <= size2 && 12 != method) {
                field2.setVendorVersion(1);
            } else {
                field2.setVendorVersion(2);
                this.suppressCrc = true;
            }
            entry2.addExtraField(field2);
            if (-1L != csize) {
                entry2.setRawCompressedSize(csize += (long)WinZipAesUtils.overhead(keyStrength));
            }
            if (this.suppressCrc) {
                long crc = entry2.getCrc();
                entry2.setRawCrc(0L);
                this.method.init(entry2);
                entry2.setCrc(crc);
            } else {
                this.method.init(entry2);
            }
            entry2.setRawMethod(99);
            this.entry = entry2;
        }

        @Override
        public OutputStream start() throws IOException {
            ZipEntry entry2 = this.entry;
            OutputMethod method = this.method;
            WinZipAesEntryParameters entryParam = this.entryParam;
            assert (null != entryParam);
            assert (null == this.out);
            if (this.suppressCrc) {
                long crc = entry2.getCrc();
                entry2.setRawCrc(0L);
                this.out = new WinZipAesOutputStream(entryParam, (LittleEndianOutputStream)method.start());
                entry2.setCrc(crc);
            } else {
                this.out = new WinZipAesOutputStream(entryParam, (LittleEndianOutputStream)method.start());
            }
            return this.out;
        }

        @Override
        public void finish() throws IOException {
            assert (null != this.out);
            this.out.finish();
            if (this.suppressCrc) {
                ZipEntry entry2 = this.entry;
                entry2.setRawCrc(0L);
                this.method.finish();
                entry2.setCrc(-1L);
            } else {
                this.method.finish();
            }
        }
    }

    private abstract class EncryptedOutputMethod
    extends DecoratingOutputMethod {
        EncryptedOutputMethod(RawOutputMethod processor) {
            super(processor);
        }
    }

    private final class RawOutputMethod
    implements OutputMethod {
        final boolean process;
        private long dataStart;
        @Nullable
        ZipEntry entry;

        RawOutputMethod(boolean process) {
            this.process = process;
        }

        @Override
        public void init(ZipEntry entry2) throws ZipException {
            long size2 = AbstractZipOutputStream.this.encode(entry2.getName()).length + entry2.getRawExtraFields().length + AbstractZipOutputStream.this.encode(entry2.getRawComment()).length;
            if (65535L < size2) {
                throw new ZipException(entry2.getName() + " (the total size of " + size2 + " bytes for the name, extra fields and comment exceeds the maximum size of " + 65535 + " bytes)");
            }
            if (0 == entry2.getMethod() || !this.process) {
                if (-1L == entry2.getCrc()) {
                    throw new ZipException(entry2.getName() + " (unknown CRC-32 value)");
                }
                if (-1L == entry2.getCompressedSize()) {
                    throw new ZipException(entry2.getName() + " (unknown compressed size)");
                }
                if (-1L == entry2.getSize()) {
                    throw new ZipException(entry2.getName() + " (unknown uncompressed size)");
                }
            }
            if (-1 == entry2.getPlatform()) {
                entry2.setRawPlatform(0);
            }
            if (-1L == entry2.getTime()) {
                entry2.setTime(System.currentTimeMillis());
            }
            this.entry = entry2;
        }

        @Override
        public OutputStream start() throws IOException {
            LittleEndianOutputStream leos = AbstractZipOutputStream.this.leos;
            long offset = leos.size();
            ZipEntry entry2 = this.entry;
            boolean encrypted = entry2.isEncrypted();
            boolean dd = entry2.isDataDescriptorRequired();
            boolean utf8 = Constants.UTF8.equals(AbstractZipOutputStream.this.charset);
            int general = (encrypted ? 1 : 0) | (dd ? 8 : 0) | (utf8 ? 2048 : 0);
            AbstractZipOutputStream.this.finished = false;
            leos.writeInt(67324752);
            leos.writeShort(entry2.getRawVersionNeededToExtract());
            leos.writeShort(general);
            leos.writeShort(entry2.getRawMethod());
            leos.writeInt((int)entry2.getRawTime());
            if (dd) {
                leos.writeInt(0);
                leos.writeInt(0);
                leos.writeInt(0);
            } else {
                leos.writeInt((int)entry2.getRawCrc());
                leos.writeInt((int)entry2.getRawCompressedSize());
                leos.writeInt((int)entry2.getRawSize());
            }
            byte[] name = AbstractZipOutputStream.this.encode(entry2.getName());
            leos.writeShort(name.length);
            byte[] extra = entry2.getRawExtraFields();
            leos.writeShort(extra.length);
            leos.write(name);
            leos.write(extra);
            entry2.setGeneralPurposeBitFlags(general);
            entry2.setRawOffset(offset);
            this.dataStart = leos.size();
            return leos;
        }

        @Override
        public void finish() throws IOException {
            LittleEndianOutputStream leos = AbstractZipOutputStream.this.leos;
            long csize = leos.size() - this.dataStart;
            ZipEntry entry2 = this.entry;
            assert (-1L != entry2.getCrc());
            assert (-1L != entry2.getSize());
            if (entry2.getGeneralPurposeBitFlag(8)) {
                entry2.setRawCompressedSize(csize);
                leos.writeInt(134695760);
                leos.writeInt((int)entry2.getRawCrc());
                if (entry2.isZip64ExtensionsRequired()) {
                    leos.writeLong(csize);
                    leos.writeLong(entry2.getSize());
                } else {
                    leos.writeInt((int)entry2.getRawCompressedSize());
                    leos.writeInt((int)entry2.getRawSize());
                }
            } else if (entry2.getCompressedSize() != csize) {
                throw new ZipException(entry2.getName() + " (expected compressed entry size of " + entry2.getCompressedSize() + " bytes, but is actually " + csize + " bytes)");
            }
        }
    }

    private static final class AppendingLittleEndianOutputStream
    extends LittleEndianOutputStream {
        AppendingLittleEndianOutputStream(@WillCloseWhenClosed OutputStream out, @WillNotClose AbstractZipFile<?> appendee) {
            super(out);
            this.written = appendee.getOffsetMapper().unmap(appendee.length());
        }
    }
}

