/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.swing.util;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public abstract class AbstractComboBoxBrowser<E>
implements Serializable {
    private static final long serialVersionUID = 1065103960246722893L;
    private final Listener listener = new Listener();
    @CheckForNull
    private JComboBox<E> comboBox;
    private transient boolean recursion;

    protected AbstractComboBoxBrowser() {
    }

    protected AbstractComboBoxBrowser(@CheckForNull JComboBox<E> comboBox) {
        this.changeComboBox(null, comboBox, false);
    }

    @Nullable
    public JComboBox<E> getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(@CheckForNull JComboBox<E> comboBox) {
        this.changeComboBox(this.getComboBox(), comboBox, true);
    }

    private void changeComboBox(@CheckForNull JComboBox<E> oldCB, @CheckForNull JComboBox<E> newCB, boolean update2) {
        if (newCB == oldCB) {
            return;
        }
        ComboBoxEditor oldCBE = null;
        if (null != oldCB) {
            oldCB.removePropertyChangeListener("editor", this.listener);
            oldCBE = oldCB.getEditor();
            oldCB.setEditor(((DecoratingComboBoxEditor)oldCBE).getEditor());
        }
        this.comboBox = newCB;
        DecoratingComboBoxEditor newCBE = null;
        if (null != newCB) {
            newCB.updateUI();
            newCBE = new DecoratingComboBoxEditor(newCB.getEditor());
            newCB.setEditor(newCBE);
            newCB.addPropertyChangeListener("editor", this.listener);
        }
        this.changeEditor(oldCBE, newCBE, update2);
    }

    private void changeEditor(@CheckForNull ComboBoxEditor oldCBE, @CheckForNull ComboBoxEditor newCBE, boolean update2) {
        Component component;
        Component component2;
        if (newCBE == oldCBE) {
            return;
        }
        JTextComponent oldText = null;
        if (null != oldCBE && (component2 = oldCBE.getEditorComponent()) instanceof JTextComponent) {
            oldText = (JTextComponent)component2;
        }
        JTextComponent newText = null;
        if (null != newCBE && (component = newCBE.getEditorComponent()) instanceof JTextComponent) {
            newText = (JTextComponent)component;
        }
        this.changeText(oldText, newText, update2);
    }

    private void changeText(@CheckForNull JTextComponent oldTC, @CheckForNull JTextComponent newTC, boolean update2) {
        if (newTC == oldTC) {
            return;
        }
        Document oldDocument = null;
        if (null != oldTC) {
            oldTC.removePropertyChangeListener("document", this.listener);
            oldDocument = oldTC.getDocument();
        }
        Document newDocument = null;
        if (null != newTC) {
            newDocument = newTC.getDocument();
            newTC.addPropertyChangeListener("document", this.listener);
        }
        this.changeDocument(oldDocument, newDocument, update2);
    }

    private void changeDocument(@CheckForNull Document oldDoc, @CheckForNull Document newDoc, boolean update2) {
        if (newDoc == oldDoc) {
            return;
        }
        if (null != oldDoc) {
            oldDoc.removeDocumentListener(this.listener);
        }
        if (null != newDoc) {
            if (update2) {
                String txt;
                try {
                    txt = newDoc.getText(0, newDoc.getLength());
                }
                catch (BadLocationException e) {
                    txt = "";
                }
                this.update(txt);
            }
            newDoc.addDocumentListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentUpdated() {
        if (this.lock()) {
            return;
        }
        try {
            JComboBox<E> cb = this.getComboBox();
            ComboBoxEditor cbe = cb.getEditor();
            JTextComponent tc = (JTextComponent)cbe.getEditorComponent();
            assert (cb.isShowing() || !tc.isFocusOwner());
            if (!tc.isFocusOwner()) {
                return;
            }
            cb.setPopupVisible(false);
            if (this.update(tc.getText())) {
                cb.setPopupVisible(true);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEditor(ComboBoxEditor cbe, @CheckForNull Object item) {
        if (this.lock()) {
            return;
        }
        try {
            cbe.setItem(item);
            if (!(item instanceof String)) {
                return;
            }
            JComboBox<E> cb = this.getComboBox();
            JTextComponent tc = (JTextComponent)cbe.getEditorComponent();
            assert (cb.isShowing() || !tc.isFocusOwner());
            if (!tc.isFocusOwner()) {
                return;
            }
            Caret caret = tc.getCaret();
            caret.setDot(((String)item).length());
        }
        finally {
            this.unlock();
        }
    }

    protected abstract boolean update(String var1);

    private boolean lock() {
        if (this.recursion) {
            return true;
        }
        this.recursion = true;
        return false;
    }

    private void unlock() {
        this.recursion = false;
    }

    private final class DecoratingComboBoxEditor
    implements ComboBoxEditor {
        private final ComboBoxEditor editor;

        DecoratingComboBoxEditor(ComboBoxEditor editor) {
            assert (null != editor);
            this.editor = editor;
        }

        ComboBoxEditor getEditor() {
            return this.editor;
        }

        @Override
        public Component getEditorComponent() {
            return this.editor.getEditorComponent();
        }

        @Override
        public void setItem(@CheckForNull Object item) {
            AbstractComboBoxBrowser.this.updateEditor(this.editor, item);
        }

        @Override
        @CheckForNull
        public Object getItem() {
            return this.editor.getItem();
        }

        @Override
        public void selectAll() {
            this.editor.selectAll();
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.editor.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.editor.removeActionListener(actionListener);
        }
    }

    private class Listener
    implements DocumentListener,
    PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AbstractComboBoxBrowser.this.documentUpdated();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String property = e.getPropertyName();
            if ("editor".equals(property)) {
                AbstractComboBoxBrowser.this.changeEditor((ComboBoxEditor)e.getOldValue(), (ComboBoxEditor)e.getNewValue(), true);
            } else if ("document".equals(property)) {
                AbstractComboBoxBrowser.this.changeDocument((Document)e.getOldValue(), (Document)e.getNewValue(), true);
            } else {
                throw new AssertionError((Object)("Received change event for unknown property: " + property));
            }
        }
    }
}

