/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class CRC32VerifyingInputStream
extends InputStream {
    private final InputStream in;
    private long bytesRemaining;
    private final int expectedCrc32;
    private final CRC32 crc32 = new CRC32();

    public CRC32VerifyingInputStream(InputStream in, long size2, int expectedCrc32) {
        this.in = in;
        this.expectedCrc32 = expectedCrc32;
        this.bytesRemaining = size2;
    }

    public int read() throws IOException {
        if (this.bytesRemaining <= 0L) {
            return -1;
        }
        int ret = this.in.read();
        if (ret >= 0) {
            this.crc32.update(ret);
            --this.bytesRemaining;
        }
        if (this.bytesRemaining == 0L && this.expectedCrc32 != (int)this.crc32.getValue()) {
            throw new IOException("CRC32 verification failed");
        }
        return ret;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.in.read(b, off, len);
        if (ret >= 0) {
            this.crc32.update(b, off, ret);
            this.bytesRemaining -= (long)ret;
        }
        if (this.bytesRemaining <= 0L && this.expectedCrc32 != (int)this.crc32.getValue()) {
            throw new IOException("CRC32 verification failed");
        }
        return ret;
    }

    public long skip(long n) throws IOException {
        if (this.read() >= 0) {
            return 1L;
        }
        return 0L;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

