/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.http;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.cio.AbstractInputSocket;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.IoBuffer;
import net.java.truecommons.cio.IoSockets;
import net.java.truecommons.cio.OutputSocket;
import net.java.truecommons.io.ReadOnlyChannel;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.driver.http.HttpNode;
import net.java.truevfs.kernel.spec.FsAccessOption;

@NotThreadSafe
public class HttpInputSocket
extends AbstractInputSocket<HttpNode> {
    private final HttpNode entry;

    HttpInputSocket(BitField<FsAccessOption> options, HttpNode entry2) {
        assert (null != entry2);
        assert (null != options);
        this.entry = entry2;
    }

    @Override
    public HttpNode target() {
        return this.entry;
    }

    @Override
    public InputStream stream(OutputSocket<? extends Entry> peer) throws IOException {
        return this.entry.newInputStream();
    }

    @Override
    public SeekableByteChannel channel(final OutputSocket<? extends Entry> peer) throws IOException {
        final IoBuffer buffer = (IoBuffer)this.entry.getPool().allocate();
        try {
            IoSockets.copy(this.entry.input(), buffer.output());
        }
        catch (Throwable ex) {
            try {
                buffer.release();
            }
            catch (Throwable ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
        final class BufferReadOnlyChannel
        extends ReadOnlyChannel {
            boolean closed;

            @CreatesObligation
            BufferReadOnlyChannel() throws IOException {
                super(ioBuffer.input().channel(outputSocket));
            }

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    this.channel.close();
                    this.closed = true;
                    buffer.release();
                }
            }
        }
        return new BufferReadOnlyChannel();
    }
}

