/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.OneTimeSink;
import net.java.truevfs.comp.zip.AbstractZipOutputStream;
import net.java.truevfs.comp.zip.Constants;
import net.java.truevfs.comp.zip.DefaultZipOutputStreamParameters;
import net.java.truevfs.comp.zip.ZipCryptoParameters;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zip.ZipFile;
import net.java.truevfs.comp.zip.ZipOutputStreamParameters;

@NotThreadSafe
public class ZipOutputStream
extends AbstractZipOutputStream<ZipEntry> {
    public static final Charset DEFAULT_CHARSET = Constants.DEFAULT_CHARSET;
    private static final ZipOutputStreamParameters DEFAULT_PARAM = new DefaultZipOutputStreamParameters(DEFAULT_CHARSET);
    @CheckForNull
    private ZipCryptoParameters cryptoParameters;

    @CreatesObligation
    public ZipOutputStream(@WillCloseWhenClosed OutputStream out) throws IOException {
        super(new OneTimeSink(out), null, DEFAULT_PARAM);
    }

    @CreatesObligation
    public ZipOutputStream(@WillCloseWhenClosed OutputStream out, Charset charset) throws IOException {
        super(new OneTimeSink(out), null, new DefaultZipOutputStreamParameters(charset));
    }

    @CreatesObligation
    public ZipOutputStream(@WillCloseWhenClosed OutputStream out, ZipFile appendee) throws IOException {
        super(new OneTimeSink(out), Objects.requireNonNull(appendee), DEFAULT_PARAM);
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        final class EntryIterator
        implements Iterator<ZipEntry> {
            final Iterator<ZipEntry> i;

            EntryIterator() {
                ArrayList l = new ArrayList(ZipOutputStream.super.size());
                Iterator si = ZipOutputStream.super.iterator();
                while (si.hasNext()) {
                    l.add(si.next());
                }
                this.i = l.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public ZipEntry next() {
                return this.i.next().clone();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new EntryIterator();
    }

    @Override
    public ZipEntry entry(String name) {
        Object entry2 = super.entry(name);
        return entry2 != null ? ((ZipEntry)entry2).clone() : null;
    }

    @Override
    @Nullable
    public ZipCryptoParameters getCryptoParameters() {
        return this.cryptoParameters;
    }

    public void setCryptoParameters(@CheckForNull ZipCryptoParameters cryptoParameters) {
        this.cryptoParameters = cryptoParameters;
    }
}

