/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.BufferedReadOnlyChannel;
import net.java.truecommons.io.ChannelInputStream;
import net.java.truecommons.io.IntervalReadOnlyChannel;
import net.java.truecommons.io.MutableBuffer;
import net.java.truecommons.io.PowerBuffer;
import net.java.truecommons.io.ReadOnlyChannel;
import net.java.truecommons.io.Source;
import net.java.truecommons.shed.HashMaps;
import net.java.truevfs.comp.zip.Constants;
import net.java.truevfs.comp.zip.CountingInputStream;
import net.java.truevfs.comp.zip.Crc32Exception;
import net.java.truevfs.comp.zip.Crc32InputStream;
import net.java.truevfs.comp.zip.DummyByteChannelInputStream;
import net.java.truevfs.comp.zip.OffsetPositionMapper;
import net.java.truevfs.comp.zip.PositionMapper;
import net.java.truevfs.comp.zip.WinZipAesEntryParameters;
import net.java.truevfs.comp.zip.WinZipAesExtraField;
import net.java.truevfs.comp.zip.WinZipAesParameters;
import net.java.truevfs.comp.zip.WinZipAesReadOnlyChannel;
import net.java.truevfs.comp.zip.WinZipAesUtils;
import net.java.truevfs.comp.zip.ZipCryptoParameters;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zip.ZipEntryFactory;
import net.java.truevfs.comp.zip.ZipFileParameters;
import net.java.truevfs.comp.zip.ZipInflaterInputStream;
import net.java.truevfs.comp.zip.ZipParametersUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

@CleanupObligation
@NotThreadSafe
public abstract class AbstractZipFile<E extends ZipEntry>
implements Closeable,
Iterable<E> {
    private static final int LFH_FILE_NAME_LENGTH_POS = 26;
    public static final Charset DEFAULT_CHARSET = Constants.DEFAULT_CHARSET;
    @CheckForNull
    private SeekableByteChannel channel;
    private long length;
    private long preamble;
    private long postamble;
    private final ZipEntryFactory<E> param;
    private Charset charset;
    @CheckForNull
    private byte[] comment;
    private Map<String, E> entries;
    private PositionMapper mapper = new PositionMapper();
    private int open;

    @CreatesObligation
    protected AbstractZipFile(Source source, ZipFileParameters<E> param2) throws ZipException, EOFException, IOException {
        this.param = param2;
        SeekableByteChannel channel2 = this.channel = source.channel();
        try {
            this.length = channel2.size();
            this.charset = param2.getCharset();
            SafeBufferedReadOnlyChannel bchannel = new SafeBufferedReadOnlyChannel(channel2, this.length);
            if (!param2.getPreambled()) {
                this.checkZipFileSignature(bchannel);
            }
            int numEntries = this.findCentralDirectory(bchannel, param2.getPostambled());
            this.mountCentralDirectory(bchannel, numEntries);
            if (this.preamble + this.postamble >= this.length) {
                assert (0 == numEntries);
                if (param2.getPreambled()) {
                    this.checkZipFileSignature(bchannel);
                }
            }
            assert (null != channel2);
            assert (null != this.charset);
            assert (null != this.entries);
            assert (null != this.mapper);
        }
        catch (Throwable ex) {
            try {
                channel2.close();
            }
            catch (Throwable ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    private void checkZipFileSignature(SeekableByteChannel channel2) throws IOException {
        long sig = ((PowerBuffer)((PowerBuffer)PowerBuffer.allocate(4).littleEndian()).load(channel2.position(this.preamble))).getUInt();
        if (67324752L != sig && 101075792L != sig && 101010256L != sig) {
            throw new ZipException("Expected local file header or (ZIP64) end of central directory record!");
        }
    }

    private int findCentralDirectory(SeekableByteChannel channel2, boolean postambled) throws IOException {
        MutableBuffer eocdr = (MutableBuffer)MutableBuffer.allocate(22).littleEndian();
        long max2 = this.length - 22L;
        long min2 = !postambled && max2 >= 65535L ? max2 - 65535L : 0L;
        for (long eocdrPos = max2; eocdrPos >= min2; --eocdrPos) {
            ((MutableBuffer)((MutableBuffer)eocdr.rewind()).limit(4)).load(channel2.position(eocdrPos));
            if (101010256L != eocdr.getUInt()) continue;
            ((MutableBuffer)eocdr.limit(22)).load(channel2);
            long diskNo = eocdr.getUShort();
            long cdDiskNo = eocdr.getUShort();
            long cdEntriesDisk = eocdr.getUShort();
            long cdEntries = eocdr.getUShort();
            if (0L != diskNo || 0L != cdDiskNo || cdEntriesDisk != cdEntries) {
                throw new ZipException("ZIP file spanning/splitting is not supported!");
            }
            long cdSize = eocdr.getUInt();
            long cdPos = eocdr.getUInt();
            int commentLen = eocdr.getUShort();
            if (0 < commentLen) {
                this.comment = ((PowerBuffer)PowerBuffer.allocate(commentLen).load(channel2)).array();
            }
            this.preamble = eocdrPos;
            this.postamble = this.length - channel2.position();
            long eocdlPos = eocdrPos - 20L;
            MutableBuffer zip64eocdl = (MutableBuffer)MutableBuffer.allocate(20).littleEndian();
            if (0L > eocdlPos || 117853008L != ((MutableBuffer)zip64eocdl.load(channel2.position(eocdlPos))).getUInt()) {
                long offset = eocdrPos - cdSize;
                channel2.position(offset);
                if (0L != (offset -= cdPos)) {
                    this.mapper = new OffsetPositionMapper(offset);
                }
                return (int)cdEntries;
            }
            long zip64eocdrDisk = zip64eocdl.getUInt();
            long zip64eocdrPos = zip64eocdl.getLong();
            long totalDisks = zip64eocdl.getUInt();
            if (0L != zip64eocdrDisk || 1L != totalDisks) {
                throw new ZipException("ZIP file spanning/splitting is not supported!");
            }
            MutableBuffer zip64eocdr = (MutableBuffer)((MutableBuffer)MutableBuffer.allocate(56).littleEndian()).load(channel2.position(zip64eocdrPos));
            if (101075792L != zip64eocdr.getUInt()) {
                throw new ZipException("Expected ZIP64 end of central directory record!");
            }
            zip64eocdr.skip(12);
            diskNo = zip64eocdr.getUInt();
            cdDiskNo = zip64eocdr.getUInt();
            cdEntriesDisk = zip64eocdr.getLong();
            cdEntries = zip64eocdr.getLong();
            if (0L != diskNo || 0L != cdDiskNo || cdEntriesDisk != cdEntries) {
                throw new ZipException("ZIP file spanning/splitting is not supported!");
            }
            if (cdEntries < 0L || Integer.MAX_VALUE < cdEntries) {
                throw new ZipException("Total number of entries in the central directory out of range!");
            }
            zip64eocdr.skip(8);
            cdPos = zip64eocdr.getLong();
            channel2.position(cdPos);
            this.preamble = zip64eocdrPos;
            return (int)cdEntries;
        }
        this.preamble = min2;
        this.postamble = this.length - min2;
        return 0;
    }

    private void mountCentralDirectory(SeekableByteChannel channel2, int numEntries) throws IOException {
        MutableBuffer cfh = (MutableBuffer)MutableBuffer.allocate(46).littleEndian();
        LinkedHashMap<String, E> entries = new LinkedHashMap<String, E>(Math.max(HashMaps.initialCapacity(numEntries), 16));
        while (true) {
            boolean utf8;
            ((MutableBuffer)((MutableBuffer)cfh.rewind()).limit(4)).load(channel2);
            if (33639248L != cfh.getUInt()) break;
            ((MutableBuffer)cfh.limit(46)).load(channel2);
            int gpbf = ((MutableBuffer)cfh.position(8)).getUShort();
            int nameLen = ((MutableBuffer)cfh.position(28)).getUShort();
            MutableBuffer name = (MutableBuffer)MutableBuffer.allocate(nameLen).load(channel2);
            boolean bl = utf8 = 0 != (gpbf & 0x800);
            if (utf8) {
                this.charset = Constants.UTF8;
            }
            E entry2 = this.param.newEntry(this.decode(name.array()));
            try {
                cfh.position(4);
                ((ZipEntry)entry2).setRawPlatform(cfh.getUShort() >> 8);
                cfh.skip(4);
                ((ZipEntry)entry2).setGeneralPurposeBitFlags(gpbf);
                ((ZipEntry)entry2).setRawMethod(cfh.getUShort());
                ((ZipEntry)entry2).setRawTime(cfh.getUInt());
                ((ZipEntry)entry2).setRawCrc(cfh.getUInt());
                ((ZipEntry)entry2).setRawCompressedSize(cfh.getUInt());
                ((ZipEntry)entry2).setRawSize(cfh.getUInt());
                cfh.skip(2);
                int extraLen = cfh.getUShort();
                int commentLen = cfh.getUShort();
                cfh.skip(4);
                ((ZipEntry)entry2).setRawExternalAttributes(cfh.getUInt());
                long lfhOff = cfh.getUInt();
                ((ZipEntry)entry2).setRawOffset(lfhOff);
                if (0 < extraLen) {
                    ((ZipEntry)entry2).setRawExtraFields(((PowerBuffer)PowerBuffer.allocate(extraLen).load(channel2)).array());
                }
                if (0 < commentLen) {
                    ((ZipEntry)entry2).setRawComment(this.decode(((PowerBuffer)PowerBuffer.allocate(commentLen).load(channel2)).array()));
                }
                if ((lfhOff = this.mapper.map(((ZipEntry)entry2).getOffset())) < this.preamble) {
                    this.preamble = lfhOff;
                }
            }
            catch (IllegalArgumentException cause) {
                throw (ZipException)new ZipException(((ZipEntry)entry2).getName() + " (invalid meta data)").initCause(cause);
            }
            entries.put(((ZipEntry)entry2).getName(), entry2);
            --numEntries;
        }
        if (0 != numEntries % 65536) {
            throw new ZipException("Expected " + Math.abs(numEntries) + (numEntries > 0 ? " more" : " less") + " entries in the central directory!");
        }
        this.entries = entries;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public AbstractZipFile<E> recoverLostEntries() throws ZipException, EOFException, IOException {
        length = this.length;
        channel = new SafeBufferedReadOnlyChannel(this.channel(), length);
        while (0L < this.postamble) {
            block45: {
                pos = length - this.postamble;
                lfh = (MutableBuffer)((MutableBuffer)MutableBuffer.allocate(30).littleEndian()).load(channel.position(pos));
                if (67324752L != lfh.getUInt()) {
                    throw new ZipException("Expected local file header!");
                }
                gpbf = ((MutableBuffer)lfh.position(6)).getUShort();
                nameLen = ((MutableBuffer)lfh.position(26)).getUShort();
                if (0 != (gpbf & 2048)) {
                    this.charset = Constants.UTF8;
                }
                entry = this.param.newEntry(this.decode(PowerBuffer.allocate(nameLen).load(channel).array()));
                try {
                    entry.setGeneralPurposeBitFlags(gpbf);
                    lfh.position(8);
                    entry.setRawMethod(lfh.getUShort());
                    entry.setRawTime(lfh.getUInt());
                    entry.setRawCrc(lfh.getUInt());
                    entry.setRawCompressedSize(lfh.getUInt());
                    entry.setRawSize(lfh.getUInt());
                    lfh.skip(2);
                    extraLen = lfh.getUShort();
                    entry.setRawOffset(this.mapper.unmap(pos));
                    if (0 < extraLen) {
                        entry.setRawExtraFields(PowerBuffer.allocate(extraLen).load(channel).array());
                    }
                    if (entry.getGeneralPurposeBitFlag(8)) {
                        start = pos = channel.position();
                        echannel /* !! */  = new IntervalReadOnlyChannel(channel, pos, length - pos);
                        field = null;
                        method = entry.getMethod();
                        if (entry.isEncrypted()) {
                            if (99 != method) {
                                throw new ZipException(entry.getName() + " (encrypted compression method " + method + " is not supported)");
                            }
                            echannel /* !! */  = new WinZipAesReadOnlyChannel(echannel /* !! */ , new WinZipAesEntryParameters(ZipParametersUtils.parameters(WinZipAesParameters.class, this.getCryptoParameters()), (ZipEntry)entry));
                            field = (WinZipAesExtraField)entry.getExtraField(39169);
                            method = field.getMethod();
                        }
                        bufSize = AbstractZipFile.getBufferSize(entry);
                        din = null;
                        switch (method) {
                            case 8: {
                                in = new ZipInflaterInputStream((InputStream)new DummyByteChannelInputStream(echannel /* !! */ ), bufSize);
                                break;
                            }
                            case 12: {
                                din = new CountingInputStream(new ChannelInputStream(echannel /* !! */ ));
                                try {
                                    in = new BZip2CompressorInputStream(din);
                                    break;
                                }
                                catch (Throwable ex) {
                                    try {
                                        din.close();
                                    }
                                    catch (Throwable ex2) {
                                        ex.addSuppressed(ex2);
                                    }
                                    throw ex;
                                }
                            }
                            default: {
                                throw new ZipException(entry.getName() + " (compression method " + method + " is not supported)");
                            }
                        }
                        cin = new CheckedInputStream(in, new CRC32());
                        ex2 = null;
                        try {
                            entry.setRawSize(cin.skip(0x7FFFFFFFFFFFFFFFL));
                            if (null != field && field.getVendorVersion() == 2) {
                                entry.setRawCrc(0L);
                            } else {
                                entry.setRawCrc(cin.getChecksum().getValue());
                            }
                            switch (method) {
                                case 8: {
                                    inf = in.getInflater();
                                    if (!AbstractZipFile.$assertionsDisabled && !inf.finished()) {
                                        throw new AssertionError();
                                    }
                                    pos += inf.getBytesRead();
                                    ** break;
lbl74:
                                    // 1 sources

                                    break;
                                }
                                case 12: {
                                    pos += din.getBytesRead();
                                    ** break;
lbl78:
                                    // 1 sources

                                    break;
                                }
                                default: {
                                    throw new AssertionError();
                                }
                            }
                        }
                        catch (Throwable var21_24) {
                            ex2 = var21_24;
                            throw var21_24;
                        }
                        finally {
                            if (cin != null) {
                                if (ex2 != null) {
                                    try {
                                        cin.close();
                                    }
                                    catch (Throwable x2) {
                                        ex2.addSuppressed(x2);
                                    }
                                } else {
                                    cin.close();
                                }
                            }
                        }
                        if (null != field) {
                            pos += (long)WinZipAesUtils.overhead(field.getKeyStrength());
                        }
                        entry.setRawCompressedSize(pos - start);
                        dd = (MutableBuffer)((MutableBuffer)((MutableBuffer)MutableBuffer.allocate(entry.isZip64ExtensionsRequired() != false ? 20 : 12).littleEndian()).limit(4)).load(channel.position(pos));
                        crc = dd.getUInt();
                        if (134695760L == crc) {
                            dd.rewind();
                        }
                        ((MutableBuffer)dd.limit(dd.capacity())).load(channel);
                        crc = ((MutableBuffer)dd.position(0)).getUInt();
                        if (entry.isZip64ExtensionsRequired()) {
                            csize = dd.getLong();
                            size = dd.getLong();
                        } else {
                            csize = dd.getUInt();
                            size = dd.getUInt();
                        }
                        if (entry.getCrc() != crc) {
                            throw new Crc32Exception(entry.getName(), entry.getCrc(), crc);
                        }
                        if (entry.getCompressedSize() != csize) {
                            throw new ZipException(entry.getName() + " (invalid compressed size in data descriptor)");
                        }
                        if (entry.getSize() != size) {
                            throw new ZipException(entry.getName() + " (invalid uncompressed size in data descriptor)");
                        }
                        break block45;
                    }
                    channel.position((pos += entry.getCompressedSize()) - 1L);
                    if (pos > length || channel.position() >= channel.size()) {
                        throw new ZipException(entry.getName() + " (truncated entry data)");
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw (ZipException)new ZipException(entry.getName() + " (invalid meta data)").initCause(ex);
                }
            }
            this.postamble = length - channel.position();
            this.entries.put(entry.getName(), entry);
        }
        return this;
    }

    final Map<String, E> getRawEntries() {
        return this.entries;
    }

    private String decode(byte[] buffer) {
        return new String(buffer, this.charset);
    }

    @CheckForNull
    final byte[] getRawComment() {
        return this.comment;
    }

    @Nullable
    public String getComment() {
        byte[] comment2 = this.comment;
        return null == comment2 ? null : this.decode(comment2);
    }

    public boolean busy() {
        return 0 < this.open;
    }

    public Charset getRawCharset() {
        return this.charset;
    }

    public String getCharset() {
        return this.charset.name();
    }

    public int size() {
        return this.entries.size();
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    public E entry(String name) {
        return (E)((ZipEntry)this.entries.get(name));
    }

    public long length() {
        return this.length;
    }

    public long getPreambleLength() {
        return this.preamble;
    }

    @CreatesObligation
    public InputStream getPreambleInputStream() throws IOException {
        return new ChannelInputStream(new EntryReadOnlyChannel(0L, this.preamble));
    }

    public long getPostambleLength() {
        return this.postamble;
    }

    @CreatesObligation
    public InputStream getPostambleInputStream() throws IOException {
        this.channel();
        return new ChannelInputStream(new EntryReadOnlyChannel(this.length - this.postamble, this.postamble));
    }

    final PositionMapper getOffsetMapper() {
        return this.mapper;
    }

    public boolean offsetsConsiderPreamble() {
        assert (this.mapper != null);
        return 0L == this.mapper.map(0L);
    }

    @CheckForNull
    protected abstract ZipCryptoParameters getCryptoParameters();

    @CreatesObligation
    @Nullable
    public final InputStream getInputStream(String name) throws IOException {
        return this.getInputStream(name, null, true);
    }

    @CreatesObligation
    @Nullable
    public final InputStream getCheckedInputStream(String name) throws IOException {
        return this.getInputStream(name, true, true);
    }

    @CreatesObligation
    @Nullable
    protected InputStream getInputStream(String name, @CheckForNull Boolean check2, boolean process) throws ZipException, IOException {
        ReadOnlyChannel echannel;
        SeekableByteChannel channel2 = this.channel();
        Objects.requireNonNull(name);
        ZipEntry entry2 = (ZipEntry)this.entries.get(name);
        if (null == entry2) {
            return null;
        }
        long pos = entry2.getOffset();
        assert (-1L != pos);
        pos = this.mapper.map(pos);
        MutableBuffer lfh = (MutableBuffer)((MutableBuffer)MutableBuffer.allocate(30).littleEndian()).load(channel2.position(pos));
        if (67324752L != lfh.getUInt()) {
            throw new ZipException(name + " (expected local file header)");
        }
        lfh.position(26);
        pos += (long)(30 + lfh.getUShort() + lfh.getUShort());
        try {
            echannel = new EntryReadOnlyChannel(pos, entry2.getCompressedSize());
        }
        catch (IllegalArgumentException ex) {
            throw (IOException)new ZipException(name + " (invalid meta data in local file header or central directory record)").initCause(ex);
        }
        try {
            InputStream in;
            if (!process) {
                assert (-1L != entry2.getCrc());
                return new ChannelInputStream(echannel);
            }
            if (null == check2) {
                check2 = entry2.isEncrypted();
            }
            int method = entry2.getMethod();
            if (entry2.isEncrypted()) {
                if (99 != method) {
                    throw new ZipException(name + " (encrypted compression method " + method + " is not supported)");
                }
                WinZipAesReadOnlyChannel eechannel = new WinZipAesReadOnlyChannel(echannel, new WinZipAesEntryParameters(ZipParametersUtils.parameters(WinZipAesParameters.class, this.getCryptoParameters()), entry2));
                echannel = eechannel;
                if (check2.booleanValue()) {
                    eechannel.authenticate();
                    check2 = false;
                }
                WinZipAesExtraField field2 = (WinZipAesExtraField)entry2.getExtraField(39169);
                method = field2.getMethod();
            }
            if (check2.booleanValue()) {
                long localCrc;
                if (entry2.getGeneralPurposeBitFlag(8)) {
                    MutableBuffer dd = (MutableBuffer)((MutableBuffer)MutableBuffer.allocate(8).littleEndian()).load(channel2.position(pos + entry2.getCompressedSize()));
                    localCrc = dd.getUInt();
                    if (134695760L == localCrc) {
                        localCrc = dd.getUInt();
                    }
                } else {
                    localCrc = ((MutableBuffer)lfh.position(14)).getUInt();
                }
                if (entry2.getCrc() != localCrc) {
                    throw new Crc32Exception(name, entry2.getCrc(), localCrc);
                }
            }
            int bufSize = AbstractZipFile.getBufferSize(entry2);
            switch (method) {
                case 0: {
                    in = new ChannelInputStream(echannel);
                    break;
                }
                case 8: {
                    in = new ZipInflaterInputStream((InputStream)new DummyByteChannelInputStream(echannel), bufSize);
                    break;
                }
                case 12: {
                    in = new BZip2CompressorInputStream(new ChannelInputStream(echannel));
                    break;
                }
                default: {
                    throw new ZipException(name + " (compression method " + method + " is not supported)");
                }
            }
            if (check2.booleanValue()) {
                in = new Crc32InputStream(in, bufSize, entry2);
            }
            return in;
        }
        catch (Throwable ex) {
            try {
                echannel.close();
            }
            catch (Throwable ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    private static int getBufferSize(ZipEntry entry2) {
        long size2 = entry2.getSize();
        if (8192L < size2) {
            size2 = 8192L;
        } else if (size2 < 1024L) {
            size2 = 1024L;
        }
        return (int)size2;
    }

    private SeekableByteChannel channel() throws ZipException {
        SeekableByteChannel channel2 = this.channel;
        if (null == channel2) {
            throw new ZipException("File closed!");
        }
        return channel2;
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        SeekableByteChannel channel2 = this.channel;
        if (null != channel2) {
            channel2.close();
            this.channel = null;
        }
    }

    private static final class SafeBufferedReadOnlyChannel
    extends BufferedReadOnlyChannel {
        final long size;

        @CreatesObligation
        SafeBufferedReadOnlyChannel(@WillCloseWhenClosed SeekableByteChannel channel2, long size2) {
            super(channel2);
            this.size = size2;
        }

        @Override
        public long size() throws IOException {
            this.checkOpen();
            return this.size;
        }
    }

    private final class EntryReadOnlyChannel
    extends ReadOnlyChannel {
        boolean closed;

        @CreatesObligation
        EntryReadOnlyChannel(long start, long size2) throws IOException {
            super(new IntervalReadOnlyChannel(AbstractZipFile.this.channel(), start, size2));
            AbstractZipFile.this.open++;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            AbstractZipFile.this.open--;
            this.closed = true;
        }
    }
}

