/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access.swing;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.java.truevfs.access.TFile;

public final class TFileTreeModel
implements TreeModel {
    private final Map<TFile, TFile[]> cache = new HashMap<TFile, TFile[]>();
    @CheckForNull
    private final TFile root;
    @CheckForNull
    private final FileFilter filter;
    private final Comparator<? super TFile> comparator;
    private final EventListenerList listeners = new EventListenerList();

    public TFileTreeModel(@CheckForNull TFile root2, @CheckForNull FileFilter filter2, Comparator<? super TFile> comparator) {
        if (null != root2 && 0 != comparator.compare(root2, root2)) {
            throw new IllegalArgumentException();
        }
        this.root = root2;
        this.filter = filter2;
        this.comparator = Objects.requireNonNull(comparator);
    }

    @Override
    public TFile getRoot() {
        return this.root;
    }

    @Override
    public TFile getChild(Object parent, int index2) {
        return this.getChildren((TFile)parent)[index2];
    }

    @Override
    public int getChildCount(Object parent) {
        TFile[] children = this.getChildren((TFile)parent);
        return null == children ? 0 : children.length;
    }

    @Override
    public boolean isLeaf(Object node2) {
        return !((TFile)node2).isDirectory();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        TFile[] children = this.getChildren((TFile)parent);
        if (null == children) {
            return -1;
        }
        int l = children.length;
        for (int i = 0; i < l; ++i) {
            if (!children[i].equals(child)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private TFile[] getChildren(TFile parent) {
        assert (parent != null);
        TFile[] children = this.cache.get(parent);
        if (null == children) {
            if (this.cache.containsKey(parent)) {
                return null;
            }
            children = parent.listFiles(this.filter);
            this.cache.put(parent, children);
            if (null != children) {
                Arrays.sort(children, this.comparator);
            }
        }
        return children;
    }

    @Nullable
    TreePath newTreePath(TFile node2) {
        Object[] elements = this.newPath(node2);
        return null == elements ? null : new TreePath(elements);
    }

    @Nullable
    private TFile[] newPath(TFile node2) {
        if (null == this.root) {
            return null;
        }
        return this.newPath(node2, 1);
    }

    @Nullable
    private TFile[] newPath(@CheckForNull TFile node2, int level) {
        TFile[] path;
        assert (this.root != null);
        if (this.root.equals(node2)) {
            path = new TFile[level];
            path[0] = this.root;
        } else if (null != node2) {
            path = this.newPath(node2.getParentFile(), level + 1);
            if (path != null) {
                path[path.length - level] = node2;
            }
        } else {
            path = null;
        }
        return path;
    }

    public boolean createNewFile(TFile node2) throws IOException {
        if (!node2.createNewFile()) {
            return false;
        }
        this.nodeInserted(node2);
        return true;
    }

    public void mkdir(TFile node2, boolean recursive) throws IOException {
        node2.mkdir(recursive);
        this.nodeInserted(node2);
    }

    public void cp(@WillClose InputStream in, TFile node2) throws IOException {
        TFile.cp(in, (File)node2);
        this.nodeInsertedOrStructureChanged(node2);
    }

    public void cp(TFile oldNode, TFile node2) throws IOException {
        TFile.cp((File)oldNode, (File)node2);
        this.nodeInsertedOrStructureChanged(node2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cp_r(TFile oldNode, TFile node2) throws IOException {
        try {
            oldNode.cp_r(node2);
        }
        finally {
            this.nodeInsertedOrStructureChanged(node2);
        }
    }

    public void cp_p(TFile oldNode, TFile node2) throws IOException {
        TFile.cp_p(oldNode, node2);
        this.nodeInsertedOrStructureChanged(node2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cp_rp(TFile oldNode, TFile node2) throws IOException {
        try {
            oldNode.cp_rp(node2);
        }
        finally {
            this.nodeInsertedOrStructureChanged(node2);
        }
    }

    public void mv(TFile oldNode, TFile node2) throws IOException {
        oldNode.mv(node2);
        this.nodeRemoved(oldNode);
        this.nodeInserted(node2);
    }

    public void rm(TFile node2) throws IOException {
        TFile.rm(node2);
        this.nodeRemoved(node2);
    }

    public void rm_r(TFile node2) throws IOException {
        TFile.rm_r(node2);
        this.nodeRemoved(node2);
    }

    public void nodeInsertedOrStructureChanged(TFile node2) {
        if (this.cache.containsKey(Objects.requireNonNull(node2))) {
            this.structureChanged(node2);
        } else {
            this.nodeInserted(node2);
        }
    }

    public void nodeInserted(TFile node2) {
        if (this.cache.containsKey(node2)) {
            return;
        }
        TFile parent = node2.getParentFile();
        this.forget(parent, false);
        int index2 = this.getIndexOfChild(parent, node2);
        if (index2 == -1) {
            return;
        }
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, this.newTreePath(parent), new int[]{index2}, (Object[])new TFile[]{node2}));
    }

    public void nodeChanged(TFile node2) {
        TFile parent = node2.getParentFile();
        int index2 = this.getIndexOfChild(parent, node2);
        if (index2 == -1) {
            return;
        }
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.newTreePath(parent), new int[]{index2}, (Object[])new TFile[]{node2}));
    }

    public void nodeRemoved(TFile node2) {
        TFile parent = node2.getParentFile();
        int index2 = this.getIndexOfChild(parent, node2);
        if (index2 == -1) {
            return;
        }
        this.forget(node2, true);
        this.forget(parent, false);
        this.getChildren(parent);
        this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, this.newTreePath(parent), new int[]{index2}, (Object[])new TFile[]{node2}));
    }

    public void refresh() {
        this.cache.clear();
        if (this.root != null) {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, this.newTreePath(this.root), null, null));
        }
    }

    public final void refresh(TFile node2) {
        this.structureChanged(node2);
    }

    public void structureChanged(TFile node2) {
        this.forget(Objects.requireNonNull(node2), true);
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, this.newTreePath(node2), null, null));
    }

    void forget(TFile node2) {
        this.forget(node2, true);
    }

    private void forget(@Nullable TFile node2, boolean childrenToo) {
        TFile[] children = this.cache.remove(node2);
        if (null != children && childrenToo) {
            int l = children.length;
            for (int i = 0; i < l; ++i) {
                this.forget(children[i], childrenToo);
            }
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(TreeModelListener.class, l);
    }

    protected void fireTreeNodesChanged(TreeModelEvent evt) {
        EventListener[] l = this.listeners.getListeners(TreeModelListener.class);
        int ll = l.length;
        for (int i = 0; i < ll; ++i) {
            ((TreeModelListener)l[i]).treeNodesChanged(evt);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent evt) {
        EventListener[] l = this.listeners.getListeners(TreeModelListener.class);
        int ll = l.length;
        for (int i = 0; i < ll; ++i) {
            ((TreeModelListener)l[i]).treeNodesInserted(evt);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent evt) {
        EventListener[] l = this.listeners.getListeners(TreeModelListener.class);
        int ll = l.length;
        for (int i = 0; i < ll; ++i) {
            ((TreeModelListener)l[i]).treeNodesRemoved(evt);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent evt) {
        EventListener[] l = this.listeners.getListeners(TreeModelListener.class);
        int ll = l.length;
        for (int i = 0; i < ll; ++i) {
            ((TreeModelListener)l[i]).treeStructureChanged(evt);
        }
    }
}

