/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access.swing;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.MessageFormat;
import javax.annotation.CheckForNull;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.swing.TDecoratingFileSystemView;
import net.java.truevfs.access.swing.TFileView;

public class TFileSystemView
extends TDecoratingFileSystemView {
    @CheckForNull
    private TArchiveDetector detector;

    public TFileSystemView() {
        this(FileSystemView.getFileSystemView(), null);
    }

    public TFileSystemView(FileSystemView fileSystemView) {
        this(fileSystemView, null);
    }

    public TFileSystemView(FileSystemView fileSystemView, @CheckForNull TArchiveDetector detector) {
        super(fileSystemView);
        this.detector = detector;
    }

    @CheckForNull
    public TArchiveDetector getDetector() {
        return this.detector;
    }

    public void setDetector(@CheckForNull TArchiveDetector detector) {
        this.detector = detector;
    }

    protected TFile wrap(File file) {
        return file instanceof TFile ? (TFile)file : new TFile(file, this.getDetector());
    }

    protected File unwrap(File file) {
        return file instanceof TFile ? ((TFile)file).getFile() : file;
    }

    @Override
    public boolean isRoot(File file) {
        return this.fsv.isRoot(this.unwrap(file));
    }

    @Override
    public Boolean isTraversable(File file) {
        return this.wrap(file).isDirectory();
    }

    @Override
    public String getSystemDisplayName(File file) {
        TFile tfile = this.wrap(file);
        if (tfile.isArchive() || tfile.isEntry()) {
            return tfile.getName();
        }
        return this.fsv.getSystemDisplayName(this.unwrap(file));
    }

    @Override
    public String getSystemTypeDescription(File file) {
        TFile tfile = this.wrap(file);
        String typeDescription = TFileView.typeDescription((File)tfile);
        if (typeDescription != null) {
            return typeDescription;
        }
        return this.fsv.getSystemTypeDescription(this.unwrap(file));
    }

    @Override
    public Icon getSystemIcon(File file) {
        TFile tfile = this.wrap(file);
        Icon icon = TFileView.icon((File)tfile);
        if (null != icon) {
            return icon;
        }
        File uFile = this.unwrap(file);
        return uFile.exists() ? this.fsv.getSystemIcon(uFile) : null;
    }

    @Override
    public boolean isParent(File folder, File file) {
        return this.fsv.isParent(this.wrap(folder), this.wrap(file)) || this.fsv.isParent(this.unwrap(folder), this.unwrap(file));
    }

    @Override
    public File getChild(File parent, String child) {
        TFile wParent = this.wrap(parent);
        if (wParent.isArchive() || wParent.isEntry()) {
            return this.createFileObject(this.fsv.getChild(wParent, child));
        }
        return this.createFileObject(this.fsv.getChild(this.unwrap(parent), child));
    }

    @Override
    public boolean isFileSystem(File file) {
        return this.fsv.isFileSystem(this.unwrap(file));
    }

    @Override
    public File createNewFolder(File parent) throws IOException {
        TFile wParent = this.wrap(parent);
        if (wParent.isArchive() || wParent.isEntry()) {
            TFile folder = new TFile((File)wParent, UIManager.getString(TFile.separatorChar == '\\' ? "FileChooser.win32.newFolder" : "FileChooser.other.newFolder"), this.getDetector());
            int i = 2;
            while (!folder.mkdirs()) {
                if (i > 100) {
                    throw new IOException(wParent + ": Could not create new directory entry!");
                }
                folder = new TFile((File)wParent, MessageFormat.format(UIManager.getString(TFile.separatorChar == '\\' ? "FileChooser.win32.newFolder.subsequent" : "FileChooser.other.newFolder.subsequent"), i), this.getDetector());
                ++i;
            }
            return folder;
        }
        return this.createFileObject(this.fsv.createNewFolder(this.unwrap(parent)));
    }

    @Override
    public boolean isHiddenFile(File file) {
        return this.fsv.isHiddenFile(this.unwrap(file));
    }

    @Override
    public boolean isFileSystemRoot(File file) {
        return this.fsv.isFileSystemRoot(this.unwrap(file));
    }

    @Override
    public boolean isDrive(File file) {
        return this.fsv.isDrive(this.unwrap(file));
    }

    @Override
    public boolean isFloppyDrive(File file) {
        return this.fsv.isFloppyDrive(this.unwrap(file));
    }

    @Override
    public boolean isComputerNode(File file) {
        return this.fsv.isComputerNode(this.unwrap(file));
    }

    @Override
    public File createFileObject(File dir, String filename) {
        return this.createFileObject(this.fsv.createFileObject(dir, filename));
    }

    @Override
    public File createFileObject(String path) {
        return this.createFileObject(this.fsv.createFileObject(path));
    }

    public File createFileObject(File file) {
        TFile tfile = this.wrap(file);
        return tfile.isArchive() || tfile.isEntry() ? tfile : this.unwrap(file);
    }

    @Override
    public File[] getFiles(File dir, final boolean useFileHiding) {
        TFile smartDir = this.wrap(dir);
        if (smartDir.isArchive() || smartDir.isEntry()) {
            class Filter
            implements FileFilter {
                Filter() {
                }

                @Override
                public boolean accept(File file) {
                    return !useFileHiding || !TFileSystemView.this.isHiddenFile(file);
                }
            }
            File[] files = smartDir.listFiles(new Filter());
            return null == files ? new TFile[]{} : files;
        }
        File[] files = this.fsv.getFiles(this.unwrap(dir), useFileHiding);
        int i = files.length;
        while (--i >= 0) {
            files[i] = this.createFileObject(files[i]);
        }
        return files;
    }

    @Override
    public File getParentDirectory(File file) {
        TFile tfile = this.wrap(file);
        if (tfile.isEntry()) {
            return this.createFileObject(tfile.getParentFile());
        }
        File dir = this.fsv.getParentDirectory(this.unwrap(file));
        return null == dir ? dir : this.createFileObject(dir);
    }
}

