/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.io.Streams;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.PathSplitter;
import net.java.truecommons.shed.Paths;
import net.java.truecommons.shed.UriBuilder;
import net.java.truevfs.access.ExpertFeature;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TBIO;
import net.java.truevfs.access.TConfig;
import net.java.truevfs.access.TFileInputStream;
import net.java.truevfs.access.TFileOutputStream;
import net.java.truevfs.access.TPath;
import net.java.truevfs.access.TRex;
import net.java.truevfs.access.TVFS;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsNode;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsNodePath;
import net.java.truevfs.kernel.spec.FsScheme;
import net.java.truevfs.kernel.spec.FsUriModifier;

@Immutable
public final class TFile
extends File
implements TRex {
    private static final long serialVersionUID = 3617072259051821745L;
    private static final String UNC_PREFIX = separator + separator;
    private static final Set<File> ROOTS = Collections.unmodifiableSet(new TreeSet<File>(Arrays.asList(TFile.listRoots())));
    private static final File CURRENT_DIRECTORY = new File(".");
    private static final BitField<Entry.Access> NO_ACCESS = BitField.noneOf(Entry.Access.class);
    private static final BitField<Entry.Access> READ_ACCESS = BitField.of(Entry.Access.READ);
    private static final BitField<Entry.Access> WRITE_ACCESS = BitField.of(Entry.Access.WRITE);
    private static final BitField<Entry.Access> EXECUTE_ACCESS = BitField.of(Entry.Access.EXECUTE);
    private transient File file;
    private transient TArchiveDetector detector;
    @CheckForNull
    private transient TFile innerArchive;
    @CheckForNull
    private transient TFile enclArchive;
    @CheckForNull
    private transient FsNodeName nodeName;
    @CheckForNull
    @SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
    private volatile transient FsController controller;

    public TFile(File file) {
        this(file, (TArchiveDetector)null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(File file, @CheckForNull TArchiveDetector detector) {
        super(file.getPath());
        if (file instanceof TFile) {
            TFile that = (TFile)file;
            this.file = that.file;
            this.detector = that.detector;
            if (null == detector || this.detector.equals(detector)) {
                this.enclArchive = that.getEnclArchive();
                this.nodeName = that.nodeName;
                this.innerArchive = that.isArchive() ? this : that.innerArchive;
                this.controller = that.controller;
            } else {
                this.detector = detector;
                this.scan(null);
            }
        } else {
            this.file = file;
            this.detector = null != detector ? detector : TConfig.current().getArchiveDetector();
            this.scan(null);
        }
        assert (this.invariants());
    }

    public TFile(String path) {
        this(path, (TArchiveDetector)null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(String path, @CheckForNull TArchiveDetector detector) {
        super(path);
        this.file = new File(path);
        this.detector = null != detector ? detector : TConfig.current().getArchiveDetector();
        this.scan(null);
        assert (this.invariants());
    }

    public TFile(@CheckForNull File parent, String child) {
        this(parent, child, null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(@CheckForNull File parent, String child, @CheckForNull TArchiveDetector detector) {
        super(parent, child);
        this.file = new File(parent, child);
        TArchiveDetector tArchiveDetector = this.detector = null != detector ? detector : TConfig.current().getArchiveDetector();
        if (parent instanceof TFile) {
            this.scan((TFile)parent);
        } else {
            this.scan(null);
        }
        assert (this.invariants());
    }

    public TFile(@CheckForNull String parent, String child) {
        this(parent, child, null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(@CheckForNull String parent, String child, @CheckForNull TArchiveDetector detector) {
        super(parent, child);
        this.file = new File(parent, child);
        this.detector = null != detector ? detector : TConfig.current().getArchiveDetector();
        this.scan(null);
        assert (this.invariants());
    }

    public TFile(URI uri) {
        this(uri, null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(URI uri, @CheckForNull TArchiveDetector detector) {
        this(FsNodePath.create(uri, FsUriModifier.CANONICALIZE), detector);
    }

    public TFile(FsNodePath path) {
        this(path, null);
    }

    @ExpertFeature(value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile(FsNodePath path, @CheckForNull TArchiveDetector detector) {
        super(path.toHierarchicalUri());
        this.parse(path, null != detector ? detector : TConfig.current().getArchiveDetector());
    }

    private void parse(FsNodePath path, TArchiveDetector detector) {
        this.file = new File(super.getPath());
        this.detector = detector;
        FsMountPoint mp = path.getMountPoint();
        FsNodePath mpp = mp.getPath();
        if (null == mpp) {
            assert (!path.getUri().isOpaque());
            this.enclArchive = null;
            this.nodeName = null;
            this.innerArchive = null;
        } else {
            FsNodeName nn = path.getNodeName();
            if (nn.isRoot()) {
                assert (path.getUri().isOpaque());
                if (mpp.getUri().isOpaque()) {
                    this.enclArchive = new TFile(mpp.getMountPoint(), detector);
                    this.nodeName = mpp.getNodeName();
                } else {
                    this.enclArchive = null;
                    this.nodeName = null;
                }
                this.innerArchive = this;
                this.controller = this.getController(mp);
            } else {
                assert (path.getUri().isOpaque());
                this.enclArchive = new TFile(mp, detector);
                this.nodeName = nn;
                this.innerArchive = this.enclArchive;
            }
        }
        assert (this.invariants());
    }

    private TFile(FsMountPoint mountPoint, TArchiveDetector detector) {
        super(mountPoint.toHierarchicalUri());
        this.file = new File(super.getPath());
        this.detector = detector;
        FsNodePath mpp = mountPoint.getPath();
        if (null == mpp) {
            assert (!mountPoint.getUri().isOpaque());
            this.enclArchive = null;
            this.nodeName = null;
            this.innerArchive = null;
        } else {
            assert (mountPoint.getUri().isOpaque());
            if (mpp.getUri().isOpaque()) {
                this.enclArchive = new TFile(mpp.getMountPoint(), detector);
                this.nodeName = mpp.getNodeName();
            } else {
                this.enclArchive = null;
                this.nodeName = null;
            }
            this.innerArchive = this;
            this.controller = this.getController(mountPoint);
        }
        assert (this.invariants());
    }

    private TFile(File file, @CheckForNull TFile innerArchive, TArchiveDetector detector) {
        super(file.getPath());
        this.file = file;
        String path = file.getPath();
        if (null != innerArchive) {
            int iapl = innerArchive.getPath().length();
            if (path.length() == iapl) {
                this.detector = innerArchive.detector;
                this.enclArchive = innerArchive.enclArchive;
                this.nodeName = innerArchive.nodeName;
                this.innerArchive = this;
                this.controller = innerArchive.controller;
            } else {
                this.detector = detector;
                this.innerArchive = this.enclArchive = innerArchive;
                try {
                    this.nodeName = new FsNodeName(new UriBuilder().path(path.substring(iapl + 1).replace(separatorChar, '/')).getUri(), FsUriModifier.CANONICALIZE);
                }
                catch (URISyntaxException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
        } else {
            this.detector = detector;
        }
        assert (this.invariants());
    }

    private void scan(@CheckForNull TFile ancestor) {
        String path = super.getPath();
        assert (ancestor == null || path.startsWith(ancestor.getPath()));
        assert (this.file.getPath().equals(path));
        assert (null != this.detector);
        StringBuilder nodeNameBuf = new StringBuilder(path.length());
        this.scan(this.detector, ancestor, 0, path, nodeNameBuf, new PathSplitter(separatorChar, false));
        try {
            this.nodeName = 0 >= nodeNameBuf.length() ? null : new FsNodeName(new UriBuilder().path(nodeNameBuf.toString()).getUri(), FsUriModifier.CANONICALIZE);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private void scan(TArchiveDetector detector, @CheckForNull TFile ancestor, int skip, String path, StringBuilder enclEntryNameBuf, PathSplitter splitter2) {
        if (path == null) {
            assert (null == this.enclArchive);
            enclEntryNameBuf.setLength(0);
            return;
        }
        splitter2.split(path);
        String parent = splitter2.getParentPath();
        String member = splitter2.getMemberName();
        if (0 != member.length() && !".".equals(member)) {
            if ("..".equals(member)) {
                ++skip;
            } else if (0 < skip) {
                --skip;
            } else {
                boolean isArchive;
                if (null != ancestor) {
                    int ancestorPathLen;
                    int pathLen = path.length();
                    if (pathLen == (ancestorPathLen = ancestor.getPath().length())) {
                        this.enclArchive = ancestor.innerArchive;
                        if (!ancestor.isArchive()) {
                            if (ancestor.isEntry()) {
                                assert (null != ancestor.nodeName);
                                if (0 < enclEntryNameBuf.length()) {
                                    enclEntryNameBuf.insert(0, '/');
                                    enclEntryNameBuf.insert(0, ancestor.nodeName.getPath());
                                } else {
                                    assert (this.enclArchive == ancestor.enclArchive);
                                    enclEntryNameBuf.append(ancestor.nodeName.getPath());
                                }
                            } else {
                                assert (null == this.enclArchive);
                                enclEntryNameBuf.setLength(0);
                            }
                        } else if (0 >= enclEntryNameBuf.length()) {
                            assert (this.enclArchive == ancestor);
                            this.innerArchive = this;
                            this.enclArchive = ancestor.enclArchive;
                            if (ancestor.nodeName != null) {
                                enclEntryNameBuf.append(ancestor.nodeName.getPath());
                            }
                        }
                        if (this != this.innerArchive) {
                            this.innerArchive = this.enclArchive;
                        }
                        return;
                    }
                    if (pathLen < ancestorPathLen) {
                        detector = ancestor.getArchiveDetector();
                        ancestor = ancestor.enclArchive;
                    }
                }
                boolean bl = isArchive = null != detector.scheme(path);
                if (0 < enclEntryNameBuf.length()) {
                    if (isArchive) {
                        this.enclArchive = new TFile(path, detector);
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                        }
                        return;
                    }
                    enclEntryNameBuf.insert(0, '/');
                    enclEntryNameBuf.insert(0, member);
                } else {
                    if (isArchive) {
                        this.innerArchive = this;
                    }
                    enclEntryNameBuf.append(member);
                }
            }
        }
        this.scan(detector, ancestor, skip, parent, enclEntryNameBuf, splitter2);
    }

    private Object writeReplace() throws ObjectStreamException {
        return this.getAbsoluteFile();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getUri());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.parse(FsNodePath.create((URI)in.readObject(), FsUriModifier.CANONICALIZE), TConfig.current().getArchiveDetector());
    }

    private boolean invariants() {
        File file = this.file;
        TFile innerArchive = this.innerArchive;
        TFile enclArchive = this.enclArchive;
        FsNodeName nodeName = this.nodeName;
        assert (null != file);
        assert (!(file instanceof TFile));
        assert (file.getPath().equals(super.getPath()));
        assert (null != this.detector);
        assert (null != innerArchive == (this.getInnerEntryName() != null));
        assert (null != enclArchive == (null != nodeName));
        assert (this != enclArchive);
        assert (this == innerArchive ^ (innerArchive == enclArchive && null == this.controller));
        assert (null == enclArchive || Paths.contains(enclArchive.getPath(), file.getParentFile().getPath(), separatorChar) && !nodeName.toString().isEmpty());
        return true;
    }

    @Override
    public TArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public TFile toNonArchiveFile() {
        if (!this.isArchive()) {
            return this;
        }
        return new TFile((File)this.getParentFile(), this.getName(), TArchiveDetector.NULL);
    }

    @Nullable
    public TFile getNonArchivedParentFile() {
        TFile enclArchive = this.enclArchive;
        return null != enclArchive ? enclArchive.getNonArchivedParentFile() : this.getParentFile();
    }

    @Override
    @Nullable
    public String getParent() {
        return this.file.getParent();
    }

    @Override
    @Nullable
    public TFile getParentFile() {
        File parent = this.file.getParentFile();
        if (parent == null) {
            return null;
        }
        TFile enclArchive = this.enclArchive;
        if (null != enclArchive && enclArchive.getPath().length() == parent.getPath().length()) {
            assert (enclArchive.getPath().equals(parent.getPath()));
            return enclArchive;
        }
        return new TFile(parent, enclArchive, this.getArchiveDetector());
    }

    @Override
    public TFile getAbsoluteFile() {
        String p = this.getAbsolutePath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.getArchiveDetector());
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public TFile getNormalizedAbsoluteFile() {
        String p = this.getNormalizedAbsolutePath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.getArchiveDetector());
    }

    public String getNormalizedAbsolutePath() {
        return Paths.normalize(this.getAbsolutePath(), separatorChar);
    }

    public TFile getNormalizedFile() {
        String p = this.getNormalizedPath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.getArchiveDetector());
    }

    public String getNormalizedPath() {
        return Paths.normalize(this.getPath(), separatorChar);
    }

    @Override
    public TFile getCanonicalFile() throws IOException {
        String p = this.getCanonicalPath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.getArchiveDetector());
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.file.getCanonicalPath();
    }

    public TFile getCanOrAbsFile() {
        String p = this.getCanOrAbsPath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.getArchiveDetector());
    }

    public String getCanOrAbsPath() {
        try {
            return this.getCanonicalPath();
        }
        catch (IOException ex) {
            return Paths.normalize(this.getAbsolutePath(), separatorChar);
        }
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    public boolean isArchive() {
        return this == this.innerArchive;
    }

    public boolean isEntry() {
        return null != this.nodeName;
    }

    @CheckForNull
    public TFile getInnerArchive() {
        return this.innerArchive;
    }

    @Nullable
    public String getInnerEntryName() {
        FsNodeName nodeName;
        return this == this.innerArchive ? FsNodeName.ROOT.getPath() : (null == (nodeName = this.nodeName) ? null : nodeName.getPath());
    }

    @CheckForNull
    public TFile getEnclArchive() {
        return this.enclArchive;
    }

    @Nullable
    public String getEnclEntryName() {
        return null == this.nodeName ? null : this.nodeName.getPath();
    }

    public boolean isTopLevelArchive() {
        return this.getTopLevelArchive() == this;
    }

    @Nullable
    public TFile getTopLevelArchive() {
        TFile enclArchive = this.enclArchive;
        return null != enclArchive ? enclArchive.getTopLevelArchive() : this.innerArchive;
    }

    @Deprecated
    public File getFile() {
        return this.file;
    }

    @Nullable
    FsController getController() {
        FsMountPoint mountPoint;
        FsController controller2 = this.controller;
        if (this != this.innerArchive || null != controller2) {
            return controller2;
        }
        File file = this.file;
        String path = Paths.normalize(file.getPath(), separatorChar);
        FsScheme scheme = this.getArchiveDetector().scheme(path);
        if (null == scheme) {
            throw new ServiceConfigurationError("Unknown file system scheme for path \"" + path + "\"! Check run-time class path configuration.");
        }
        try {
            TFile enclArchive = this.enclArchive;
            FsNodeName nodeName = this.nodeName;
            assert (null != enclArchive == (null != nodeName));
            mountPoint = new FsMountPoint(scheme, null == enclArchive ? new FsNodePath(file) : new FsNodePath(enclArchive.getController().getModel().getMountPoint(), nodeName));
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
        this.controller = this.getController(mountPoint);
        return this.controller;
    }

    private FsController getController(FsMountPoint mountPoint) {
        return TConfig.current().getManager().controller(this.getArchiveDetector(), mountPoint);
    }

    public boolean isParentOf(File file) {
        String a = this.getAbsolutePath();
        String b = file.getAbsoluteFile().getParent();
        return b != null ? Paths.contains(a, b, separatorChar) : false;
    }

    @Override
    public boolean isAbsolute() {
        return this.file.isAbsolute();
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    public boolean contains(File file) {
        return TFile.contains(this, file);
    }

    public static boolean contains(File a, File b) {
        return Paths.contains(a.getAbsolutePath(), b.getAbsolutePath(), separatorChar);
    }

    public boolean isFileSystemRoot() {
        TFile canOrAbsFile = this.getCanOrAbsFile();
        return ROOTS.contains(canOrAbsFile) || TFile.isUNC(canOrAbsFile.getPath());
    }

    public boolean isUNC() {
        return TFile.isUNC(this.getCanOrAbsPath());
    }

    private static boolean isUNC(String path) {
        return path.startsWith(UNC_PREFIX) && path.indexOf(separatorChar, 2) > 2;
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        return this.file.equals(that);
    }

    @Override
    public int compareTo(File that) {
        return this.file.compareTo(that);
    }

    @Override
    public FsNodePath getNodePath() {
        try {
            if (this == this.innerArchive) {
                FsScheme scheme = this.getScheme();
                if (null != this.enclArchive) {
                    assert (null != this.nodeName);
                    return new FsNodePath(new FsMountPoint(scheme, new FsNodePath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.nodeName)), FsNodeName.ROOT);
                }
                return new FsNodePath(new FsMountPoint(scheme, new FsNodePath(this.file)), FsNodeName.ROOT);
            }
            if (null != this.enclArchive) {
                assert (null != this.nodeName);
                return new FsNodePath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.nodeName);
            }
            return new FsNodePath(this.file);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public FsMountPoint getMountPoint() {
        return this.getNodePath().getMountPoint();
    }

    @Override
    public FsNodeName getNodeName() {
        return this == this.innerArchive ? FsNodeName.ROOT : this.nodeName;
    }

    @Nullable
    private FsScheme getScheme() {
        if (this != this.innerArchive) {
            return null;
        }
        FsController controller2 = this.controller;
        if (null != controller2) {
            return controller2.getModel().getMountPoint().getScheme();
        }
        return this.getArchiveDetector().scheme(this.file.getPath());
    }

    @Override
    public URI getUri() {
        try {
            if (this == this.innerArchive) {
                FsScheme scheme = this.getScheme();
                if (null != this.enclArchive) {
                    assert (null != this.nodeName);
                    return new FsMountPoint(scheme, new FsNodePath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.nodeName)).getUri();
                }
                return new FsMountPoint(scheme, new FsNodePath(this.file)).getUri();
            }
            if (null != this.enclArchive) {
                assert (null != this.nodeName);
                return new FsNodePath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.nodeName).getUri();
            }
            return this.file.toURI();
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public URI toURI() {
        return this.getUri();
    }

    @Override
    @Deprecated
    public URL toURL() throws MalformedURLException {
        return null != this.innerArchive ? this.toURI().toURL() : this.file.toURL();
    }

    @Override
    public TFile toFile() {
        return this;
    }

    @Override
    public TPath toPath() {
        return new TPath(this);
    }

    @Override
    public String toString() {
        return this.file.toString();
    }

    private static BitField<FsAccessOption> getAccessPreferences() {
        return TConfig.current().getAccessPreferences();
    }

    @Override
    public boolean exists() {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().checkAccess(TFile.getAccessPreferences(), this.getNodeName(), NO_ACCESS);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.exists();
    }

    @Override
    public boolean isFile() {
        if (null != this.innerArchive) {
            try {
                FsNode entry2 = this.innerArchive.getController().node(TFile.getAccessPreferences(), this.getNodeName());
                return null != entry2 && entry2.isType(Entry.Type.FILE);
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        if (null != this.innerArchive) {
            try {
                FsNode entry2 = this.innerArchive.getController().node(TFile.getAccessPreferences(), this.getNodeName());
                return null != entry2 && entry2.isType(Entry.Type.DIRECTORY);
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.isDirectory();
    }

    @Override
    public boolean canRead() {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().checkAccess(TFile.getAccessPreferences(), this.getNodeName(), READ_ACCESS);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().checkAccess(TFile.getAccessPreferences(), this.getNodeName(), WRITE_ACCESS);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.canWrite();
    }

    @Override
    public boolean canExecute() {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().checkAccess(TFile.getAccessPreferences(), this.getNodeName(), EXECUTE_ACCESS);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.canExecute();
    }

    @Override
    public boolean setReadOnly() {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().setReadOnly(TFile.getAccessPreferences(), this.getNodeName());
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.setReadOnly();
    }

    @Override
    public long length() {
        if (null != this.innerArchive) {
            FsNode entry2;
            try {
                entry2 = this.innerArchive.getController().node(TFile.getAccessPreferences(), this.getNodeName());
            }
            catch (IOException ex) {
                return 0L;
            }
            if (null == entry2) {
                return 0L;
            }
            long size2 = entry2.getSize(Entry.Size.DATA);
            return -1L != size2 ? size2 : 0L;
        }
        return this.file.length();
    }

    @Override
    public long lastModified() {
        if (null != this.innerArchive) {
            FsNode entry2;
            try {
                entry2 = this.innerArchive.getController().node(TFile.getAccessPreferences(), this.getNodeName());
            }
            catch (IOException ex) {
                return 0L;
            }
            if (null == entry2) {
                return 0L;
            }
            long time = entry2.getTime(Entry.Access.WRITE);
            return -1L != time ? time : 0L;
        }
        return this.file.lastModified();
    }

    @Override
    public boolean setLastModified(long time) {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().setTime(TFile.getAccessPreferences(), this.getNodeName(), WRITE_ACCESS, time);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.setLastModified(time);
    }

    @Override
    @Nullable
    public String[] list() {
        if (null != this.innerArchive) {
            FsNode entry2;
            try {
                entry2 = this.innerArchive.getController().node(TFile.getAccessPreferences(), this.getNodeName());
            }
            catch (IOException ex) {
                return null;
            }
            if (null == entry2) {
                return null;
            }
            Set<String> members = entry2.getMembers();
            return null == members ? null : members.toArray(new String[members.size()]);
        }
        return this.file.list();
    }

    @Override
    @Nullable
    public String[] list(@CheckForNull FilenameFilter filter2) {
        if (null != this.innerArchive) {
            FsNode entry2;
            try {
                entry2 = this.innerArchive.getController().node(TFile.getAccessPreferences(), this.getNodeName());
            }
            catch (IOException ex) {
                return null;
            }
            Set<String> members = TFile.members(entry2);
            if (null == members) {
                return null;
            }
            if (null == filter2) {
                return members.toArray(new String[members.size()]);
            }
            ArrayList<String> accepted = new ArrayList<String>(members.size());
            for (String member : members) {
                if (!filter2.accept(this, member)) continue;
                accepted.add(member);
            }
            return accepted.toArray(new String[accepted.size()]);
        }
        return this.file.list(filter2);
    }

    @Nullable
    public TFile[] listFiles() {
        return this.listFiles((FilenameFilter)null);
    }

    @Nullable
    public TFile[] listFiles(@CheckForNull FilenameFilter filter2) {
        if (null != this.innerArchive) {
            FsNode entry2;
            try {
                entry2 = this.innerArchive.getController().node(TFile.getAccessPreferences(), this.getNodeName());
            }
            catch (IOException ex) {
                return null;
            }
            return this.filter(TFile.members(entry2), filter2);
        }
        return this.filter(TFile.list(this.file.list(filter2)), (FilenameFilter)null);
    }

    @CheckForNull
    private static Set<String> members(@CheckForNull FsNode entry2) {
        return null == entry2 ? null : entry2.getMembers();
    }

    @CheckForNull
    private static List<String> list(@CheckForNull String[] list2) {
        return null == list2 ? null : Arrays.asList(list2);
    }

    @Nullable
    private TFile[] filter(@CheckForNull Collection<String> members, @CheckForNull FilenameFilter filter2) {
        if (null == members) {
            return null;
        }
        TArchiveDetector detector = TConfig.current().getArchiveDetector();
        if (null != filter2) {
            ArrayList<TFile> accepted = new ArrayList<TFile>(members.size());
            for (String member : members) {
                if (!filter2.accept(this, member)) continue;
                accepted.add(new TFile((File)this, member, detector));
            }
            return accepted.toArray(new TFile[accepted.size()]);
        }
        TFile[] accepted = new TFile[members.size()];
        int i = 0;
        for (String member : members) {
            accepted[i++] = new TFile((File)this, member, detector);
        }
        return accepted;
    }

    @Nullable
    public TFile[] listFiles(@CheckForNull FileFilter filter2) {
        if (null != this.innerArchive) {
            FsNode entry2;
            try {
                entry2 = this.innerArchive.getController().node(TFile.getAccessPreferences(), this.getNodeName());
            }
            catch (IOException ex) {
                return null;
            }
            return this.filter(TFile.members(entry2), filter2);
        }
        return this.filter(TFile.list(this.file.list()), filter2);
    }

    @Nullable
    private TFile[] filter(@CheckForNull Collection<String> members, @CheckForNull FileFilter filter2) {
        if (null == members) {
            return null;
        }
        TArchiveDetector detector = TConfig.current().getArchiveDetector();
        if (null != filter2) {
            ArrayList<TFile> accepted = new ArrayList<TFile>(members.size());
            for (String member : members) {
                TFile file = new TFile((File)this, member, detector);
                if (!filter2.accept(file)) continue;
                accepted.add(file);
            }
            return accepted.toArray(new TFile[accepted.size()]);
        }
        TFile[] accepted = new TFile[members.size()];
        int i = 0;
        for (String member : members) {
            accepted[i++] = new TFile((File)this, member, detector);
        }
        return accepted;
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().make(TFile.getAccessPreferences().set(FsAccessOption.EXCLUSIVE), this.getNodeName(), Entry.Type.FILE, null);
                return true;
            }
            catch (FileAlreadyExistsException ex) {
                return false;
            }
        }
        return this.file.createNewFile();
    }

    @Override
    public boolean mkdirs() {
        if (null == this.innerArchive) {
            return this.file.mkdirs();
        }
        TFile parent = this.getParentFile();
        if (null != parent && !parent.exists()) {
            parent.mkdirs();
        }
        return this.mkdir();
    }

    @Override
    public boolean mkdir() {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().make(TFile.getAccessPreferences(), this.getNodeName(), Entry.Type.DIRECTORY, null);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.file.mkdir();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TFile mkdir(boolean recursive) throws IOException {
        TFile innerArchive = this.innerArchive;
        if (null != innerArchive) {
            TFile parent;
            if (recursive && null != (parent = this.getParentFile()) && !parent.exists()) {
                parent.mkdir(recursive);
            }
            FsController controller2 = innerArchive.getController();
            FsNodeName innerEntryName = this.getNodeName();
            try {
                controller2.make(TFile.getAccessPreferences(), innerEntryName, Entry.Type.DIRECTORY, null);
                return this;
            }
            catch (IOException ex) {
                FsNode entry2 = controller2.node(TFile.getAccessPreferences(), innerEntryName);
                if (null != entry2 && entry2.isType(Entry.Type.DIRECTORY)) return this;
                throw ex;
            }
        } else {
            File dir = this.file;
            if ((!recursive ? dir.mkdir() : dir.mkdirs()) || dir.isDirectory()) return this;
            throw new FileSystemException(dir.getPath(), null, "Cannot create directory!");
        }
    }

    @Override
    @Deprecated
    public boolean delete() {
        try {
            TFile.rm(this);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public TFile rm() throws IOException {
        TFile.rm(this);
        return this;
    }

    public static void rm(File file) throws IOException {
        if (file instanceof TFile) {
            TFile tfile = (TFile)file;
            if (null != tfile.innerArchive) {
                tfile.innerArchive.getController().unlink(TFile.getAccessPreferences(), tfile.getNodeName());
                return;
            }
            file = tfile.file;
        }
        if (!file.delete()) {
            throw new FileSystemException(file.getPath(), null, "Cannot delete!");
        }
    }

    public TFile rm_r() throws IOException {
        TBIO.rm_r(this, this.getArchiveDetector());
        return this;
    }

    public static void rm_r(File file) throws IOException {
        TBIO.rm_r(file, file instanceof TFile ? ((TFile)file).getArchiveDetector() : TArchiveDetector.NULL);
    }

    @Override
    public void deleteOnExit() {
        if (this.innerArchive != null) {
            throw new UnsupportedOperationException();
        }
        this.file.deleteOnExit();
    }

    @Override
    @Deprecated
    public boolean renameTo(File dst) {
        try {
            TFile.mv(this, dst, this.getArchiveDetector());
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public TFile mv(File dst) throws IOException {
        TFile.mv(this, dst, TConfig.current().getArchiveDetector());
        return this;
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void mv(File src, File dst, TArchiveDetector detector) throws IOException {
        File dstDelegate;
        boolean dstArchived;
        File srcDelegate;
        boolean srcArchived;
        if (src instanceof TFile) {
            TFile srcFile = (TFile)src;
            srcArchived = null != srcFile.getInnerArchive();
            srcDelegate = srcFile.getFile();
        } else {
            srcArchived = false;
            srcDelegate = src;
        }
        if (dst instanceof TFile) {
            TFile dstFile = (TFile)dst;
            dstArchived = null != dstFile.getInnerArchive();
            dstDelegate = dstFile.getFile();
        } else {
            dstArchived = false;
            dstDelegate = dst;
        }
        if (!srcArchived && !dstArchived) {
            if (srcDelegate.renameTo(dstDelegate)) {
                return;
            }
            throw new FileSystemException(src.getPath(), dst.getPath(), "Cannot rename.");
        }
        TBIO.mv(src, dst, detector);
    }

    public static void cp(@WillClose InputStream in, @WillClose OutputStream out) throws IOException {
        Streams.copy(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cp(@WillClose InputStream in, File dst) throws IOException {
        Objects.requireNonNull(in);
        TFileOutputStream out = null;
        try {
            out = new TFileOutputStream(dst);
        }
        finally {
            if (null == out) {
                in.close();
            }
        }
        try {
            TFile.cp(in, (OutputStream)out);
        }
        catch (IOException ex) {
            TFile.rm(dst);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cp(File src, @WillClose OutputStream out) throws IOException {
        Objects.requireNonNull(out);
        TFileInputStream in = null;
        try {
            in = new TFileInputStream(src);
        }
        finally {
            if (null == in) {
                out.close();
            }
        }
        TFile.cp((InputStream)in, out);
    }

    public TFile cp(File dst) throws IOException {
        TBIO.cp(false, this, dst);
        return this;
    }

    public static void cp(File src, File dst) throws IOException {
        TBIO.cp(false, src, dst);
    }

    public TFile cp_p(File dst) throws IOException {
        TBIO.cp(true, this, dst);
        return this;
    }

    public static void cp_p(File src, File dst) throws IOException {
        TBIO.cp(true, src, dst);
    }

    public TFile cp_r(File dst) throws IOException {
        TArchiveDetector detector = TConfig.current().getArchiveDetector();
        TBIO.cp_r(false, this, dst, detector, detector);
        return this;
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void cp_r(File src, File dst, TArchiveDetector detector) throws IOException {
        TBIO.cp_r(false, src, dst, detector, detector);
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void cp_r(File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        TBIO.cp_r(false, src, dst, srcDetector, dstDetector);
    }

    public TFile cp_rp(File dst) throws IOException {
        TArchiveDetector detector = TConfig.current().getArchiveDetector();
        TBIO.cp_r(true, this, dst, detector, detector);
        return this;
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void cp_rp(File src, File dst, TArchiveDetector detector) throws IOException {
        TBIO.cp_r(true, src, dst, detector, detector);
    }

    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    public static void cp_rp(File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        TBIO.cp_r(true, src, dst, srcDetector, dstDetector);
    }

    public void input(@WillNotClose InputStream in) throws IOException {
        Objects.requireNonNull(in);
        try (TFileOutputStream out = new TFileOutputStream(this);){
            Streams.cat(in, out);
        }
        catch (IOException ex) {
            TFile.rm(this);
            throw ex;
        }
    }

    public void output(@WillNotClose OutputStream out) throws IOException {
        Objects.requireNonNull(out);
        try (TFileInputStream in = new TFileInputStream(this);){
            Streams.cat(in, out);
        }
    }

    public static void cat(@WillNotClose InputStream in, @WillNotClose OutputStream out) throws IOException {
        Streams.cat(in, out);
    }

    public TFile compact() throws IOException {
        if (this.isTopLevelArchive()) {
            TFile.compact(this);
        }
        return this;
    }

    private static void compact(TFile grown) throws IOException {
        grown = grown.getNormalizedFile();
        assert (grown.isArchive());
        File dir = TFile.parent(grown);
        String extension2 = TFile.extension(grown);
        try (TConfig config = TConfig.open();){
            config.setAccessPreference(FsAccessOption.GROW, false);
            TFile compact = new TFile(TFile.createTempFile("tzp", extension2, dir));
            compact.rm();
            try {
                grown.cp_rp(compact);
                TVFS.umount(grown);
                TVFS.umount(compact);
                if (!TFile.move(compact.toNonArchiveFile(), grown.toNonArchiveFile())) {
                    throw new FileSystemException(compact.getPath(), grown.getPath(), "Cannot move!");
                }
            }
            catch (IOException ex) {
                try {
                    compact.rm();
                }
                catch (IOException ex2) {
                    ex.addSuppressed(ex2);
                }
                throw ex;
            }
        }
    }

    private static File parent(File file) {
        File parent = file.getParentFile();
        return null != parent ? parent : CURRENT_DIRECTORY;
    }

    @Nullable
    private static String extension(TFile file) {
        FsScheme scheme = file.getScheme();
        return null != scheme ? "." + scheme : null;
    }

    private static boolean move(File src, File dst) {
        return src.exists() && (!dst.exists() || dst.delete()) && src.renameTo(dst);
    }
}

