/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public final class Buffers {
    private Buffers() {
    }

    @Nullable
    public static ByteBuffer byteBuffer(@CheckForNull String string2) {
        return null == string2 ? null : Buffers.byteBuffer(CharBuffer.wrap(string2));
    }

    @Nullable
    public static ByteBuffer byteBuffer(@CheckForNull char[] password) {
        return null == password ? null : Buffers.byteBuffer(CharBuffer.wrap(password));
    }

    @Nullable
    public static ByteBuffer byteBuffer(CharBuffer cb) {
        if (null == cb) {
            return null;
        }
        try {
            return Buffers.encode(cb, StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
        }
        catch (CharacterCodingException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    private static ByteBuffer encode(CharBuffer icb, CharsetEncoder enc) throws CharacterCodingException {
        int bytes = (int)((float)icb.remaining() * enc.averageBytesPerChar());
        while (true) {
            ByteBuffer obb = ByteBuffer.allocateDirect(bytes);
            CoderResult cr = enc.encode(icb.duplicate(), obb, true);
            if (cr.isUnderflow()) {
                enc.flush(obb);
            }
            obb.flip();
            if (cr.isUnderflow()) {
                return obb;
            }
            if (!cr.isOverflow()) {
                cr.throwException();
                throw new AssertionError();
            }
            Buffers.fill(obb, (byte)0);
            bytes = 2 * bytes + 1;
        }
    }

    @Nullable
    public static String string(@CheckForNull ByteBuffer bb) {
        return null == bb ? null : Buffers.charBuffer(bb).toString();
    }

    @Nullable
    public static char[] charArray(@CheckForNull ByteBuffer bb) {
        if (null == bb) {
            return null;
        }
        CharBuffer ocb = Buffers.charBuffer(bb);
        char[] oca = new char[ocb.remaining()];
        ocb.duplicate().get(oca);
        Buffers.fill(ocb, '\u0000');
        return oca;
    }

    @Nullable
    public static CharBuffer charBuffer(@CheckForNull ByteBuffer bb) {
        if (null == bb) {
            return null;
        }
        CharsetDecoder dec = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        try {
            return Buffers.decode(bb, dec);
        }
        catch (CharacterCodingException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    private static CharBuffer decode(ByteBuffer ibb, CharsetDecoder dec) throws CharacterCodingException {
        int bytes = (int)((float)(2 * ibb.remaining()) * dec.averageCharsPerByte());
        while (true) {
            CharBuffer ocb = ByteBuffer.allocateDirect(bytes).asCharBuffer();
            CoderResult cr = dec.decode(ibb.duplicate(), ocb, true);
            if (cr.isUnderflow()) {
                dec.flush(ocb);
            }
            ocb.flip();
            if (cr.isUnderflow()) {
                return ocb;
            }
            if (!cr.isOverflow()) {
                cr.throwException();
                throw new AssertionError();
            }
            Buffers.fill(ocb, '\u0000');
            bytes = 2 * bytes + 2;
        }
    }

    public static void fill(@CheckForNull ByteBuffer bb, byte value2) {
        if (null == bb) {
            return;
        }
        int position = bb.position();
        int limit = bb.limit();
        for (int i = position; i < limit; ++i) {
            bb.put(i, value2);
        }
    }

    public static void fill(@CheckForNull CharBuffer cb, char value2) {
        if (null == cb) {
            return;
        }
        int position = cb.position();
        int limit = cb.limit();
        for (int i = position; i < limit; ++i) {
            cb.put(i, value2);
        }
    }

    @Nullable
    public static ByteBuffer copy(@CheckForNull ByteBuffer bb) {
        return null == bb ? null : (ByteBuffer)ByteBuffer.allocateDirect(bb.remaining()).put(bb.duplicate()).rewind();
    }
}

