/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class BitField<E extends Enum<E>>
implements Iterable<E>,
Serializable {
    private static final long serialVersionUID = 3203876204846746524L;
    private final EnumSet<E> bits;

    public static <E extends Enum<E>> BitField<E> noneOf(Class<E> elementType) {
        return new BitField<E>(elementType, false);
    }

    public static <E extends Enum<E>> BitField<E> allOf(Class<E> elementType) {
        return new BitField<E>(elementType, true);
    }

    public static <E extends Enum<E>> BitField<E> of(E bit) {
        return new BitField<E>(bit);
    }

    public static <E extends Enum<E>> BitField<E> of(E bit, E ... bits2) {
        return new BitField(bit, bits2);
    }

    public static <E extends Enum<E>> BitField<E> copyOf(Collection<E> bits2) {
        return new BitField<E>(EnumSet.copyOf(bits2));
    }

    public static <E extends Enum<E>> BitField<E> of(Class<E> elementType, String list2) {
        EnumSet<E> bits2 = EnumSet.noneOf(elementType);
        for (String bit : list2.split("\\|")) {
            bits2.add(Enum.valueOf(elementType, bit));
        }
        return new BitField<E>(bits2);
    }

    private BitField(Class<E> elementType, boolean allOf) {
        this.bits = allOf ? EnumSet.allOf(elementType) : EnumSet.noneOf(elementType);
    }

    private BitField(E bit) {
        this.bits = EnumSet.of(bit);
    }

    private BitField(E bit, E ... bits2) {
        this.bits = EnumSet.of(bit, bits2);
    }

    private BitField(EnumSet<E> bits2) {
        assert (null != bits2);
        this.bits = bits2;
    }

    public boolean isEmpty() {
        return this.bits.isEmpty();
    }

    public int cardinality() {
        return this.bits.size();
    }

    public boolean get(E bit) {
        return this.bits.contains(bit);
    }

    public boolean is(E bit) {
        return this.bits.contains(bit);
    }

    public BitField<E> set(E bit, boolean set) {
        Object bits2;
        if (set) {
            if (this.bits.contains(bit)) {
                return this;
            }
            bits2 = this.bits.clone();
            ((AbstractCollection)bits2).add(bit);
        } else {
            if (!this.bits.contains(bit)) {
                return this;
            }
            bits2 = this.bits.clone();
            ((AbstractCollection)bits2).remove(bit);
        }
        return new BitField<E>(bits2);
    }

    public BitField<E> set(E bit) {
        return this.set(bit, true);
    }

    public BitField<E> clear(E bit) {
        return this.set(bit, false);
    }

    public BitField<E> not() {
        return new BitField<E>(EnumSet.complementOf(this.bits));
    }

    public BitField<E> and(BitField<E> that) {
        Object bits2 = this.bits.clone();
        return ((AbstractCollection)bits2).retainAll(that.bits) ? new BitField<E>(bits2) : this;
    }

    public BitField<E> or(BitField<E> that) {
        Object bits2 = this.bits.clone();
        return ((AbstractCollection)bits2).addAll(that.bits) ? new BitField<E>(bits2) : this;
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableSet(this.bits).iterator();
    }

    public EnumSet<E> toEnumSet() {
        return this.bits.clone();
    }

    public boolean equals(@CheckForNull Object that) {
        return this == that || that instanceof BitField && this.bits.equals(((BitField)that).bits);
    }

    public int hashCode() {
        return this.bits.hashCode();
    }

    public String toString() {
        int capacity = this.bits.size() * 11;
        if (0 >= capacity) {
            return "";
        }
        StringBuilder s2 = new StringBuilder(capacity);
        for (Enum bit : this.bits) {
            if (s2.length() > 0) {
                s2.append('|');
            }
            s2.append(bit);
        }
        return s2.toString();
    }
}

