/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec.prompting;

import java.net.URI;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.spec.AbstractKeyManager;
import net.java.truecommons.key.spec.prompting.PromptingKey;
import net.java.truecommons.key.spec.prompting.PromptingKeyProvider;
import net.java.truecommons.key.spec.prompting.SharedKeyManager;

@ThreadSafe
public class PromptingKeyManager<K extends PromptingKey<K>>
extends AbstractKeyManager<K> {
    private final SharedKeyManager<K> manager = new SharedKeyManager();
    private final PromptingKey.View<K> view;

    public PromptingKeyManager(PromptingKey.View<K> view) {
        this.view = Objects.requireNonNull(view);
    }

    public final PromptingKey.View<K> getView() {
        return this.view;
    }

    @Override
    public PromptingKeyProvider<K> provider(URI resource) {
        return new PromptingKeyProvider<K>(this, resource, this.manager.provider(resource));
    }

    @Override
    public void link(URI oldResource, URI newResource) {
        this.manager.link(oldResource, newResource);
    }

    @Override
    public void unlink(URI resource) {
        this.manager.unlink(resource);
    }

    @Override
    public void release(URI resource) {
        this.resetCancelledKey(resource);
    }

    protected void resetCancelledKey(URI resource) {
        this.manager.resetCancelledKey(resource);
    }

    protected void resetUnconditionally(URI resource) {
        this.manager.resetUnconditionally(resource);
    }

    @Override
    public String toString() {
        return String.format("%s[view=%s]", this.getClass().getName(), this.getView());
    }
}

