/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.macosx.keychain;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.java.truecommons.key.macosx.keychain.Keychain;
import net.java.truecommons.key.macosx.keychain.Security;

final class KeychainUtils {
    private KeychainUtils() {
    }

    @Nullable
    static Security.SecKeychainAttributeList list(@CheckForNull Map<Keychain.AttributeClass, ByteBuffer> map2) {
        if (null == map2) {
            return null;
        }
        Security.SecKeychainAttributeList list2 = new Security.SecKeychainAttributeList();
        int size2 = map2.size();
        if (0 >= size2) {
            return list2;
        }
        Security.SecKeychainAttribute[] array = (Security.SecKeychainAttribute[])new Security.SecKeychainAttribute().toArray(size2);
        int count2 = 0;
        for (Map.Entry<Keychain.AttributeClass, ByteBuffer> entry2 : map2.entrySet()) {
            Keychain.AttributeClass id = entry2.getKey();
            if (null == id) continue;
            Security.SecKeychainAttribute attr = array[count2++];
            attr.tag = id.getTag();
            ByteBuffer buffer = entry2.getValue();
            if (null != buffer) {
                int length = buffer.remaining();
                Pointer data2 = KeychainUtils.malloc(length);
                buffer.mark();
                data2.getByteBuffer(0L, length).put(buffer);
                buffer.reset();
                attr.length = length;
                attr.data = data2;
            }
            attr.write();
        }
        list2.count = count2;
        if (0 < count2) {
            list2.attr = array[0].getPointer();
        }
        return list2;
    }

    private static Pointer malloc(int size2) {
        if (0 < size2) {
            return new Memory(size2);
        }
        if (0 == size2) {
            return (Memory)new Memory(4L).share(0L, 0L);
        }
        throw new IllegalArgumentException("" + size2);
    }

    @Nullable
    static Map<Keychain.AttributeClass, ByteBuffer> map(@CheckForNull Security.SecKeychainAttributeList list2) {
        Security.SecKeychainAttribute[] array;
        if (null == list2) {
            return null;
        }
        EnumMap<Keychain.AttributeClass, ByteBuffer> map2 = new EnumMap<Keychain.AttributeClass, ByteBuffer>(Keychain.AttributeClass.class);
        int count2 = list2.count;
        if (0 >= count2) {
            return map2;
        }
        Security.SecKeychainAttribute attr = new Security.SecKeychainAttribute(list2.attr);
        attr.read();
        for (Security.SecKeychainAttribute attr2 : array = (Security.SecKeychainAttribute[])attr.toArray(count2)) {
            Pointer data2;
            Keychain.AttributeClass id = Keychain.AttributeClass.lookup(attr2.tag);
            if (null == id || null == (data2 = attr2.data)) continue;
            int length = attr2.length;
            ByteBuffer buffer = (ByteBuffer)ByteBuffer.allocateDirect(length).put(data2.getByteBuffer(0L, length)).flip();
            map2.put(id, buffer);
        }
        return map2;
    }

    static Security.SecKeychainAttributeInfo info(Keychain.AttributeClass ... ids) {
        int length;
        Security.SecKeychainAttributeInfo info = new Security.SecKeychainAttributeInfo();
        info.count = length = ids.length;
        int size2 = length << 2;
        Memory tag = new Memory(size2 << 1);
        Pointer format2 = ((Pointer)tag).share(size2, size2);
        info.tag = tag;
        info.format = format2;
        int offset = 0;
        for (Keychain.AttributeClass id : ids) {
            ((Pointer)tag).setInt(offset, id.getTag());
            format2.setInt(offset, 0);
            offset += 4;
        }
        return info;
    }
}

