/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.UnsupportedEncodingException;
import org.apache.http.Consts;

public final class EncodingUtils {
    public static String getString(byte[] data2, int offset, int length, String charset) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return new String(data2, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(data2, offset, length);
        }
    }

    public static String getString(byte[] data2, String charset) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        return EncodingUtils.getString(data2, 0, data2.length, charset);
    }

    public static byte[] getBytes(String data2, String charset) {
        if (data2 == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return data2.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            return data2.getBytes();
        }
    }

    public static byte[] getAsciiBytes(String data2) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return data2.getBytes(Consts.ASCII.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] data2, int offset, int length) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return new String(data2, offset, length, Consts.ASCII.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] data2) {
        if (data2 == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        return EncodingUtils.getAsciiString(data2, 0, data2.length);
    }

    private EncodingUtils() {
    }
}

