/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.ParserCursor;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class NetscapeDraftHeaderParser {
    public static final NetscapeDraftHeaderParser DEFAULT = new NetscapeDraftHeaderParser();

    public HeaderElement parseHeader(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        NameValuePair nvp = this.parseNameValuePair(buffer, cursor);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            NameValuePair param2 = this.parseNameValuePair(buffer, cursor);
            params.add(param2);
        }
        return new BasicHeaderElement(nvp.getName(), nvp.getValue(), params.toArray(new NameValuePair[params.size()]));
    }

    private NameValuePair parseNameValuePair(CharArrayBuffer buffer, ParserCursor cursor) {
        char ch;
        int pos;
        boolean terminated2 = false;
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        String name = null;
        for (pos = cursor.getPos(); pos < indexTo && (ch = buffer.charAt(pos)) != '='; ++pos) {
            if (ch != ';') continue;
            terminated2 = true;
            break;
        }
        if (pos == indexTo) {
            terminated2 = true;
            name = buffer.substringTrimmed(indexFrom, indexTo);
        } else {
            name = buffer.substringTrimmed(indexFrom, pos);
            ++pos;
        }
        if (terminated2) {
            cursor.updatePos(pos);
            return new BasicNameValuePair(name, null);
        }
        String value2 = null;
        int i1 = pos;
        while (pos < indexTo) {
            char ch2 = buffer.charAt(pos);
            if (ch2 == ';') {
                terminated2 = true;
                break;
            }
            ++pos;
        }
        int i2 = pos;
        while (i1 < i2 && HTTP.isWhitespace(buffer.charAt(i1))) {
            ++i1;
        }
        while (i2 > i1 && HTTP.isWhitespace(buffer.charAt(i2 - 1))) {
            --i2;
        }
        value2 = buffer.substring(i1, i2);
        if (terminated2) {
            ++pos;
        }
        cursor.updatePos(pos);
        return new BasicNameValuePair(name, value2);
    }
}

