/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.kernel.spec.FsAbstractNode;
import net.java.truevfs.kernel.spec.FsArchiveDriver;
import net.java.truevfs.kernel.spec.FsArchiveEntry;

@NotThreadSafe
public final class FsCovariantNode<E extends FsArchiveEntry>
extends FsAbstractNode
implements Cloneable {
    private final String name;
    private EnumMap<Entry.Type, E> map = new EnumMap(Entry.Type.class);
    @Nullable
    private Entry.Type key;
    @Nullable
    private LinkedHashSet<String> members;

    public FsCovariantNode(String path) {
        this.name = path.toString();
    }

    public FsCovariantNode<E> clone(FsArchiveDriver<E> driver) {
        FsCovariantNode clone2;
        try {
            clone2 = (FsCovariantNode)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
        clone2.map = new EnumMap<Entry.Type, E>(Entry.Type.class);
        EnumMap<Entry.Type, E> cloneMap = clone2.map;
        for (Map.Entry<Entry.Type, E> mapping : this.map.entrySet()) {
            FsArchiveEntry entry2 = (FsArchiveEntry)mapping.getValue();
            cloneMap.put(mapping.getKey(), driver.newEntry(entry2.getName(), entry2.getType(), entry2));
        }
        LinkedHashSet<String> members = this.members;
        if (null != members) {
            clone2.members = (LinkedHashSet)members.clone();
        }
        return clone2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isRoot() {
        return this.name.isEmpty();
    }

    @Nullable
    public Entry.Type getKey() {
        return this.key;
    }

    public void setKey(@Nullable Entry.Type type) {
        this.key = type;
    }

    @Nullable
    public E put(Entry.Type type, E entry2) {
        this.key = type;
        return (E)((FsArchiveEntry)this.map.put(this.key, entry2));
    }

    @Nullable
    public E remove(Entry.Type type) {
        return (E)((FsArchiveEntry)this.map.remove((Object)type));
    }

    @Nullable
    public E get(Entry.Type type) {
        return (E)((FsArchiveEntry)this.map.get((Object)type));
    }

    @Nullable
    public E getEntry() {
        return (E)((FsArchiveEntry)this.map.get((Object)this.key));
    }

    public Collection<E> getEntries() {
        return this.map.values();
    }

    @Override
    public BitField<Entry.Type> getTypes() {
        return BitField.copyOf(this.map.keySet());
    }

    @Override
    public boolean isType(Entry.Type type) {
        return this.map.containsKey((Object)type);
    }

    @Override
    public long getSize(Entry.Size type) {
        if (Entry.Type.DIRECTORY == this.key) {
            return -1L;
        }
        return ((FsArchiveEntry)this.map.get((Object)this.key)).getSize(type);
    }

    @Override
    public long getTime(Entry.Access type) {
        return ((FsArchiveEntry)this.map.get((Object)this.key)).getTime(type);
    }

    @Override
    public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
        return ((FsArchiveEntry)this.map.get((Object)this.key)).isPermitted(type, entity);
    }

    @Override
    @Nullable
    public Set<String> getMembers() {
        if (!this.isType(Entry.Type.DIRECTORY)) {
            this.members = null;
            return null;
        }
        LinkedHashSet<String> m = this.members;
        return null != m ? m : (this.members = new LinkedHashSet());
    }

    public boolean add(String member) {
        return this.getMembers().add(member);
    }

    public boolean remove(String member) {
        return this.getMembers().remove(member);
    }
}

