/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.shed.AbstractExceptionBuilder;

@NotThreadSafe
public class PriorityExceptionBuilder<X extends Throwable>
extends AbstractExceptionBuilder<X, X> {
    private final Comparator<? super X> comparator;
    private final List<X> exceptions;

    public PriorityExceptionBuilder(Comparator<? super X> comparator) {
        this.comparator = comparator;
        if (null == this.comparator) {
            throw new NullPointerException();
        }
        this.exceptions = new LinkedList<X>();
    }

    @Override
    protected final X update(X input2, @CheckForNull X assembly) {
        this.exceptions.add(input2);
        return null == assembly ? input2 : (this.comparator.compare(input2, assembly) > 0 ? input2 : assembly);
    }

    @Override
    protected final X post(X selection) {
        Iterator<X> i = this.exceptions.iterator();
        while (i.hasNext()) {
            Throwable exception = (Throwable)i.next();
            if (selection != exception) {
                ((Throwable)selection).addSuppressed(exception);
            }
            i.remove();
        }
        assert (this.exceptions.isEmpty());
        return selection;
    }
}

