/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.swing.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.swing.JOptionPane;

@NotThreadSafe
public class Windows {
    private static final String PROPERTY_FOCUSED_WINDOW = "focusedWindow";
    private static Reference<KeyboardFocusManager> lastFocusManager = new WeakReference<Object>(null);
    private static Reference<Window> lastFocusedWindow = new WeakReference<Object>(null);
    private static final PropertyChangeListener focusListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Windows.setLastFocusedWindow((Window)evt.getNewValue());
        }
    };

    private Windows() {
    }

    public static Window getParentWindow() {
        Window w = Windows.findFirstShowingWindow(Windows.getLastFocusedWindow());
        if (null == w && null == (w = Windows.getAnyShowingWindow())) {
            w = JOptionPane.getRootFrame();
        }
        return w;
    }

    @CheckForNull
    private static Window findFirstShowingWindow(Window w) {
        for (Container c = w; c != null; c = c.getParent()) {
            if (!(c instanceof Window) || !((Component)c).isShowing()) continue;
            return c;
        }
        return null;
    }

    @Nullable
    public static Window getLastFocusedWindow() {
        Windows.observeFocusedWindow();
        return lastFocusedWindow.get();
    }

    private static void observeFocusedWindow() {
        KeyboardFocusManager lfm = lastFocusManager.get();
        KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (fm == lfm) {
            return;
        }
        if (null != lfm) {
            lfm.removePropertyChangeListener(PROPERTY_FOCUSED_WINDOW, focusListener);
        }
        fm.addPropertyChangeListener(PROPERTY_FOCUSED_WINDOW, focusListener);
        lastFocusManager = new WeakReference<KeyboardFocusManager>(fm);
        Windows.setLastFocusedWindow(fm.getFocusedWindow());
    }

    private static void setLastFocusedWindow(Window w) {
        if (!(null != w && w.isShowing() || null == (w = lastFocusedWindow.get()) || w.isShowing())) {
            w = null;
        }
        lastFocusedWindow = new WeakReference<Window>(w);
    }

    @CheckForNull
    private static Window getAnyShowingWindow() {
        return Windows.getAnyShowingWindow(Frame.getFrames());
    }

    @CheckForNull
    private static Window getAnyShowingWindow(Window[] windows) {
        for (Window window : windows) {
            if (window.isShowing()) {
                return window;
            }
            if ((window = Windows.getAnyShowingWindow(window.getOwnedWindows())) == null) continue;
            return window;
        }
        return null;
    }
}

