/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec.util;

import javax.annotation.concurrent.Immutable;

@Immutable
public class SuspensionPenalty {
    public static final int MIN_KEY_RETRY_DELAY = 3000;

    private SuspensionPenalty() {
    }

    public static long enforce(long last2) {
        long start = System.currentTimeMillis();
        long elapsed = start - last2;
        long delay2 = 3000L - elapsed;
        if (0L < delay2) {
            SuspensionPenalty.pause(delay2);
            return start + delay2;
        }
        return start;
    }

    private static void pause(long millis) {
        long start = System.currentTimeMillis();
        boolean interrupted = false;
        do {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interrupt) {
                interrupted = true;
            }
        } while (0L < (millis -= System.currentTimeMillis() - start));
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

