/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.macosx;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.macosx.OsxKeyProvider;
import net.java.truecommons.key.macosx.keychain.DuplicateItemException;
import net.java.truecommons.key.macosx.keychain.Keychain;
import net.java.truecommons.key.macosx.keychain.KeychainException;
import net.java.truecommons.key.spec.AbstractKeyManager;
import net.java.truecommons.key.spec.AbstractSecretKey;
import net.java.truecommons.key.spec.KeyManager;
import net.java.truecommons.key.spec.KeyProvider;
import net.java.truecommons.key.spec.prompting.AbstractPromptingPbeParameters;
import net.java.truecommons.logging.LocalizedLogger;
import net.java.truecommons.shed.Buffers;
import org.slf4j.Logger;

@ThreadSafe
public final class OsxKeyManager<P extends AbstractPromptingPbeParameters<P, ?>>
extends AbstractKeyManager<P> {
    private static final String KEYCHAIN = "TrueCommons KeyManager";
    private static final String ACCOUNT = "TrueCommons KeyManager";
    private static final Logger logger = new LocalizedLogger(OsxKeyManager.class);
    private final KeyManager<P> manager;
    private final Class<P> keyClass;
    private Keychain keychain;
    private volatile boolean skip;

    public OsxKeyManager(KeyManager<P> manager, Class<P> keyClass) {
        this.manager = Objects.requireNonNull(manager);
        this.keyClass = Objects.requireNonNull(keyClass);
    }

    @Override
    public KeyProvider<P> provider(URI resource) {
        return new OsxKeyProvider<P>(this, resource, this.manager.provider(resource));
    }

    @Override
    public void link(URI oldResource, URI newResource) {
        P param2 = this.getKey(oldResource);
        this.manager.link(oldResource, newResource);
        this.setKey(newResource, param2);
    }

    @Override
    public void unlink(URI resource) {
        this.manager.unlink(resource);
        this.setKey(resource, null);
    }

    @Override
    public void release(URI resource) {
        this.skip = false;
        this.manager.release(resource);
    }

    @CheckForNull
    P getKey(URI resource) {
        return (P)((AbstractPromptingPbeParameters)this.access(resource, new Action<P>(){

            @Override
            public P call(Keychain keychain, Map<Keychain.AttributeClass, ByteBuffer> attributes) throws KeychainException {
                class Read
                implements Keychain.Visitor {
                    @CheckForNull
                    private P param;

                    Read() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void visit(Keychain.Item item) throws KeychainException {
                        this.param = (AbstractPromptingPbeParameters)OsxKeyManager.deserialize(item.getAttribute(Keychain.AttributeClass.GENERIC));
                        if (null == this.param) {
                            try {
                                this.param = (AbstractPromptingPbeParameters)OsxKeyManager.this.keyClass.newInstance();
                            }
                            catch (IllegalAccessException | InstantiationException ex) {
                                logger.debug("getKey.exception", ex);
                                return;
                            }
                        }
                        assert (null == ((AbstractSecretKey)this.param).getSecret());
                        ByteBuffer secret = item.getSecret();
                        try {
                            ((AbstractSecretKey)this.param).setSecret(secret);
                        }
                        finally {
                            Buffers.fill(secret, (byte)0);
                        }
                    }
                }
                Read read2 = new Read();
                keychain.visitItems(Keychain.ItemClass.GENERIC_PASSWORD, attributes, read2);
                return read2.param;
            }
        }));
    }

    void setKey(URI resource, final @CheckForNull P param2) {
        this.access(resource, new Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call(Keychain keychain, Map<Keychain.AttributeClass, ByteBuffer> attributes) throws KeychainException {
                if (null != param2) {
                    final ByteBuffer newSecret = param2.getSecret();
                    if (null == newSecret) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        final ByteBuffer newXml = OsxKeyManager.serialize(param2);
                        final AbstractPromptingPbeParameters newParam = (AbstractPromptingPbeParameters)OsxKeyManager.deserialize(newXml);
                        try {
                            attributes.put(Keychain.AttributeClass.GENERIC, newXml);
                            keychain.createItem(Keychain.ItemClass.GENERIC_PASSWORD, attributes, newSecret);
                        }
                        catch (DuplicateItemException ex) {
                            attributes.remove((Object)Keychain.AttributeClass.GENERIC);
                            class Update
                            implements Keychain.Visitor {
                                Update() {
                                }

                                @Override
                                public void visit(Keychain.Item item) throws KeychainException {
                                    ByteBuffer oldXml;
                                    AbstractPromptingPbeParameters oldParam;
                                    ByteBuffer oldSecret = item.getSecret();
                                    if (!newSecret.equals(oldSecret)) {
                                        item.setSecret(newSecret);
                                    }
                                    if (!newParam.equals(oldParam = (AbstractPromptingPbeParameters)OsxKeyManager.deserialize(oldXml = item.getAttribute(Keychain.AttributeClass.GENERIC)))) {
                                        item.setAttribute(Keychain.AttributeClass.GENERIC, newXml);
                                    }
                                }
                            }
                            keychain.visitItems(Keychain.ItemClass.GENERIC_PASSWORD, attributes, new Update());
                        }
                    }
                    finally {
                        Buffers.fill(newSecret, (byte)0);
                    }
                } else {
                    class Delete
                    implements Keychain.Visitor {
                        Delete() {
                        }

                        @Override
                        public void visit(Keychain.Item item) throws KeychainException {
                            item.delete();
                        }
                    }
                    keychain.visitItems(Keychain.ItemClass.GENERIC_PASSWORD, attributes, new Delete());
                }
                return null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    static ByteBuffer serialize(@CheckForNull Object object) {
        if (null == object) {
            return null;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(512);){
            try (XMLEncoder _ = new XMLEncoder(bos);){
                _.writeObject(object);
            }
            bos.flush();
            ByteBuffer byteBuffer = Buffers.copy(ByteBuffer.wrap(bos.toByteArray()));
            return byteBuffer;
        }
        catch (IOException ex) {
            logger.warn("serialize.exception", ex);
            return null;
        }
    }

    @CheckForNull
    static Object deserialize(@CheckForNull ByteBuffer xml) {
        if (null == xml) {
            return null;
        }
        byte[] array = new byte[xml.remaining()];
        xml.duplicate().get(array);
        try (XMLDecoder _ = new XMLDecoder(new ByteArrayInputStream(array));){
            AbstractPromptingPbeParameters abstractPromptingPbeParameters = (AbstractPromptingPbeParameters)_.readObject();
            return abstractPromptingPbeParameters;
        }
    }

    @CheckForNull
    private <T> T access(URI resource, Action<T> action) {
        if (this.skip) {
            return null;
        }
        try {
            return action.call(this.open(), OsxKeyManager.attributes(resource));
        }
        catch (KeychainException ex) {
            this.skip = true;
            logger.debug("access.exception", ex);
            return null;
        }
    }

    private static Map<Keychain.AttributeClass, ByteBuffer> attributes(URI resource) {
        EnumMap<Keychain.AttributeClass, ByteBuffer> m = new EnumMap<Keychain.AttributeClass, ByteBuffer>(Keychain.AttributeClass.class);
        m.put(Keychain.AttributeClass.ACCOUNT, Buffers.byteBuffer("TrueCommons KeyManager"));
        m.put(Keychain.AttributeClass.SERVICE, Buffers.byteBuffer(resource.toString()));
        return m;
    }

    private synchronized Keychain open() throws KeychainException {
        if (null != this.keychain) {
            return this.keychain;
        }
        this.keychain = Keychain.open("TrueCommons KeyManager", null);
        return this.keychain;
    }

    private synchronized void close() {
        try (Keychain _ = this.keychain;){
            this.keychain = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.close();
        }
    }

    private static interface Action<T> {
        @CheckForNull
        public T call(Keychain var1, Map<Keychain.AttributeClass, ByteBuffer> var2) throws KeychainException;
    }
}

